/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cf;

import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.http.HTTPSession;
import ch.cyberduck.core.http.StickyHostConfiguration;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.ssl.AbstractX509TrustManager;
import ch.cyberduck.core.ssl.CustomTrustSSLProtocolSocketFactory;
import ch.cyberduck.core.ssl.IgnoreX509TrustManager;
import ch.cyberduck.core.ssl.KeychainX509TrustManager;
import ch.cyberduck.core.ssl.SSLSession;
import com.mosso.client.cloudfiles.FilesClient;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Logger;

public class CFSession
extends HTTPSession
implements SSLSession {
    private static Logger log = Logger.getLogger(CFSession.class);
    private AbstractX509TrustManager trustManager;
    protected FilesClient CF;

    public AbstractX509TrustManager getTrustManager() {
        if (null == this.trustManager) {
            if (Preferences.instance().getBoolean("cf.tls.acceptAnyCertificate")) {
                this.setTrustManager(new IgnoreX509TrustManager());
            } else {
                this.setTrustManager(new KeychainX509TrustManager(this.host.getHostname()));
            }
        }
        return this.trustManager;
    }

    public void setTrustManager(AbstractX509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    protected CFSession(Host h) {
        super(h);
    }

    protected void connect() throws IOException, ConnectionCanceledException, LoginCanceledException {
        if (this.isConnected()) {
            return;
        }
        this.CF = new FilesClient();
        this.fireConnectionWillOpenEvent();
        this.message(MessageFormat.format(Locale.localizedString("Opening {0} connection to {1}", "Status"), this.host.getProtocol().getName(), this.host.getHostname()));
        this.CF.setConnectionTimeOut(this.timeout());
        StickyHostConfiguration hostConfiguration = new StickyHostConfiguration();
        hostConfiguration.setHost(this.host.getHostname(), this.host.getPort(), new org.apache.commons.httpclient.protocol.Protocol(this.host.getProtocol().getScheme(), (ProtocolSocketFactory)new CustomTrustSSLProtocolSocketFactory(this.getTrustManager()), this.host.getPort()));
        this.CF.setHostConfiguration((HostConfiguration)hostConfiguration);
        this.CF.setUserAgent(this.getUserAgent());
        this.login();
        this.message(MessageFormat.format(Locale.localizedString("{0} connection opened", "Status"), this.host.getProtocol().getName()));
        this.fireConnectionDidOpenEvent();
    }

    protected void login(Credentials credentials) throws IOException {
        this.CF.setUserName(credentials.getUsername());
        this.CF.setPassword(credentials.getPassword());
        this.getTrustManager().setHostname(URI.create(this.CF.getAuthenticationURL()).getHost());
        if (!this.CF.login()) {
            this.message(Locale.localizedString("Login failed", "Credentials"));
            this.login.fail(this.host, Locale.localizedString("Login with username and password", "Credentials"));
            this.login();
        }
        this.getTrustManager().setHostname(URI.create(this.CF.getStorageURL()).getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.isConnected()) {
                this.fireConnectionWillCloseEvent();
            }
            Object var2_1 = null;
            this.CF = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.CF = null;
            this.fireConnectionDidCloseEvent();
            throw throwable;
        }
        this.fireConnectionDidCloseEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        try {
            super.interrupt();
            if (this.isConnected()) {
                this.fireConnectionWillCloseEvent();
            }
            Object var2_1 = null;
            this.CF = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.CF = null;
            this.fireConnectionDidCloseEvent();
            throw throwable;
        }
        this.fireConnectionDidCloseEvent();
    }

    public Path workdir() throws IOException {
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        if (null == this.workdir) {
            this.workdir = PathFactory.createPath((Session)this, "/", 10);
        }
        return this.workdir;
    }

    protected void noop() {
    }

    public void sendCommand(String command) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isConnected() {
        return this.CF != null;
    }

    static {
        SessionFactory.addFactory(Protocol.MOSSO, new Factory());
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new CFSession(h);
        }
    }
}

