/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cloud;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.cloud.Distribution;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CloudPath
extends Path {
    private static Logger log = Logger.getLogger(CloudPath.class);

    public <T> CloudPath(T dict) {
        super(dict);
    }

    protected CloudPath(String parent, String name, int type) {
        super(parent, name, type);
    }

    protected CloudPath(String path, int type) {
        super(path, type);
    }

    protected CloudPath(String parent, Local local) {
        super(parent, local);
    }

    @Override
    public Path getParent() {
        Path parent = super.getParent();
        if (parent.isRoot()) {
            parent.attributes.setType(10);
        }
        return parent;
    }

    public boolean isContainer() {
        return this.getParent().isRoot();
    }

    public String getContainerName() {
        if (this.isRoot()) {
            return null;
        }
        CloudPath bucketname = this;
        while (!bucketname.isContainer()) {
            bucketname = (CloudPath)bucketname.getParent();
        }
        return bucketname.getName();
    }

    public String getKey() {
        if (this.isContainer()) {
            return null;
        }
        if (this.getAbsolute().startsWith("/" + this.getContainerName())) {
            return this.getAbsolute().substring(this.getContainerName().length() + 2);
        }
        return null;
    }

    public abstract void writeDistribution(boolean var1, String[] var2, boolean var3);

    public abstract Distribution readDistribution();
}

