/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.AbstractLoginController;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Proxy;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.dav.DAVResource;
import ch.cyberduck.core.http.HTTPSession;
import ch.cyberduck.core.i18n.Locale;
import java.io.IOException;
import java.net.InetAddress;
import java.text.MessageFormat;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.webdav.lib.WebdavResource;

public class DAVSession
extends HTTPSession {
    private static Logger log = Logger.getLogger(DAVSession.class);
    protected DAVResource DAV;

    protected DAVSession(Host h) {
        super(h);
    }

    public void check() throws IOException {
        super.check();
        if (this.isConnected()) {
            this.DAV.clearHeaders();
        }
    }

    protected void configure() throws IOException {
        HttpClient client = this.DAV.getSessionInstance(this.DAV.getHttpURL(), false);
        client.getHostConfiguration().getParams().setParameter("http.useragent", (Object)this.getUserAgent());
        if (Proxy.isHTTPProxyEnabled()) {
            this.DAV.setProxy(Proxy.getHTTPProxyHost(), Proxy.getHTTPProxyPort());
        }
        this.DAV.setFollowRedirects(Preferences.instance().getBoolean("webdav.followRedirects"));
    }

    protected void connect() throws IOException, LoginCanceledException {
        if (this.isConnected()) {
            return;
        }
        this.fireConnectionWillOpenEvent();
        this.message(MessageFormat.format(Locale.localizedString("Opening {0} connection to {1}", "Status"), this.host.getProtocol().getName(), this.host.getHostname()));
        WebdavResource.setDefaultAction((int)1);
        this.DAV = new DAVResource(this.host.toURL());
        String workdir = this.host.getDefaultPath();
        if (StringUtils.isNotBlank((String)workdir)) {
            this.DAV.setPath(workdir.startsWith("/") ? workdir : "/" + workdir);
        }
        this.configure();
        this.login();
        WebdavResource.setDefaultAction((int)3);
        this.message(MessageFormat.format(Locale.localizedString("{0} connection opened", "Status"), this.host.getProtocol().getName()));
        if (null == this.DAV.getResourceType() || !this.DAV.getResourceType().isCollection()) {
            throw new IOException("Listing directory failed");
        }
        this.fireConnectionDidOpenEvent();
    }

    public void setLoginController(final LoginController c) {
        this.login = new LoginController(){

            public void check(Host host) throws LoginCanceledException {
                Credentials credentials = host.getCredentials();
                if (!credentials.isValid() && Preferences.instance().getBoolean("connection.login.useKeychain")) {
                    credentials.setPassword(((AbstractLoginController)c).find(host));
                }
            }

            public void check(Host host, String reason) throws LoginCanceledException {
                c.check(host, reason);
            }

            public void success(Host host) {
                c.success(host);
            }

            public void fail(Host host, String reason) throws LoginCanceledException {
                c.fail(host, reason);
            }

            public void prompt(Host host, String reason, String message) throws LoginCanceledException {
                c.prompt(host, reason, message);
            }
        };
    }

    protected void login(final Credentials credentials) throws IOException, LoginCanceledException {
        try {
            HttpClient client = this.DAV.getSessionInstance(this.DAV.getHttpURL(), false);
            if (credentials.isValid()) {
                this.DAV.setCredentials((org.apache.commons.httpclient.Credentials)new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword()));
            }
            client.getParams().setParameter("http.authentication.preemptive", (Object)true);
            client.getParams().setParameter("http.authentication.credential-provider", (Object)new CredentialsProvider(){
                int retry = 0;

                public org.apache.commons.httpclient.Credentials getCredentials(AuthScheme authscheme, String hostname, int port, boolean proxy) throws CredentialsNotAvailableException {
                    if (null == authscheme) {
                        return null;
                    }
                    try {
                        StringBuffer realm = new StringBuffer(hostname);
                        realm.append(":").append(port).append(".");
                        if (StringUtils.isNotBlank((String)authscheme.getRealm())) {
                            realm.append(" ").append(authscheme.getRealm());
                        }
                        if (0 == this.retry) {
                            DAVSession.this.login.check(DAVSession.this.host, realm.toString());
                        } else {
                            DAVSession.this.login.fail(DAVSession.this.getHost(), realm.toString());
                        }
                        DAVSession.this.message(MessageFormat.format(Locale.localizedString("Authenticating as {0}", "Status"), credentials.getUsername()));
                        ++this.retry;
                        if (authscheme instanceof RFC2617Scheme) {
                            return new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword());
                        }
                        if (authscheme instanceof NTLMScheme) {
                            return new NTCredentials(credentials.getUsername(), credentials.getPassword(), InetAddress.getLocalHost().getHostName(), Preferences.instance().getProperty("webdav.ntlm.domain"));
                        }
                        throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
                    }
                    catch (LoginCanceledException e) {
                        throw new CredentialsNotAvailableException();
                    }
                    catch (IOException e) {
                        throw new CredentialsNotAvailableException();
                    }
                }
            });
            this.DAV.setProperties(3, 0);
            this.message(Locale.localizedString("Login successful", "Credentials"));
        }
        catch (HttpException e) {
            if (e.getReasonCode() == 401) {
                throw new LoginCanceledException();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.isConnected()) {
                this.fireConnectionWillCloseEvent();
                this.DAV.close();
            }
        }
        catch (IOException e) {
            log.error((Object)("IO Error: " + e.getMessage()));
        }
        finally {
            this.DAV = null;
            this.fireConnectionDidCloseEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        try {
            super.interrupt();
            this.fireConnectionWillCloseEvent();
            if (this.isConnected()) {
                this.DAV.close();
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        finally {
            this.DAV = null;
            this.fireConnectionDidCloseEvent();
        }
    }

    public Path workdir() throws ConnectionCanceledException {
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        if (null == this.workdir) {
            this.workdir = PathFactory.createPath((Session)this, "/", 10);
        }
        return this.workdir;
    }

    protected void setWorkdir(Path workdir) throws IOException {
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        this.DAV.setPath(workdir.isRoot() ? "/" : workdir.getAbsolute() + "/");
        this.workdir = workdir;
    }

    protected void noop() throws IOException {
    }

    public void sendCommand(String command) {
        throw new UnsupportedOperationException();
    }

    public boolean isConnected() {
        return this.DAV != null;
    }

    public void error(Path path, String message, Throwable e) {
        if (e instanceof HttpException) {
            super.error(path, message, new HttpException(HttpStatus.getStatusText((int)((HttpException)e).getReasonCode())));
        }
        super.error(path, message, e);
    }

    static {
        SessionFactory.addFactory(Protocol.WEBDAV, new Factory());
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new DAVSession(h);
        }
    }
}

