/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.davs;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Proxy;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.ssl.AbstractX509TrustManager;
import ch.cyberduck.core.ssl.CustomTrustSSLProtocolSocketFactory;
import ch.cyberduck.core.ssl.IgnoreX509TrustManager;
import ch.cyberduck.core.ssl.KeychainX509TrustManager;
import ch.cyberduck.core.ssl.SSLSession;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class DAVSSession
extends DAVSession
implements SSLSession {
    private AbstractX509TrustManager trustManager;

    protected DAVSSession(Host h) {
        super(h);
    }

    protected void configure() throws IOException {
        super.configure();
        HttpClient client = this.DAV.getSessionInstance(this.DAV.getHttpURL(), false);
        client.getHostConfiguration().setHost(this.host.getHostname(), this.host.getPort(), new org.apache.commons.httpclient.protocol.Protocol("https", (ProtocolSocketFactory)new CustomTrustSSLProtocolSocketFactory(this.getTrustManager()), this.host.getPort()));
        if (Proxy.isHTTPSProxyEnabled()) {
            this.DAV.setProxy(Proxy.getHTTPSProxyHost(), Proxy.getHTTPSProxyPort());
        }
    }

    public AbstractX509TrustManager getTrustManager() {
        if (null == this.trustManager) {
            if (Preferences.instance().getBoolean("webdav.tls.acceptAnyCertificate")) {
                this.setTrustManager(new IgnoreX509TrustManager());
            } else {
                this.setTrustManager(new KeychainX509TrustManager(this.host.getHostname()));
            }
        }
        return this.trustManager;
    }

    public void setTrustManager(AbstractX509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    static {
        SessionFactory.addFactory(Protocol.WEBDAV_SSL, new Factory());
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new DAVSSession(h);
        }
    }
}

