/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.FromNetASCIIInputStream;
import ch.cyberduck.core.io.FromNetASCIIOutputStream;
import ch.cyberduck.core.io.ToNetASCIIInputStream;
import ch.cyberduck.core.io.ToNetASCIIOutputStream;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPPath
extends Path {
    private static Logger log = Logger.getLogger(FTPPath.class);
    private static final String DOS_LINE_SEPARATOR = "\r\n";
    private static final String MAC_LINE_SEPARATOR = "\r";
    private static final String UNIX_LINE_SEPARATOR = "\n";
    private final FTPSession session;

    protected FTPPath(FTPSession s, String parent, String name, int type) {
        super(parent, name, type);
        this.session = s;
    }

    protected FTPPath(FTPSession s, String path, int type) {
        super(path, type);
        this.session = s;
    }

    protected FTPPath(FTPSession s, String parent, Local file) {
        super(parent, file);
        this.session = s;
    }

    protected <T> FTPPath(FTPSession s, T dict) {
        super(dict);
        this.session = s;
    }

    @Override
    public FTPSession getSession() {
        return this.session;
    }

    public AttributedList<Path> list() {
        AttributedList<Path> childs = new AttributedList<Path>();
        try {
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Listing directory {0}", "Status"), this.getName()));
            this.session.setWorkdir(this);
            FTPFileEntryParser parser = this.session.getFileParser();
            boolean success = this.parse(childs, parser, this.session.FTP.stat(this.getAbsolute()));
            if (!success || childs.isEmpty()) {
                this.session.FTP.setTransferType(FTPTransferType.ASCII);
                BufferedReader mlsd = this.session.FTP.mlsd(this.session.getEncoding());
                success = this.parse(childs, mlsd);
                if (null != mlsd) {
                    this.session.FTP.finishDir();
                }
                if (!success) {
                    BufferedReader lsa = this.session.FTP.list(this.session.getEncoding(), true);
                    success = this.parse(childs, parser, lsa);
                    if (null != lsa) {
                        this.session.FTP.finishDir();
                    }
                    if (!success) {
                        BufferedReader ls = this.session.FTP.list(this.session.getEncoding(), false);
                        success = this.parse(childs, parser, ls);
                        if (null != ls) {
                            this.session.FTP.finishDir();
                        }
                        if (!success) {
                            log.error((Object)"No compatible file listing method found");
                        }
                    }
                }
            }
            boolean dirChanged = false;
            for (Path child : childs) {
                if (child.attributes.getType() != 4) continue;
                try {
                    this.session.setWorkdir(child);
                    child.attributes.setType(6);
                    dirChanged = true;
                }
                catch (FTPException e) {
                    child.attributes.setType(5);
                }
            }
            if (dirChanged) {
                this.session.setWorkdir(this);
            }
        }
        catch (IOException e) {
            childs.attributes().setReadable(false);
            this.error("Listing directory failed", e);
        }
        return childs;
    }

    protected Map<String, Map<String, String>> parseFacts(String[] response) {
        HashMap<String, Map<String, String>> files = new HashMap<String, Map<String, String>>();
        for (String line : response) {
            files.putAll(this.parseFacts(line));
        }
        return files;
    }

    protected Map<String, Map<String, String>> parseFacts(String line) {
        Pattern p = Pattern.compile("\\s?(\\S+\\=\\S+;)*\\s(.*)");
        Matcher result = p.matcher(line);
        HashMap<String, Map<String, String>> file = new HashMap<String, Map<String, String>>();
        if (result.matches()) {
            String filename = result.group(2);
            HashMap<String, String> facts = new HashMap<String, String>();
            for (String fact : result.group(1).split(";")) {
                if (!fact.contains("=")) continue;
                facts.put(fact.split("=")[0].toLowerCase(), fact.split("=")[1].toLowerCase());
            }
            file.put(filename, facts);
        } else {
            log.warn((Object)("No match for " + line));
        }
        return file;
    }

    private boolean parse(AttributedList<Path> childs, BufferedReader reader) throws IOException {
        String line;
        if (null == reader) {
            return false;
        }
        boolean success = false;
        while ((line = reader.readLine()) != null) {
            Map<String, Map<String, String>> file = this.parseFacts(line);
            if (file.isEmpty()) continue;
            success = true;
            for (String name : file.keySet()) {
                Path parsed = PathFactory.createPath(this.session, this.getAbsolute(), name, 1);
                parsed.setParent(this);
                for (Map<String, String> facts : file.values()) {
                    if (!facts.containsKey("type")) continue;
                    if ("dir".equals(facts.get("type").toLowerCase())) {
                        parsed.attributes.setType(2);
                    } else if ("file".equals(facts.get("type").toLowerCase())) {
                        parsed.attributes.setType(1);
                    } else {
                        log.warn((Object)("Unsupported type: " + line));
                        continue;
                    }
                    if (facts.containsKey("sizd")) {
                        parsed.attributes.setSize(Long.parseLong(facts.get("sizd")));
                    }
                    if (facts.containsKey("size")) {
                        parsed.attributes.setSize(Long.parseLong(facts.get("size")));
                    }
                    if (facts.containsKey("unix.uid")) {
                        parsed.attributes.setOwner(facts.get("unix.uid"));
                    }
                    if (facts.containsKey("unix.owner")) {
                        parsed.attributes.setOwner(facts.get("unix.owner"));
                    }
                    if (facts.containsKey("unix.gid")) {
                        parsed.attributes.setGroup(facts.get("unix.gid"));
                    }
                    if (facts.containsKey("unix.group")) {
                        parsed.attributes.setGroup(facts.get("unix.group"));
                    }
                    if (facts.containsKey("unix.mode")) {
                        parsed.attributes.setPermission(new Permission(Integer.parseInt(facts.get("unix.mode"))));
                    }
                    if (facts.containsKey("modify")) {
                        parsed.attributes.setModificationDate(this.session.FTP.parseTimestamp(facts.get("modify")));
                    }
                    if (facts.containsKey("create")) {
                        parsed.attributes.setCreationDate(this.session.FTP.parseTimestamp(facts.get("create")));
                    }
                    childs.add(parsed);
                }
            }
        }
        return success;
    }

    private boolean parse(AttributedList<Path> childs, FTPFileEntryParser parser, BufferedReader reader) throws IOException {
        String line;
        if (null == reader) {
            return false;
        }
        boolean success = false;
        while ((line = parser.readNextEntry(reader)) != null) {
            Calendar timestamp;
            FTPFile f = parser.parseFTPEntry(line);
            if (null == f) continue;
            String name = f.getName();
            if (!success && this.getAbsolute().equals(name)) continue;
            success = true;
            if (name.equals(".") || name.equals("..")) continue;
            Path parsed = PathFactory.createPath(this.session, this.getAbsolute(), name.substring(name.lastIndexOf("/") + 1), 1);
            parsed.setParent(this);
            switch (f.getType()) {
                case 2: {
                    parsed.setSymbolicLinkPath(this.getAbsolute(), f.getLink());
                    parsed.attributes.setType(4);
                    break;
                }
                case 1: {
                    parsed.attributes.setType(2);
                }
            }
            parsed.attributes.setSize(f.getSize());
            parsed.attributes.setOwner(f.getUser());
            parsed.attributes.setGroup(f.getGroup());
            if (this.session.isPermissionSupported(parser)) {
                parsed.attributes.setPermission(new Permission(new boolean[][]{{f.hasPermission(0, 0), f.hasPermission(0, 1), f.hasPermission(0, 2)}, {f.hasPermission(1, 0), f.hasPermission(1, 1), f.hasPermission(1, 2)}, {f.hasPermission(2, 0), f.hasPermission(2, 1), f.hasPermission(2, 2)}}));
            }
            if ((timestamp = f.getTimestamp()) != null) {
                parsed.attributes.setModificationDate(timestamp.getTimeInMillis());
            }
            childs.add(parsed);
        }
        return success;
    }

    @Override
    public void mkdir(boolean recursive) {
        log.debug((Object)("mkdir:" + this.getName()));
        try {
            if (recursive && !this.getParent().exists()) {
                this.getParent().mkdir(recursive);
            }
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Making directory {0}", "Status"), this.getName()));
            this.session.setWorkdir(this.getParent());
            this.session.FTP.mkdir(this.getName());
        }
        catch (IOException e) {
            this.error("Cannot create folder", e);
        }
    }

    @Override
    public void rename(AbstractPath renamed) {
        block3: {
            log.debug((Object)("rename:" + renamed));
            try {
                this.session.check();
                this.session.message(MessageFormat.format(Locale.localizedString("Renaming {0} to {1}", "Status"), this.getName(), renamed));
                this.session.setWorkdir(this.getParent());
                this.session.FTP.rename(this.getName(), renamed.getAbsolute());
                this.setPath(renamed.getAbsolute());
            }
            catch (IOException e) {
                if (this.attributes.isFile()) {
                    this.error("Cannot rename file", e);
                }
                if (!this.attributes.isDirectory()) break block3;
                this.error("Cannot rename folder", e);
            }
        }
    }

    @Override
    public void readSize() {
        try {
            AttributedList l;
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Getting size of {0}", "Status"), this.getName()));
            if (this.attributes.isFile()) {
                if (Preferences.instance().getProperty("ftp.transfermode").equals(FTPTransferType.AUTO.toString())) {
                    if (this.getTextFiletypePattern().matcher(this.getName()).matches()) {
                        this.session.FTP.setTransferType(FTPTransferType.ASCII);
                    } else {
                        this.session.FTP.setTransferType(FTPTransferType.BINARY);
                    }
                } else if (Preferences.instance().getProperty("ftp.transfermode").equals(FTPTransferType.BINARY.toString())) {
                    this.session.FTP.setTransferType(FTPTransferType.BINARY);
                } else if (Preferences.instance().getProperty("ftp.transfermode").equals(FTPTransferType.ASCII.toString())) {
                    this.session.FTP.setTransferType(FTPTransferType.ASCII);
                } else {
                    throw new FTPException("Transfer type not set");
                }
                this.attributes.setSize(this.session.FTP.size(this.getAbsolute()));
            }
            if (-1L == this.attributes.getSize() && (l = this.getParent().childs()).contains(this)) {
                this.attributes.setSize(((AbstractPath)l.get((int)l.indexOf((Object)this))).attributes.getSize());
            }
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    @Override
    public void readTimestamp() {
        try {
            AttributedList l;
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Getting timestamp of {0}", "Status"), this.getName()));
            if (this.attributes.isFile()) {
                this.attributes.setModificationDate(this.session.FTP.mdtm(this.getAbsolute()));
            }
            if (-1L == this.attributes.getModificationDate() && (l = this.getParent().childs()).contains(this)) {
                this.attributes.setModificationDate(((AbstractPath)l.get((int)l.indexOf((Object)this))).attributes.getModificationDate());
            }
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    @Override
    public void readPermission() {
        try {
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Getting permission of {0}", "Status"), this.getName()));
            AttributedList l = this.getParent().childs();
            if (l.contains(this)) {
                this.attributes.setPermission(((AbstractPath)l.get((int)l.indexOf((Object)this))).attributes.getPermission());
            }
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    @Override
    public void delete() {
        block8: {
            log.debug((Object)("delete:" + this.toString()));
            try {
                this.session.check();
                if (this.attributes.isFile() || this.attributes.isSymbolicLink()) {
                    this.session.setWorkdir(this.getParent());
                    this.session.message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                    this.session.FTP.delete(this.getName());
                } else if (this.attributes.isDirectory()) {
                    this.session.setWorkdir(this);
                    for (AbstractPath file : this.childs()) {
                        if (!this.session.isConnected()) break;
                        if (file.attributes.isFile() || file.attributes.isSymbolicLink()) {
                            this.session.message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), file.getName()));
                            this.session.FTP.delete(file.getName());
                            continue;
                        }
                        if (!file.attributes.isDirectory()) continue;
                        file.delete();
                    }
                    this.session.setWorkdir(this.getParent());
                    this.session.message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                    this.session.FTP.rmdir(this.getName());
                }
            }
            catch (IOException e) {
                if (this.attributes.isFile()) {
                    this.error("Cannot delete file", e);
                }
                if (!this.attributes.isDirectory()) break block8;
                this.error("Cannot delete folder", e);
            }
        }
    }

    @Override
    public void writeOwner(String owner, boolean recursive) {
        block5: {
            String command = "chown";
            try {
                this.session.check();
                this.session.message(MessageFormat.format(Locale.localizedString("Changing owner of {0} to {1}", "Status"), this.getName(), owner));
                this.session.setWorkdir(this.getParent());
                if (this.attributes.isFile() && !this.attributes.isSymbolicLink()) {
                    this.session.FTP.site(command + " " + owner + " " + this.getName());
                    break block5;
                }
                if (!this.attributes.isDirectory()) break block5;
                this.session.FTP.site(command + " " + owner + " " + this.getName());
                if (!recursive) break block5;
                for (AbstractPath child : this.childs()) {
                    if (this.session.isConnected()) {
                        ((Path)child).writeOwner(owner, recursive);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.error("Cannot change owner", e);
            }
        }
    }

    @Override
    public void writeGroup(String group, boolean recursive) {
        block5: {
            String command = "chgrp";
            try {
                this.session.check();
                this.session.message(MessageFormat.format(Locale.localizedString("Changing group of {0} to {1}", "Status"), this.getName(), group));
                this.session.setWorkdir(this.getParent());
                if (this.attributes.isFile() && !this.attributes.isSymbolicLink()) {
                    this.session.FTP.site(command + " " + group + " " + this.getName());
                    break block5;
                }
                if (!this.attributes.isDirectory()) break block5;
                this.session.FTP.site(command + " " + group + " " + this.getName());
                if (!recursive) break block5;
                for (AbstractPath child : this.childs()) {
                    if (this.session.isConnected()) {
                        ((Path)child).writeGroup(group, recursive);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.error("Cannot change group", e);
            }
        }
    }

    @Override
    public void writePermissions(Permission perm, boolean recursive) {
        log.debug((Object)("changePermissions:" + perm));
        String command = "CHMOD";
        try {
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Changing permission of {0} to {1}", "Status"), this.getName(), perm.getOctalString()));
            this.session.setWorkdir(this.getParent());
            if (this.attributes.isFile() && !this.attributes.isSymbolicLink()) {
                if (recursive) {
                    Permission modified = new Permission(perm);
                    if (!this.attributes.getPermission().getOwnerPermissions()[2]) {
                        modified.getOwnerPermissions()[2] = false;
                    }
                    if (!this.attributes.getPermission().getGroupPermissions()[2]) {
                        modified.getGroupPermissions()[2] = false;
                    }
                    if (!this.attributes.getPermission().getOtherPermissions()[2]) {
                        modified.getOtherPermissions()[2] = false;
                    }
                    this.session.FTP.site("CHMOD " + modified.getOctalString() + " " + this.getName());
                } else {
                    this.session.FTP.site("CHMOD " + perm.getOctalString() + " " + this.getName());
                }
            } else if (this.attributes.isDirectory()) {
                this.session.FTP.site("CHMOD " + perm.getOctalString() + " " + this.getName());
                if (recursive) {
                    for (AbstractPath child : this.childs()) {
                        if (!this.session.isConnected()) break;
                        child.writePermissions(perm, recursive);
                    }
                    this.invalidate();
                }
            }
        }
        catch (IOException e) {
            this.error("Cannot change permissions", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void download(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        log.debug((Object)("download:" + this.toString()));
        try {
            if (check) {
                this.session.check();
            }
            if (this.attributes.isFile()) {
                this.session.setWorkdir(this.getParent());
                if (Preferences.instance().getProperty("ftp.transfermode").equals(FTPTransferType.AUTO.toString())) {
                    if (this.getTextFiletypePattern().matcher(this.getName()).matches()) {
                        this.downloadASCII(throttle, listener);
                        return;
                    } else {
                        this.downloadBinary(throttle, listener);
                    }
                    return;
                } else if (Preferences.instance().getProperty("ftp.transfermode").equals(FTPTransferType.BINARY.toString())) {
                    this.downloadBinary(throttle, listener);
                    return;
                } else {
                    if (!Preferences.instance().getProperty("ftp.transfermode").equals(FTPTransferType.ASCII.toString())) throw new FTPException("Transfer mode not set");
                    this.downloadASCII(throttle, listener);
                }
                return;
            } else {
                if (!this.attributes.isDirectory()) return;
                this.getLocal().mkdir(true);
            }
            return;
        }
        catch (IOException e) {
            this.error("Download failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadBinary(BandwidthThrottle throttle, StreamListener listener) throws IOException {
        InputStream in = null;
        Local.OutputStream out = null;
        try {
            this.session.FTP.setTransferType(FTPTransferType.BINARY);
            if (this.getStatus().isResume() && !this.session.FTP.isFeatureSupported("REST STREAM")) {
                this.getStatus().setResume(false);
            }
            in = this.session.FTP.get(this.getName(), this.getStatus().isResume() ? this.getLocal().attributes.getSize() : 0L);
            out = new Local.OutputStream(this.getLocal(), this.getStatus().isResume());
            this.download(in, out, throttle, listener);
            if (this.getStatus().isComplete()) {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
                this.session.FTP.validateTransfer();
            }
            if (this.getStatus().isCanceled()) {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
                this.session.FTP.abor();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadASCII(BandwidthThrottle throttle, StreamListener listener) throws IOException {
        FromNetASCIIInputStream in = null;
        FromNetASCIIOutputStream out = null;
        try {
            String lineSeparator = System.getProperty("line.separator");
            if (Preferences.instance().getProperty("ftp.line.separator").equals("unix")) {
                lineSeparator = UNIX_LINE_SEPARATOR;
            } else if (Preferences.instance().getProperty("ftp.line.separator").equals("mac")) {
                lineSeparator = MAC_LINE_SEPARATOR;
            } else if (Preferences.instance().getProperty("ftp.line.separator").equals("win")) {
                lineSeparator = DOS_LINE_SEPARATOR;
            }
            this.session.FTP.setTransferType(FTPTransferType.ASCII);
            in = new FromNetASCIIInputStream(this.session.FTP.get(this.getName(), 0L), lineSeparator);
            out = new FromNetASCIIOutputStream(new Local.OutputStream(this.getLocal(), false), lineSeparator);
            this.download(in, out, throttle, listener);
            if (this.getStatus().isComplete()) {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
                this.session.FTP.validateTransfer();
            }
            if (this.getStatus().isCanceled()) {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
                this.session.FTP.abor();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    @Override
    public void upload(BandwidthThrottle throttle, StreamListener listener, Permission p, boolean check) {
        log.debug((Object)("upload:" + this.toString()));
        try {
            if (check) {
                this.session.check();
            }
            if (this.attributes.isFile()) {
                this.session.setWorkdir(this.getParent());
                if (Preferences.instance().getProperty("ftp.transfermode").equals(FTPTransferType.AUTO.toString())) {
                    if (this.getTextFiletypePattern().matcher(this.getName()).matches()) {
                        this.uploadASCII(throttle, listener);
                    } else {
                        this.uploadBinary(throttle, listener);
                    }
                } else if (Preferences.instance().getProperty("ftp.transfermode").equals(FTPTransferType.BINARY.toString())) {
                    this.uploadBinary(throttle, listener);
                } else if (Preferences.instance().getProperty("ftp.transfermode").equals(FTPTransferType.ASCII.toString())) {
                    this.uploadASCII(throttle, listener);
                } else {
                    throw new FTPException("Transfer mode not set");
                }
            }
            if (this.attributes.isDirectory()) {
                this.mkdir();
            }
            if (null != p) {
                try {
                    log.info((Object)("Updating permissions:" + p.getOctalString()));
                    this.session.FTP.chmod(p.getOctalString(), this.getName());
                }
                catch (FTPException ignore) {
                    log.warn((Object)ignore.getMessage());
                }
            }
            if (Preferences.instance().getBoolean("queue.upload.preserveDate")) {
                log.info((Object)"Updating timestamp");
                this.session.FTP.mfmt(this.getLocal().attributes.getModificationDate(), this.getLocal().attributes.getCreationDate(), this.getName());
            }
        }
        catch (IOException e) {
            this.error("Upload failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadBinary(BandwidthThrottle throttle, StreamListener listener) throws IOException {
        Local.InputStream in = null;
        OutputStream out = null;
        try {
            this.session.FTP.setTransferType(FTPTransferType.BINARY);
            in = new Local.InputStream(this.getLocal());
            out = this.session.FTP.put(this.getName(), this.getStatus().isResume());
            if (null == out) {
                throw new IOException("Unable opening data stream");
            }
            this.upload(out, (InputStream)((Object)in), throttle, listener);
            if (this.getStatus().isComplete()) {
                IOUtils.closeQuietly((InputStream)((Object)in));
                IOUtils.closeQuietly((OutputStream)out);
                this.session.FTP.validateTransfer();
            }
            if (this.getStatus().isCanceled()) {
                IOUtils.closeQuietly((InputStream)((Object)in));
                IOUtils.closeQuietly((OutputStream)out);
                this.session.FTP.abor();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)((Object)in));
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadASCII(BandwidthThrottle throttle, StreamListener listener) throws IOException {
        ToNetASCIIInputStream in = null;
        ToNetASCIIOutputStream out = null;
        try {
            this.session.FTP.setTransferType(FTPTransferType.ASCII);
            in = new ToNetASCIIInputStream((InputStream)((Object)new Local.InputStream(this.getLocal())));
            out = new ToNetASCIIOutputStream(this.session.FTP.put(this.getName(), this.getStatus().isResume()));
            this.upload(out, in, throttle, listener);
            if (this.getStatus().isComplete()) {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
                this.session.FTP.validateTransfer();
            }
            if (this.getStatus().isCanceled()) {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
                this.session.FTP.abor();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    static {
        PathFactory.addFactory(Protocol.FTP, new Factory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<FTPSession> {
        private Factory() {
        }

        @Override
        protected Path create(FTPSession session, String path, int type) {
            return new FTPPath(session, path, type);
        }

        @Override
        protected Path create(FTPSession session, String parent, String name, int type) {
            return new FTPPath(session, parent, name, type);
        }

        @Override
        protected Path create(FTPSession session, String path, Local file) {
            return new FTPPath(session, path, file);
        }

        @Override
        protected <T> Path create(FTPSession session, T dict) {
            return new FTPPath(session, dict);
        }
    }
}

