/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Proxy;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.ftp.FTPParserFactory;
import ch.cyberduck.core.ftp.parser.CompositeFileEntryParser;
import ch.cyberduck.core.ftp.parser.LaxUnixFTPEntryParser;
import ch.cyberduck.core.ftp.parser.RumpusFTPEntryParser;
import ch.cyberduck.core.i18n.Locale;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPNullReplyException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.net.ftp.Configurable;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.parser.NetwareFTPEntryParser;
import org.apache.commons.net.ftp.parser.ParserInitializationException;
import org.apache.commons.net.ftp.parser.UnixFTPEntryParser;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPSession
extends Session {
    private static Logger log = Logger.getLogger(FTPSession.class);
    protected FTPClient FTP;
    protected FTPFileEntryParser parser;
    private TimeZone tz;
    private Map<FTPFileEntryParser, Boolean> parsers = new HashMap<FTPFileEntryParser, Boolean>(1);
    protected final FTPMessageListener messageListener = new FTPMessageListener(){

        public void logCommand(String cmd) {
            FTPSession.this.log(true, cmd);
        }

        public void logReply(String reply) {
            FTPSession.this.log(false, reply);
        }
    };

    protected FTPSession(Host h) {
        super(h);
    }

    @Override
    protected Path mount(String directory) throws IOException {
        Path workdir = super.mount(directory);
        if (Preferences.instance().getBoolean("ftp.timezone.auto") && null == this.host.getTimezone()) {
            List<TimeZone> matches = this.calculateTimezone();
            Iterator<TimeZone> i$ = matches.iterator();
            if (i$.hasNext()) {
                TimeZone tz = i$.next();
                this.host.setTimezone(tz);
            }
            if (!matches.isEmpty()) {
                this.parser = null;
            }
        }
        return workdir;
    }

    protected TimeZone getTimezone() throws IOException {
        if (null == this.host.getTimezone()) {
            return TimeZone.getTimeZone(Preferences.instance().getProperty("ftp.timezone.default"));
        }
        return this.host.getTimezone();
    }

    protected FTPFileEntryParser getFileParser() throws IOException {
        try {
            if (!this.getTimezone().equals(this.tz)) {
                this.tz = this.getTimezone();
                log.info((Object)("Reset parser to timezone:" + this.tz));
                this.parser = null;
            }
            if (null == this.parser) {
                String system = null;
                try {
                    system = this.FTP.system();
                }
                catch (FTPException e) {
                    log.warn((Object)(this.host.getHostname() + " does not support the SYST command:" + e.getMessage()));
                }
                this.parser = new FTPParserFactory().createFileEntryParser(system, this.tz);
                if (this.parser instanceof Configurable) {
                    ((Configurable)this.parser).configure(null);
                }
            }
            return this.parser;
        }
        catch (ParserInitializationException e) {
            throw new IOException(e.getMessage());
        }
    }

    private List<TimeZone> calculateTimezone() throws IOException {
        try {
            AttributedList list = this.workdir().childs();
            if (list.isEmpty()) {
                log.warn((Object)"Cannot determine timezone with empty directory listing");
                return Collections.emptyList();
            }
            for (Path test : list) {
                String[] timezones;
                if (!test.attributes.isFile()) continue;
                long utc = this.FTP.mdtm(test.getAbsolute());
                utc -= utc % 60000L;
                long local = test.attributes.getModificationDate();
                if (-1L == local) {
                    log.warn((Object)"No modification date in directory listing to calculate timezone");
                    continue;
                }
                local -= local % 60000L;
                long offset = local - utc;
                log.info((Object)("Calculated UTC offset is " + offset + "ms"));
                ArrayList<TimeZone> zones = new ArrayList<TimeZone>();
                if ((long)TimeZone.getTimeZone(Preferences.instance().getProperty("ftp.timezone.default")).getOffset(utc) == offset) {
                    log.info((Object)"Offset equals local timezone offset.");
                    zones.add(TimeZone.getTimeZone(Preferences.instance().getProperty("ftp.timezone.default")));
                    return zones;
                }
                for (String timezone : timezones = TimeZone.getAvailableIDs((int)offset)) {
                    log.info((Object)("Matching timezone identifier:" + timezone));
                    TimeZone match = TimeZone.getTimeZone(timezone);
                    log.info((Object)("Determined timezone:" + match));
                    zones.add(match);
                }
                if (zones.isEmpty()) {
                    log.warn((Object)("Failed to calculate timezone for offset:" + offset));
                    continue;
                }
                return zones;
            }
        }
        catch (FTPException e) {
            log.warn((Object)("Failed to calculate timezone:" + e.getMessage()));
        }
        log.warn((Object)"No file in directory listing to calculate timezone");
        return Collections.emptyList();
    }

    public void setStatListSupportedEnabled(boolean statListSupportedEnabled) {
        this.FTP.setStatListSupportedEnabled(statListSupportedEnabled);
    }

    public void setExtendedListEnabled(boolean extendedListEnabled) {
        this.FTP.setExtendedListEnabled(extendedListEnabled);
    }

    protected boolean isPermissionSupported(FTPFileEntryParser p) {
        FTPFileEntryParser delegate;
        if (p instanceof CompositeFileEntryParser) {
            delegate = ((CompositeFileEntryParser)p).getCachedFtpFileEntryParser();
            if (null == delegate) {
                log.warn((Object)"Composite FTP parser has no cached delegate yet");
                return false;
            }
        } else {
            delegate = p;
        }
        if (null == this.parsers.get(delegate)) {
            this.parsers.put(delegate, delegate instanceof UnixFTPEntryParser || delegate instanceof LaxUnixFTPEntryParser || delegate instanceof NetwareFTPEntryParser || delegate instanceof RumpusFTPEntryParser);
        }
        return this.parsers.get(delegate);
    }

    @Override
    public String getIdentification() {
        StringBuffer info = new StringBuffer(super.getIdentification() + "\n");
        try {
            info.append(this.FTP.system()).append("\n");
        }
        catch (IOException e) {
            log.warn((Object)(this.host.getHostname() + " does not support the SYST command:" + e.getMessage()));
        }
        return info.toString();
    }

    @Override
    public boolean isConnected() {
        if (this.FTP != null) {
            return this.FTP.isConnected();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.isConnected()) {
                this.fireConnectionWillCloseEvent();
                this.FTP.quit();
            }
        }
        catch (FTPException e) {
            log.error((Object)("FTP Error: " + e.getMessage()));
        }
        catch (IOException e) {
            log.error((Object)("IO Error: " + e.getMessage()));
        }
        finally {
            this.fireConnectionDidCloseEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        try {
            super.interrupt();
            if (null == this.FTP) {
                return;
            }
            this.fireConnectionWillCloseEvent();
            this.FTP.interrupt();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        finally {
            this.FTP = null;
            this.fireConnectionDidCloseEvent();
        }
    }

    @Override
    public void check() throws IOException {
        try {
            super.check();
        }
        catch (FTPException e) {
            log.debug((Object)e.getMessage());
            this.interrupt();
            this.connect();
        }
        catch (FTPNullReplyException e) {
            log.debug((Object)e.getMessage());
            this.interrupt();
            this.connect();
        }
    }

    protected FTPClient getClient() {
        return new FTPClient(this.getEncoding(), this.messageListener);
    }

    protected void configure(FTPClient client) throws IOException {
        client.setTimeout(this.timeout());
        client.setStatListSupportedEnabled(Preferences.instance().getBoolean("ftp.sendStatListCommand"));
        client.setExtendedListEnabled(Preferences.instance().getBoolean("ftp.sendExtendedListCommand"));
        client.setMlsdListSupportedEnabled(Preferences.instance().getBoolean("ftp.sendMlsdListCommand"));
        client.setStrictReturnCodes(true);
        client.setConnectMode(this.getConnectMode());
    }

    @Override
    protected void connect() throws IOException, FTPException, ConnectionCanceledException, LoginCanceledException {
        if (this.isConnected()) {
            return;
        }
        this.fireConnectionWillOpenEvent();
        this.message(MessageFormat.format(Locale.localizedString("Opening {0} connection to {1}", "Status"), this.host.getProtocol().getName(), this.host.getHostname()));
        this.FTP = this.getClient();
        this.configure(this.FTP);
        this.FTP.connect(this.host.getHostname(true), this.host.getPort());
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        this.message(MessageFormat.format(Locale.localizedString("{0} connection opened", "Status"), this.host.getProtocol().getName()));
        this.login();
        this.fireConnectionDidOpenEvent();
        if ("UTF-8".equals(this.getEncoding())) {
            this.FTP.utf8();
        }
    }

    protected FTPConnectMode getConnectMode() {
        if (null == this.host.getFTPConnectMode()) {
            if (Proxy.usePassiveFTP()) {
                return FTPConnectMode.PASV;
            }
            return FTPConnectMode.ACTIVE;
        }
        return this.host.getFTPConnectMode();
    }

    @Override
    protected void login(Credentials credentials) throws IOException {
        try {
            this.FTP.login(credentials.getUsername(), credentials.getPassword());
            this.message(Locale.localizedString("Login successful", "Credentials"));
        }
        catch (FTPException e) {
            this.message(Locale.localizedString("Login failed", "Credentials"));
            this.login.fail(this.host, e.getMessage());
            this.login();
        }
    }

    @Override
    public Path workdir() throws IOException {
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        if (null == this.workdir) {
            this.workdir = PathFactory.createPath((Session)this, this.FTP.pwd(), 2);
            if (this.workdir.isRoot()) {
                this.workdir.attributes.setType(10);
            }
        }
        return this.workdir;
    }

    protected void setWorkdir(Path workdir) throws IOException {
        if (workdir.equals(this.workdir)) {
            return;
        }
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        this.FTP.chdir(workdir.getAbsolute());
        this.workdir = workdir;
    }

    @Override
    protected void noop() throws IOException {
        if (this.isConnected()) {
            this.FTP.noop();
        }
    }

    @Override
    public boolean isSendCommandSupported() {
        return true;
    }

    @Override
    public void sendCommand(String command) throws IOException {
        if (this.isConnected()) {
            this.message(command);
            this.FTP.quote(command);
        }
    }

    static {
        SessionFactory.addFactory(Protocol.FTP, new Factory());
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new FTPSession(h);
        }
    }
}

