/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp.parser;

import org.apache.commons.net.ftp.Configurable;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.FTPFileEntryParserImpl;
import org.apache.log4j.Logger;

public class CompositeFileEntryParser
extends FTPFileEntryParserImpl
implements Configurable {
    private static Logger log = Logger.getLogger(CompositeFileEntryParser.class);
    private final FTPFileEntryParser[] ftpFileEntryParsers;
    private FTPFileEntryParser cachedFtpFileEntryParser = null;

    public CompositeFileEntryParser(FTPFileEntryParser[] ftpFileEntryParsers) {
        this.ftpFileEntryParsers = ftpFileEntryParsers;
    }

    public FTPFile parseFTPEntry(String listEntry) {
        if (this.cachedFtpFileEntryParser != null) {
            FTPFile parsed = this.cachedFtpFileEntryParser.parseFTPEntry(listEntry);
            if (null != parsed) {
                return parsed;
            }
            log.info((Object)("Switching parser implementation because " + this.cachedFtpFileEntryParser + " failed"));
            this.cachedFtpFileEntryParser = null;
        }
        for (int iterParser = 0; iterParser < this.ftpFileEntryParsers.length; ++iterParser) {
            FTPFileEntryParser ftpFileEntryParser = this.ftpFileEntryParsers[iterParser];
            FTPFile matched = ftpFileEntryParser.parseFTPEntry(listEntry);
            if (matched == null) continue;
            this.cachedFtpFileEntryParser = ftpFileEntryParser;
            log.info((Object)("Caching " + this.cachedFtpFileEntryParser + " parser implementation"));
            return matched;
        }
        return null;
    }

    public FTPFileEntryParser getCachedFtpFileEntryParser() {
        return this.cachedFtpFileEntryParser;
    }

    public void configure(FTPClientConfig config) {
        for (FTPFileEntryParser parser : this.ftpFileEntryParsers) {
            if (!(parser instanceof Configurable)) continue;
            ((Configurable)parser).configure(config);
        }
    }
}

