/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftps;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.ftps.FTPSClient;
import ch.cyberduck.core.ssl.AbstractX509TrustManager;
import ch.cyberduck.core.ssl.IgnoreX509TrustManager;
import ch.cyberduck.core.ssl.KeychainX509TrustManager;
import ch.cyberduck.core.ssl.SSLSession;
import com.enterprisedt.net.ftp.FTPClient;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FTPSSession
extends FTPSession
implements SSLSession {
    private static Logger log = Logger.getLogger(FTPSSession.class);
    private AbstractX509TrustManager trustManager;
    private boolean auth;

    protected FTPSSession(Host h) {
        super(h);
    }

    public AbstractX509TrustManager getTrustManager() {
        if (null == this.trustManager) {
            if (Preferences.instance().getBoolean("ftp.tls.acceptAnyCertificate")) {
                this.setTrustManager(new IgnoreX509TrustManager());
            } else {
                this.setTrustManager(new KeychainX509TrustManager(this.host.getHostname()));
            }
        }
        return this.trustManager;
    }

    public void setTrustManager(AbstractX509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    protected FTPClient getClient() {
        this.auth = true;
        return new FTPSClient(this.getEncoding(), this.messageListener, this.getTrustManager());
    }

    public void login(Credentials credentials) throws IOException {
        if (this.auth) {
            ((FTPSClient)this.FTP).auth();
            this.auth = false;
        }
        super.login(credentials);
        ((FTPSClient)this.FTP).prot();
    }

    static {
        SessionFactory.addFactory(Protocol.FTP_TLS, new Factory());
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new FTPSSession(h);
        }
    }
}

