/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public final class FromNetASCIIInputStream
extends PushbackInputStream {
    private boolean _noConversionRequired;
    private String _lineSeparator;
    private byte[] _lineSeparatorBytes;
    private int __length = 0;

    public final boolean isConversionRequired() {
        return !this._noConversionRequired;
    }

    public FromNetASCIIInputStream(InputStream input, String lineSeparator) {
        super(input, lineSeparator.getBytes().length + 1);
        this._lineSeparator = lineSeparator;
        this._lineSeparatorBytes = lineSeparator.getBytes();
        this._noConversionRequired = lineSeparator.equals("\r\n");
    }

    private int __read() throws IOException {
        int ch = super.read();
        if (ch == 13) {
            ch = super.read();
            if (ch == 10) {
                this.unread(this._lineSeparatorBytes);
                ch = super.read();
                --this.__length;
            } else {
                if (ch != -1) {
                    this.unread(ch);
                }
                return 13;
            }
        }
        return ch;
    }

    public int read() throws IOException {
        if (this._noConversionRequired) {
            return super.read();
        }
        return this.__read();
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length < 1) {
            return 0;
        }
        int ch = this.available();
        int n = this.__length = length > ch ? ch : length;
        if (this.__length < 1) {
            this.__length = 1;
        }
        if (this._noConversionRequired) {
            return super.read(buffer, offset, this.__length);
        }
        ch = this.__read();
        if (ch == -1) {
            return -1;
        }
        int off = offset;
        do {
            buffer[offset++] = (byte)ch;
        } while (--this.__length > 0 && (ch = this.__read()) != -1);
        return offset - off;
    }

    public int available() throws IOException {
        return this.buf.length - this.pos + this.in.available();
    }
}

