/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class FromNetASCIIOutputStream
extends FilterOutputStream {
    private boolean __lastWasCR;
    private boolean _noConversionRequired;
    private String _lineSeparator;
    private byte[] _lineSeparatorBytes;

    public FromNetASCIIOutputStream(OutputStream output, String lineSeparator) {
        super(output);
        this._lineSeparator = lineSeparator;
        this._lineSeparatorBytes = lineSeparator.getBytes();
        this._noConversionRequired = lineSeparator.equals("\r\n");
        this.__lastWasCR = false;
    }

    private void __write(int ch) throws IOException {
        switch (ch) {
            case 13: {
                this.__lastWasCR = true;
                break;
            }
            case 10: {
                if (this.__lastWasCR) {
                    this.out.write(this._lineSeparatorBytes);
                    this.__lastWasCR = false;
                    break;
                }
                this.__lastWasCR = false;
                this.out.write(10);
                break;
            }
            default: {
                if (this.__lastWasCR) {
                    this.out.write(13);
                    this.__lastWasCR = false;
                }
                this.out.write(ch);
            }
        }
    }

    public synchronized void write(int ch) throws IOException {
        if (this._noConversionRequired) {
            this.out.write(ch);
            return;
        }
        this.__write(ch);
    }

    public synchronized void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public synchronized void write(byte[] buffer, int offset, int length) throws IOException {
        if (this._noConversionRequired) {
            this.out.write(buffer, offset, length);
            return;
        }
        while (length-- > 0) {
            this.__write(buffer[offset++]);
        }
    }

    public synchronized void close() throws IOException {
        if (this._noConversionRequired) {
            super.close();
            return;
        }
        if (this.__lastWasCR) {
            this.out.write(13);
        }
        super.close();
    }
}

