/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.cloud.CloudPath;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.s3.S3Session;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.S3ObjectsChunk;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.CanonicalGrantee;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3BucketLoggingStatus;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.S3Owner;
import org.jets3t.service.model.cloudfront.Distribution;
import org.jets3t.service.model.cloudfront.DistributionConfig;
import org.jets3t.service.model.cloudfront.LoggingStatus;
import org.jets3t.service.multithread.CancelEventTrigger;
import org.jets3t.service.multithread.CreateObjectsEvent;
import org.jets3t.service.multithread.DownloadPackage;
import org.jets3t.service.multithread.S3ServiceEventAdaptor;
import org.jets3t.service.multithread.S3ServiceEventListener;
import org.jets3t.service.multithread.S3ServiceMulti;
import org.jets3t.service.multithread.ThreadWatcher;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3Path
extends CloudPath {
    private static Logger log = Logger.getLogger(S3Path.class);
    private final S3Session session;
    private Status status;
    protected S3Object _details;
    private S3Bucket _bucket;
    private SimpleDateFormat rfc1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    private static final String METADATA_HEADER_EXPIRES = "Expires";
    public static final String METADATA_HEADER_CACHE_CONTROL = "Cache-Control";
    private static final Permission DEFAULT_FOLDER_PERMISSION;
    private CancelEventTrigger cancelTrigger;
    private static final int BUCKET_LIST_CHUNKING_SIZE = 1000;
    private static final String MIMETYPE_DIRECTORY = "application/x-directory";

    protected S3Path(S3Session s, String parent, String name, int type) {
        super(parent, name, type);
        this.rfc1123.setTimeZone(TimeZone.getDefault());
        this.session = s;
    }

    protected S3Path(S3Session s, String path, int type) {
        super(path, type);
        this.rfc1123.setTimeZone(TimeZone.getDefault());
        this.session = s;
    }

    protected S3Path(S3Session s, String parent, Local file) {
        super(parent, file);
        this.rfc1123.setTimeZone(TimeZone.getDefault());
        this.session = s;
    }

    protected <T> S3Path(S3Session s, T dict) {
        super(dict);
        this.rfc1123.setTimeZone(TimeZone.getDefault());
        this.session = s;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Status getStatus() {
        if (null == this.status) {
            this.status = new Status(){

                public void setCanceled() {
                    super.setCanceled();
                    if (null == S3Path.this.cancelTrigger) {
                        return;
                    }
                    log.debug((Object)("Cancel trigger:" + S3Path.this.cancelTrigger.toString()));
                    S3Path.this.cancelTrigger.cancelTask((Object)this);
                }
            };
        }
        return this.status;
    }

    @Override
    public boolean exists() {
        if (this.attributes.isDirectory()) {
            if (this.isContainer()) {
                try {
                    return this.session.S3.isBucketAccessible(this.getContainerName());
                }
                catch (S3ServiceException e) {
                    return false;
                }
            }
            return !this.childs().isEmpty();
        }
        return super.exists();
    }

    protected S3Object getDetails() throws IOException, S3ServiceException {
        if (null == this._details || !this._details.isMetadataComplete()) {
            this._details = this.session.S3.getObjectDetails(this.getBucket(), this.getKey());
        }
        Credentials credentials = this.session.getHost().getCredentials();
        if (null == this._details.getAcl() && !credentials.isAnonymousLogin()) {
            AccessControlList acl = this.session.S3.getObjectAcl(this.getBucket(), this.getKey());
            this._details.setAcl(acl);
        }
        return this._details;
    }

    protected S3Bucket getBucket() throws IOException {
        if (null == this._bucket) {
            String bucketname = this.getContainerName();
            if (this.isRoot()) {
                return null;
            }
            try {
                for (S3Bucket bucket : this.session.getBuckets(false)) {
                    if (!bucket.getName().equals(bucketname)) continue;
                    this._bucket = bucket;
                    break;
                }
            }
            catch (S3ServiceException e) {
                this.error("Cannot read file attributes", e);
            }
            log.warn((Object)("Bucket not found with name:" + bucketname));
        }
        this.session.getTrustManager().setHostname(this.session.getHostnameForBucket(this._bucket.getName()));
        Credentials credentials = this.session.getHost().getCredentials();
        if (null == this._bucket.getAcl() && !credentials.isAnonymousLogin()) {
            try {
                AccessControlList acl = this.session.S3.getBucketAcl(this._bucket);
                this._bucket.setAcl(acl);
            }
            catch (S3ServiceException e) {
                this.error("Cannot read file attributes", e);
            }
        }
        return this._bucket;
    }

    public String getLocation() {
        try {
            S3Bucket bucket = this.getBucket();
            if (bucket.isLocationKnown()) {
                return bucket.getLocation();
            }
            this.session.check();
            return this.session.S3.getBucketLocation(bucket.getName());
        }
        catch (S3ServiceException e) {
            this.error("Cannot read file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
        return null;
    }

    public void setExpiration(Date expiration) {
        try {
            this.session.check();
            S3Object target = this.getDetails();
            target.addMetadata(METADATA_HEADER_EXPIRES, (Object)this.rfc1123.format(expiration));
            this.session.S3.updateObjectMetadata(this.getContainerName(), target);
        }
        catch (S3ServiceException e) {
            this.error("Cannot write file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot write file attributes", e);
        }
    }

    public void setCacheControl(String maxage) {
        try {
            this.session.check();
            S3Object target = this.getDetails();
            if (StringUtils.isEmpty((String)maxage)) {
                target.removeMetadata(METADATA_HEADER_CACHE_CONTROL);
            } else {
                target.addMetadata(METADATA_HEADER_CACHE_CONTROL, (Object)maxage);
            }
            this.session.S3.updateObjectMetadata(this.getContainerName(), target);
        }
        catch (S3ServiceException e) {
            this.error("Cannot write file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot write file attributes", e);
        }
    }

    public void setLogging(boolean enabled) {
        S3BucketLoggingStatus loggingStatus = new S3BucketLoggingStatus();
        if (enabled) {
            loggingStatus.setTargetBucketName(this.getContainerName());
            loggingStatus.setLogfilePrefix(Preferences.instance().getProperty("s3.logging.prefix"));
        }
        try {
            this.session.check();
            this.session.S3.setBucketLoggingStatus(this.getContainerName(), loggingStatus, true);
        }
        catch (S3ServiceException e) {
            this.error("Cannot write file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot write file attributes", e);
        }
    }

    public Map getMetadata() {
        if (this.attributes.isFile()) {
            try {
                this.session.check();
                S3Object target = this.getDetails();
                return target.getModifiableMetadata();
            }
            catch (S3ServiceException e) {
                this.error("Cannot read file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
        return Collections.EMPTY_MAP;
    }

    public boolean isLogging() {
        try {
            this.session.check();
            S3BucketLoggingStatus status = this.session.S3.getBucketLoggingStatus(this.getContainerName());
            return status.isLoggingEnabled();
        }
        catch (S3ServiceException e) {
            this.error("Cannot read file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
        return false;
    }

    public void setRequesterPays(boolean enabled) {
        try {
            this.session.check();
            this.session.S3.setRequesterPaysBucket(this.getContainerName(), enabled);
        }
        catch (S3ServiceException e) {
            this.error("Cannot write file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot write file attributes", e);
        }
    }

    public boolean isRequesterPays() {
        try {
            this.session.check();
            return this.session.S3.isRequesterPaysBucket(this.getContainerName());
        }
        catch (S3ServiceException e) {
            this.error("Cannot read file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
        return false;
    }

    @Override
    public void readSize() {
        if (this.attributes.isFile()) {
            try {
                this.session.check();
                this.session.message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Getting size of {0}", "Status"), this.getName()));
                S3Object details = this.getDetails();
                this.attributes.setSize(details.getContentLength());
            }
            catch (S3ServiceException e) {
                this.error("Cannot read file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    @Override
    public void readTimestamp() {
        if (this.attributes.isFile()) {
            try {
                this.session.check();
                this.session.message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Getting timestamp of {0}", "Status"), this.getName()));
                S3Object details = this.getDetails();
                this.attributes.setModificationDate(details.getLastModifiedDate().getTime());
            }
            catch (S3ServiceException e) {
                this.error("Cannot read file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    @Override
    public void readPermission() {
        try {
            this.session.check();
            this.session.message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Getting permission of {0}", "Status"), this.getName()));
            AccessControlList acl = null;
            if (this.isContainer()) {
                acl = this.getBucket().getAcl();
            } else if (this.attributes.isFile()) {
                acl = this.getDetails().getAcl();
            }
            if (null == acl) {
                if (this.attributes.isDirectory()) {
                    this.attributes.setPermission(DEFAULT_FOLDER_PERMISSION);
                } else {
                    this.attributes.setPermission(Permission.EMPTY);
                }
            } else {
                this.attributes.setPermission(this.readPermissions(acl.getGrants()));
            }
        }
        catch (S3ServiceException e) {
            this.error("Cannot read file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    private Permission readPermissions(Set grants) throws IOException, S3ServiceException {
        boolean[][] p = new boolean[3][3];
        for (GrantAndPermission grant : grants) {
            S3Owner owner;
            org.jets3t.service.acl.Permission access = grant.getPermission();
            if (grant.getGrantee().equals(GroupGrantee.ALL_USERS)) {
                if (access.equals((Object)org.jets3t.service.acl.Permission.PERMISSION_READ) || access.equals((Object)org.jets3t.service.acl.Permission.PERMISSION_FULL_CONTROL)) {
                    p[2][0] = true;
                }
                if (access.equals((Object)org.jets3t.service.acl.Permission.PERMISSION_WRITE) || access.equals((Object)org.jets3t.service.acl.Permission.PERMISSION_FULL_CONTROL)) {
                    p[2][1] = true;
                }
            }
            if (null == (owner = this.getBucket().getOwner()) || !grant.getGrantee().equals(new CanonicalGrantee(owner.getId()))) continue;
            if (access.equals((Object)org.jets3t.service.acl.Permission.PERMISSION_READ) || access.equals((Object)org.jets3t.service.acl.Permission.PERMISSION_FULL_CONTROL)) {
                p[0][0] = true;
            }
            if (!access.equals((Object)org.jets3t.service.acl.Permission.PERMISSION_WRITE) && !access.equals((Object)org.jets3t.service.acl.Permission.PERMISSION_FULL_CONTROL)) continue;
            p[0][1] = true;
        }
        return new Permission(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void download(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        block14: {
            if (this.attributes.isFile()) {
                OutputStream out = null;
                InputStream in = null;
                try {
                    DownloadPackage download;
                    block13: {
                        if (check) {
                            this.session.check();
                        }
                        this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Downloading {0}", "Status"), this.getName()));
                        S3Bucket bucket = this.getBucket();
                        in = this.session.S3.getObject(bucket, this.getKey(), null, null, null, null, this.getStatus().isResume() ? Long.valueOf(this.getStatus().getCurrent()) : null, null).getDataInputStream();
                        try {
                            download = ObjectUtils.createPackageForDownload((S3Object)new S3Object(bucket, this.getKey()), (File)new File(this.getLocal().getAbsolute()), (boolean)true, (boolean)false, null);
                            if (null != download) break block13;
                        }
                        catch (Exception e) {
                            throw new S3ServiceException(e.getMessage(), (Throwable)e);
                        }
                        IOUtils.closeQuietly((InputStream)in);
                        IOUtils.closeQuietly(out);
                        return;
                    }
                    download.setAppendToFile(true);
                    out = download.getOutputStream();
                    this.download(in, out, throttle, listener);
                    IOUtils.closeQuietly((InputStream)in);
                }
                catch (S3ServiceException e) {
                    this.error("Download failed", e);
                    break block14;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    catch (IOException e2) {
                        this.error("Download failed", e2);
                        break block14;
                    }
                }
                finally {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        if (!this.attributes.isDirectory()) return;
        this.getLocal().mkdir(true);
    }

    @Override
    public void upload(BandwidthThrottle throttle, StreamListener listener, Permission p, boolean check) {
        try {
            if (check) {
                this.session.check();
            }
            if (this.attributes.isFile()) {
                S3Object object;
                S3ServiceMulti multi = new S3ServiceMulti(this.session.S3, (S3ServiceEventListener)new S3ServiceTransferEventAdaptor(listener));
                this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Compute MD5 hash of {0}", "Status"), this.getName()));
                try {
                    object = ObjectUtils.createObjectForUpload((String)this.getKey(), (File)new File(this.getLocal().getAbsolute()), null, (boolean)false);
                    AccessControlList acl = AccessControlList.REST_CANNED_PRIVATE;
                    if (null != p) {
                        if (p.getOtherPermissions()[0]) {
                            acl = AccessControlList.REST_CANNED_PUBLIC_READ;
                        }
                        if (p.getOtherPermissions()[1]) {
                            acl = AccessControlList.REST_CANNED_PUBLIC_READ_WRITE;
                        }
                    }
                    object.setAcl(acl);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
                this.getStatus().setCurrent(0L);
                S3Bucket bucket = this.getBucket();
                this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Uploading {0}", "Status"), this.getName()));
                multi.putObjects(bucket, new S3Object[]{object});
            }
            if (this.attributes.isDirectory()) {
                this.mkdir();
            }
        }
        catch (IOException e) {
            this.error("Upload failed", e);
        }
    }

    public AttributedList<Path> list() {
        AttributedList<Path> childs = new AttributedList<Path>();
        try {
            this.session.check();
            this.session.message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Listing directory {0}", "Status"), this.getName()));
            if (this.isRoot()) {
                for (S3Bucket bucket : this.session.getBuckets(true)) {
                    S3Path p = new S3Path(this.session, this.getAbsolute(), bucket.getName(), 10);
                    p._bucket = bucket;
                    if (null != bucket.getOwner()) {
                        p.attributes.setOwner(bucket.getOwner().getDisplayName());
                    }
                    if (null != bucket.getCreationDate()) {
                        p.attributes.setCreationDate(bucket.getCreationDate().getTime());
                    }
                    childs.add(p);
                }
            } else {
                S3ObjectsChunk chunk;
                S3Bucket bucket = this.getBucket();
                String prefix = "";
                if (!this.isContainer()) {
                    prefix = this.getKey() + "/";
                }
                String delimiter = "/";
                String priorLastKey = null;
                do {
                    String[] prefixes;
                    S3Object[] objects;
                    chunk = this.session.S3.listObjectsChunked(bucket.getName(), prefix, "/", 1000L, priorLastKey);
                    for (S3Object object : objects = chunk.getObjects()) {
                        S3Object details;
                        S3Path path = new S3Path(this.session, bucket.getName(), object.getKey(), 1);
                        path.setParent(this);
                        if (path.getAbsolute().equals(this.getAbsolute())) continue;
                        path._bucket = bucket;
                        path.attributes.setSize(object.getContentLength());
                        path.attributes.setModificationDate(object.getLastModifiedDate().getTime());
                        if (null != bucket.getOwner()) {
                            path.attributes.setOwner(bucket.getOwner().getDisplayName());
                        }
                        if (0L == object.getContentLength() && MIMETYPE_DIRECTORY.equals((details = path.getDetails()).getContentType())) {
                            path.attributes.setType(2);
                        }
                        childs.add(path);
                    }
                    for (String common : prefixes = chunk.getCommonPrefixes()) {
                        if (common.equals("/")) {
                            log.warn((Object)("Skipping prefix " + common));
                            continue;
                        }
                        S3Path p = new S3Path(this.session, bucket.getName(), common, 2);
                        p.setParent(this);
                        p._bucket = bucket;
                        if (childs.contains(p)) continue;
                        if (null != bucket.getOwner()) {
                            p.attributes.setOwner(bucket.getOwner().getDisplayName());
                        }
                        p.attributes.setPermission(DEFAULT_FOLDER_PERMISSION);
                        childs.add(p);
                    }
                } while ((priorLastKey = chunk.getPriorLastKey()) != null && !this.getStatus().isCanceled());
            }
        }
        catch (S3ServiceException e) {
            this.error(e.getS3ErrorMessage(), e);
        }
        catch (IOException e) {
            childs.attributes().setReadable(false);
            this.error("Listing directory failed", e);
        }
        return childs;
    }

    @Override
    public void mkdir() {
        log.debug((Object)("mkdir:" + this.getName()));
        try {
            this.session.check();
            this.session.message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Making directory {0}", "Status"), this.getName()));
            if (this.isContainer()) {
                if (!RestS3Service.isBucketNameValidDNSName((String)this.getName())) {
                    this.error("Bucket name is not DNS compatible");
                    return;
                }
                this.session.S3.createBucket(this.getName(), Preferences.instance().getProperty("s3.location"));
            } else {
                S3Bucket bucket = this.getBucket();
                S3Object object = new S3Object(bucket, this.getKey());
                object.setAcl(AccessControlList.REST_CANNED_PRIVATE);
                object.setContentLength(0L);
                object.setContentType(MIMETYPE_DIRECTORY);
                this.session.S3.putObject(bucket, object);
            }
        }
        catch (S3ServiceException e) {
            this.error(e.getS3ErrorMessage(), e);
        }
        catch (IOException e) {
            this.error("Cannot create folder", e);
        }
    }

    @Override
    public void mkdir(boolean recursive) {
        this.mkdir();
    }

    @Override
    public void writePermissions(Permission perm, boolean recursive) {
        block16: {
            log.debug((Object)("writePermissions:" + perm));
            try {
                this.session.check();
                this.session.message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Changing permission of {0} to {1}", "Status"), this.getName(), perm.getOctalString()));
                AccessControlList acl = null;
                S3Bucket bucket = this.getBucket();
                if (this.isContainer()) {
                    acl = this.session.S3.getBucketAcl(bucket);
                } else if (this.attributes.isFile()) {
                    acl = this.session.S3.getObjectAcl(bucket, this.getKey());
                }
                if (acl != null) {
                    CanonicalGrantee ownerGrantee = new CanonicalGrantee(acl.getOwner().getId());
                    acl.revokeAllPermissions((GranteeInterface)ownerGrantee);
                    if (perm.getOwnerPermissions()[0]) {
                        acl.grantPermission((GranteeInterface)ownerGrantee, org.jets3t.service.acl.Permission.PERMISSION_READ);
                    }
                    if (perm.getOwnerPermissions()[1]) {
                        acl.grantPermission((GranteeInterface)ownerGrantee, org.jets3t.service.acl.Permission.PERMISSION_WRITE);
                    }
                    acl.revokeAllPermissions((GranteeInterface)GroupGrantee.ALL_USERS);
                    if (perm.getOtherPermissions()[0]) {
                        acl.grantPermission((GranteeInterface)GroupGrantee.ALL_USERS, org.jets3t.service.acl.Permission.PERMISSION_READ);
                    }
                    if (perm.getOtherPermissions()[1]) {
                        acl.grantPermission((GranteeInterface)GroupGrantee.ALL_USERS, org.jets3t.service.acl.Permission.PERMISSION_WRITE);
                    }
                    if (this.isContainer()) {
                        this.session.S3.putBucketAcl(this.getContainerName(), acl);
                    } else if (this.attributes.isFile()) {
                        this.session.S3.putObjectAcl(this.getContainerName(), this.getKey(), acl);
                    }
                }
                if (!this.attributes.isDirectory() || !recursive) break block16;
                for (AbstractPath child : this.childs()) {
                    if (this.session.isConnected()) {
                        child.writePermissions(perm, recursive);
                        continue;
                    }
                    break;
                }
            }
            catch (S3ServiceException e) {
                this.error(e.getS3ErrorMessage(), e);
            }
            catch (IOException e) {
                this.error("Cannot change permissions", e);
            }
        }
    }

    @Override
    public void delete() {
        block10: {
            log.debug((Object)("delete:" + this.toString()));
            try {
                this.session.check();
                if (this.attributes.isFile()) {
                    this.session.message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                    this.session.S3.deleteObject(this.getContainerName(), this.getKey());
                } else if (this.attributes.isDirectory()) {
                    for (AbstractPath i : this.childs()) {
                        if (!this.session.isConnected()) break;
                        i.delete();
                    }
                    if (this.isContainer()) {
                        this.session.S3.deleteBucket(this.getContainerName());
                    } else {
                        this.session.S3.deleteObject(this.getContainerName(), this.getKey());
                    }
                }
            }
            catch (S3ServiceException e) {
                this.error(e.getS3ErrorMessage(), e);
            }
            catch (IOException e) {
                if (this.attributes.isFile()) {
                    this.error("Cannot delete file", e);
                }
                if (!this.attributes.isDirectory()) break block10;
                this.error("Cannot delete folder", e);
            }
        }
    }

    @Override
    public void rename(AbstractPath renamed) {
        block7: {
            try {
                if (this.attributes.isFile()) {
                    this.session.check();
                    this.session.message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Renaming {0} to {1}", "Status"), this.getName(), renamed));
                    this.session.S3.moveObject(this.getContainerName(), this.getKey(), this.getContainerName(), new S3Object(((S3Path)renamed).getKey()), false);
                    this.setPath(renamed.getAbsolute());
                    if (!this.getContainerName().equals(((S3Path)renamed).getContainerName())) {
                        this._bucket = null;
                    }
                    break block7;
                }
                if (!this.attributes.isDirectory()) break block7;
                for (AbstractPath i : this.childs()) {
                    if (this.session.isConnected()) {
                        i.rename(PathFactory.createPath(this.getSession(), renamed.getAbsolute(), i.getName(), i.attributes.getType()));
                        continue;
                    }
                    break;
                }
            }
            catch (S3ServiceException e) {
                this.error(this.attributes.isFile() ? "Cannot rename file" : "Cannot rename folder", e);
            }
            catch (IOException e) {
                this.error(this.attributes.isFile() ? "Cannot rename file" : "Cannot rename folder", e);
            }
        }
    }

    @Override
    public void copy(AbstractPath copy) {
        block6: {
            try {
                if (this.attributes.isFile()) {
                    this.session.check();
                    this.session.message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Copying {0} to {1}", "Status"), this.getName(), copy));
                    this.session.S3.copyObject(this.getContainerName(), this.getKey(), ((S3Path)copy).getContainerName(), new S3Object(((S3Path)copy).getKey()), false);
                    break block6;
                }
                if (!this.attributes.isDirectory()) break block6;
                for (AbstractPath i : this.childs()) {
                    if (this.session.isConnected()) {
                        i.copy(PathFactory.createPath(this.getSession(), copy.getAbsolute(), i.getName(), i.attributes.getType()));
                        continue;
                    }
                    break;
                }
            }
            catch (S3ServiceException e) {
                this.error(this.attributes.isFile() ? "Cannot copy file" : "Cannot copy folder", e);
            }
            catch (IOException e) {
                this.error(this.attributes.isFile() ? "Cannot copy file" : "Cannot copy folder", e);
            }
        }
    }

    @Override
    public String toHttpURL() {
        return this.toURL();
    }

    @Override
    public String toURL() {
        String key;
        if (Preferences.instance().getBoolean("s3.url.public")) {
            return this.createSignedUrl();
        }
        String string = key = this.isContainer() ? "" : this.encode(this.getKey());
        if (RestS3Service.isBucketNameValidDNSName((String)this.getContainerName())) {
            return Protocol.S3.getScheme() + "://" + this.session.getHostnameForBucket(this.getContainerName()) + key;
        }
        return this.getSession().getHost().toURL() + "/" + this.getContainerName() + key;
    }

    public String createSignedUrl() {
        try {
            this.session.check();
            int secondsFromNow = Preferences.instance().getInteger("s3.url.expire.seconds");
            Calendar cal = Calendar.getInstance();
            cal.add(13, secondsFromNow);
            long secondsSinceEpoch = cal.getTimeInMillis() / 1000L;
            return S3Service.createSignedUrl((String)"GET", (String)this.getContainerName(), (String)this.getKey(), null, null, (AWSCredentials)this.session.S3.getAWSCredentials(), (long)secondsSinceEpoch, (boolean)false, (boolean)this.getHost().getProtocol().isSecure(), (boolean)this.session.configuration.getBoolProperty("s3service.disable-dns-buckets", false));
        }
        catch (S3ServiceException e) {
            this.error("Cannot read file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
        return null;
    }

    public String createTorrentUrl() {
        return S3Service.createTorrentUrl((String)this.getContainerName(), (String)this.getKey());
    }

    @Override
    public ch.cyberduck.core.cloud.Distribution readDistribution() {
        if (this.getHost().getCredentials().isAnonymousLogin()) {
            return new ch.cyberduck.core.cloud.Distribution(false, null, null);
        }
        try {
            this.session.check();
            Distribution[] arr$ = this.session.listDistributions(this.getContainerName());
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ < len$) {
                Distribution d = arr$[i$];
                DistributionConfig distributionConfig = this.session.getDistributionConfig(d);
                return new ch.cyberduck.core.cloud.Distribution(d.isEnabled(), d.getStatus().equals("InProgress"), "http://" + d.getDomainName(), ch.cyberduck.core.i18n.Locale.localizedString(d.getStatus(), "S3"), d.getCNAMEs(), distributionConfig.isLoggingEnabled());
            }
        }
        catch (CloudFrontServiceException e) {
            if (e.getResponseCode() == 403) {
                log.warn((Object)("Invalid CloudFront account:" + e.getMessage()));
                return new ch.cyberduck.core.cloud.Distribution(false, null, null);
            }
            this.error("Cannot read file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
        return new ch.cyberduck.core.cloud.Distribution(false, null, null);
    }

    @Override
    public void writeDistribution(boolean enabled, String[] cnames, boolean logging) {
        String container = this.getContainerName();
        if (this.getHost().getCredentials().isAnonymousLogin()) {
            return;
        }
        try {
            LoggingStatus l = null;
            if (logging) {
                l = new LoggingStatus(this.session.getHostnameForBucket(this.getContainerName()), Preferences.instance().getProperty("cloudfront.logging.prefix"));
            }
            this.session.check();
            if (enabled) {
                this.session.message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Enable {0} Distribution", "Status"), ch.cyberduck.core.i18n.Locale.localizedString("Amazon CloudFront", "S3")));
            } else {
                this.session.message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Disable {0} Distribution", "Status"), ch.cyberduck.core.i18n.Locale.localizedString("Amazon CloudFront", "S3")));
            }
            Distribution[] arr$ = this.session.listDistributions(container);
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ < len$) {
                Distribution distribution = arr$[i$];
                this.session.updateDistribution(enabled, distribution, cnames, l);
                return;
            }
            this.session.createDistribution(enabled, container, cnames, l);
        }
        catch (CloudFrontServiceException e) {
            this.error("Cannot write file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot write file attributes", e);
        }
    }

    static {
        PathFactory.addFactory(Protocol.S3, new Factory());
        boolean[][] access = new boolean[3][3];
        access[0][0] = true;
        access[0][1] = true;
        access[0][2] = true;
        DEFAULT_FOLDER_PERMISSION = new Permission(access);
    }

    private class S3ServiceTransferEventAdaptor
    extends S3ServiceEventAdaptor {
        long bytesTransferred;
        private StreamListener listener;

        public S3ServiceTransferEventAdaptor(StreamListener listener) {
            this.bytesTransferred = S3Path.this.getStatus().getCurrent();
            this.listener = listener;
        }

        public void s3ServiceEventPerformed(CreateObjectsEvent event) {
            super.s3ServiceEventPerformed(event);
            if (3 == event.getEventCode()) {
                ThreadWatcher watcher = event.getThreadWatcher();
                long diff = watcher.getBytesTransferred() - this.bytesTransferred;
                this.listener.bytesSent(diff);
                S3Path.this.getStatus().setCurrent(this.bytesTransferred += diff);
            } else if (1 == event.getEventCode()) {
                ThreadWatcher watcher = event.getThreadWatcher();
                S3Path.this.cancelTrigger = watcher.getCancelEventListener();
            } else if (2 == event.getEventCode()) {
                S3Path.this.getStatus().setComplete(true);
            } else if (0 == event.getEventCode()) {
                S3Path.this.error("Upload failed", event.getErrorCause());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<S3Session> {
        private Factory() {
        }

        @Override
        protected Path create(S3Session session, String path, int type) {
            return new S3Path(session, path, type);
        }

        @Override
        protected Path create(S3Session session, String parent, String name, int type) {
            return new S3Path(session, parent, name, type);
        }

        @Override
        protected Path create(S3Session session, String path, Local file) {
            return new S3Path(session, path, file);
        }

        @Override
        protected <T> Path create(S3Session session, T dict) {
            return new S3Path(session, dict);
        }
    }
}

