/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public abstract class AbstractX509TrustManager
implements X509TrustManager {
    protected static Logger log = Logger.getLogger(AbstractX509TrustManager.class);
    private String hostname;
    private Set<X509Certificate> acceptedCertificates = new HashSet<X509Certificate>();

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    protected AbstractX509TrustManager(String hostname) {
        this.hostname = hostname;
    }

    protected void acceptCertificate(X509Certificate[] certs) {
        if (log.isDebugEnabled()) {
            for (X509Certificate cert : certs) {
                log.debug((Object)("Certificate trusted:" + cert.toString()));
            }
        }
        this.acceptedCertificates.addAll(Arrays.asList(certs));
    }

    protected void acceptCertificate(X509Certificate cert) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Certificate trusted:" + cert.toString()));
        }
        this.acceptedCertificates.add(cert);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.acceptedCertificates.toArray(new X509Certificate[this.acceptedCertificates.size()]);
    }
}

