/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class DefaultX509TrustManager
implements X509TrustManager {
    private static Logger log = Logger.getLogger(DefaultX509TrustManager.class);
    private X509TrustManager standardTrustManager;

    public DefaultX509TrustManager() {
        try {
            this.init(KeyStore.getInstance(KeyStore.getDefaultType()));
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage());
        }
        catch (KeyStoreException e) {
            log.error((Object)e.getMessage());
        }
    }

    protected void init(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(x509Certificates, authType);
    }

    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        if (x509Certificates != null) {
            log.info((Object)"Server certificate chain:");
            for (int i = 0; i < x509Certificates.length; ++i) {
                log.info((Object)("X509Certificate[" + i + "]=" + x509Certificates[i]));
            }
        }
        if (x509Certificates != null && x509Certificates.length == 1) {
            x509Certificates[0].checkValidity();
        } else {
            this.standardTrustManager.checkServerTrusted(x509Certificates, authType);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

