/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.Keychain;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.ssl.AbstractX509TrustManager;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;

public class KeychainX509TrustManager
extends AbstractX509TrustManager {
    protected static Logger log = Logger.getLogger(KeychainX509TrustManager.class);

    public KeychainX509TrustManager(String hostname) {
        super(hostname);
    }

    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.checkCertificates(x509Certificates);
    }

    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.checkCertificates(x509Certificates);
    }

    private void checkCertificates(X509Certificate[] certs) throws CertificateException {
        if (Keychain.instance().isTrusted(this.getHostname(), certs)) {
            log.info((Object)"Certificate trusted in Keychain");
            this.acceptCertificate(certs);
            return;
        }
        throw new CertificateException(Locale.localizedString("No trusted certificate found", "Status"));
    }
}

