/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.ErrorListener;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundException;
import ch.cyberduck.ui.cocoa.foundation.NSAutoreleasePool;
import ch.cyberduck.ui.growl.Growl;
import com.enterprisedt.net.ftp.FTPNullReplyException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public abstract class RepeatableBackgroundAction
extends AbstractBackgroundAction
implements ErrorListener,
TranscriptListener {
    private static Logger log = Logger.getLogger(RepeatableBackgroundAction.class);
    protected StringBuffer transcript;
    private static final int TRANSCRIPT_MAX_LENGTH = Preferences.instance().getInteger("transcript.length");
    private final int repeatAttempts = Preferences.instance().getInteger("connection.retry");
    protected List<BackgroundException> exceptions = new Collection<BackgroundException>();
    protected int repeatCount;

    public void error(BackgroundException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof ConnectionCanceledException) {
            log.warn((Object)cause.getMessage());
            return;
        }
        String description = null == exception.getPath() ? exception.getSession().getHost().getHostname() : exception.getPath().getName();
        Growl.instance().notify(exception.getMessage(), description);
        this.exceptions.add(exception);
    }

    public void log(boolean request, String message) {
        if (this.transcript.length() > TRANSCRIPT_MAX_LENGTH) {
            this.transcript = new StringBuffer();
        }
        this.transcript.append(message).append("\n");
    }

    public boolean prepare() {
        Session session = this.getSession();
        if (session != null) {
            session.addErrorListener(this);
            session.addTranscriptListener(this);
        }
        this.transcript = new StringBuffer();
        return super.prepare();
    }

    protected abstract Session getSession();

    public int retry() {
        if (!this.isCanceled()) {
            for (BackgroundException e : this.exceptions) {
                Throwable cause = e.getCause();
                if (!(cause instanceof SocketException) && !(cause instanceof SocketTimeoutException) && !(cause instanceof UnknownHostException) && !(cause instanceof FTPNullReplyException)) continue;
                return this.repeatAttempts - this.repeatCount;
            }
        }
        return 0;
    }

    protected boolean hasFailed() {
        return this.exceptions.size() > 0;
    }

    public void finish() {
        while (this.hasFailed() && this.retry() > 0) {
            log.info((Object)("Retry failed background action:" + this));
            this.pause();
            if (this.isCanceled()) continue;
            ++this.repeatCount;
            this.exceptions.clear();
            this.run();
        }
        Session session = this.getSession();
        if (session != null) {
            session.removeTranscriptListener(this);
            session.removeErrorListener(this);
        }
        super.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        block5: {
            Timer wakeup = new Timer();
            wakeup.scheduleAtFixedRate(new TimerTask(){
                private int delay = (int)Preferences.instance().getDouble("connection.retry.delay");

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    NSAutoreleasePool pool = NSAutoreleasePool.push();
                    try {
                        if (0 == this.delay || RepeatableBackgroundAction.this.isCanceled()) {
                            this.cancel();
                            return;
                        }
                        Session session = RepeatableBackgroundAction.this.getSession();
                        if (session != null) {
                            session.message(MessageFormat.format(Locale.localizedString("Retry again in {0} seconds ({1} more attempts)", "Status"), String.valueOf(this.delay), String.valueOf(RepeatableBackgroundAction.this.retry())));
                        }
                        --this.delay;
                    }
                    finally {
                        pool.drain();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean cancel() {
                    Object lock = RepeatableBackgroundAction.this.lock();
                    if (lock != null) {
                        Object object = lock;
                        synchronized (object) {
                            lock.notify();
                        }
                    }
                    return super.cancel();
                }
            }, 0L, 1000L);
            try {
                Object lock = this.lock();
                if (lock == null) break block5;
                Object object = lock;
                synchronized (object) {
                    lock.wait();
                }
            }
            catch (InterruptedException e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    public String toString() {
        Session session = this.getSession();
        if (session != null) {
            return session.getHost().getHostname();
        }
        return Locale.localizedString("Unknown");
    }
}

