/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.ConnectionMonitor;
import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.HTTPProxyException;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.LocalPortForwarder;
import ch.ethz.ssh2.LocalStreamForwarder;
import ch.ethz.ssh2.ProxyData;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.auth.AuthenticationManager;
import ch.ethz.ssh2.channel.ChannelManager;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.cipher.BlockCipherFactory;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.packets.PacketIgnore;
import ch.ethz.ssh2.transport.KexManager;
import ch.ethz.ssh2.transport.TransportManager;
import ch.ethz.ssh2.util.TimeoutService;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.security.SecureRandom;
import java.util.Vector;

public class Connection {
    public static final String identification = "Ganymed Build_211beta5";
    private SecureRandom generator;
    private AuthenticationManager am;
    private boolean authenticated = false;
    private ChannelManager cm;
    private CryptoWishList cryptoWishList = new CryptoWishList();
    private DHGexParameters dhgexpara = new DHGexParameters();
    private final String hostname;
    private final int port;
    private TransportManager tm;
    private boolean tcpNoDelay = false;
    private ProxyData proxyData = null;
    private Vector connectionMonitors = new Vector();

    public static synchronized String[] getAvailableCiphers() {
        return BlockCipherFactory.getDefaultCipherList();
    }

    public static synchronized String[] getAvailableMACs() {
        return MAC.getMacList();
    }

    public static synchronized String[] getAvailableServerHostKeyAlgorithms() {
        return KexManager.getDefaultServerHostkeyAlgorithmList();
    }

    public Connection(String hostname) {
        this(hostname, 22);
    }

    public Connection(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public synchronized boolean authenticateWithDSA(String user, String pem, String password) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (user == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (pem == null) {
            throw new IllegalArgumentException("pem argument is null");
        }
        this.authenticated = this.am.authenticatePublicKey(user, pem.toCharArray(), password, this.getOrCreateSecureRND());
        return this.authenticated;
    }

    public synchronized boolean authenticateWithKeyboardInteractive(String user, InteractiveCallback cb) throws IOException {
        return this.authenticateWithKeyboardInteractive(user, null, cb);
    }

    public synchronized boolean authenticateWithKeyboardInteractive(String user, String[] submethods, InteractiveCallback cb) throws IOException {
        if (cb == null) {
            throw new IllegalArgumentException("Callback may not ne NULL!");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (user == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        this.authenticated = this.am.authenticateInteractive(user, submethods, cb);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPassword(String user, String password) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (user == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password argument is null");
        }
        this.authenticated = this.am.authenticatePassword(user, password);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithNone(String user) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (user == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        this.authenticated = this.am.authenticateNone(user);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPublicKey(String user, char[] pemPrivateKey, String password) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (user == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (pemPrivateKey == null) {
            throw new IllegalArgumentException("pemPrivateKey argument is null");
        }
        this.authenticated = this.am.authenticatePublicKey(user, pemPrivateKey, password, this.getOrCreateSecureRND());
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPublicKey(String user, File pemFile, String password) throws IOException {
        int len;
        if (pemFile == null) {
            throw new IllegalArgumentException("pemFile argument is null");
        }
        char[] buff = new char[256];
        CharArrayWriter cw = new CharArrayWriter();
        FileReader fr = new FileReader(pemFile);
        while ((len = fr.read(buff)) >= 0) {
            cw.write(buff, 0, len);
        }
        fr.close();
        return this.authenticateWithPublicKey(user, cw.toCharArray(), password);
    }

    public synchronized void addConnectionMonitor(ConnectionMonitor cmon) {
        if (cmon == null) {
            throw new IllegalArgumentException("cmon argument is null");
        }
        this.connectionMonitors.addElement(cmon);
        if (this.tm != null) {
            this.tm.setConnectionMonitors(this.connectionMonitors);
        }
    }

    public synchronized void close() {
        Throwable t = new Throwable("Closed due to user request.");
        this.close(t, false);
    }

    public void close(Throwable t, boolean hard) {
        if (this.cm != null) {
            this.cm.closeAllChannels();
        }
        if (this.tm != null) {
            this.tm.close(t, !hard);
            this.tm = null;
        }
        this.am = null;
        this.cm = null;
        this.authenticated = false;
    }

    public synchronized ConnectionInfo connect() throws IOException {
        return this.connect(null, 0, 0);
    }

    public synchronized ConnectionInfo connect(ServerHostKeyVerifier verifier) throws IOException {
        return this.connect(verifier, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConnectionInfo connect(ServerHostKeyVerifier verifier, int connectTimeout, int kexTimeout) throws IOException {
        if (this.tm != null) {
            throw new IOException("Connection to " + this.hostname + " is already in connected state!");
        }
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout must be non-negative!");
        }
        if (kexTimeout < 0) {
            throw new IllegalArgumentException("kexTimeout must be non-negative!");
        }
        final class TimeoutState {
            boolean isCancelled = false;
            boolean timeoutSocketClosed = false;

            TimeoutState() {
            }
        }
        final TimeoutState state = new TimeoutState();
        this.tm = new TransportManager(this.hostname, this.port);
        this.tm.setConnectionMonitors(this.connectionMonitors);
        TransportManager transportManager = this.tm;
        synchronized (transportManager) {
        }
        try {
            TimeoutService.TimeoutToken token = null;
            if (kexTimeout > 0) {
                Runnable timeoutHandler = new Runnable(){
                    {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        TimeoutState timeoutState = state;
                        synchronized (timeoutState) {
                            if (state.isCancelled) {
                                return;
                            }
                            state.timeoutSocketClosed = true;
                            Connection.this.tm.close(new SocketTimeoutException("The connect timeout expired"), false);
                        }
                    }
                };
                long timeoutHorizont = System.currentTimeMillis() + (long)kexTimeout;
                token = TimeoutService.addTimeoutHandler(timeoutHorizont, timeoutHandler);
            }
            try {
                this.tm.initialize(this.cryptoWishList, verifier, this.dhgexpara, connectTimeout, this.getOrCreateSecureRND(), this.proxyData);
            }
            catch (SocketTimeoutException se) {
                throw (SocketTimeoutException)new SocketTimeoutException("The connect() operation on the socket timed out.").initCause(se);
            }
            this.tm.setTcpNoDelay(this.tcpNoDelay);
            ConnectionInfo ci = this.tm.getConnectionInfo(1);
            if (token != null) {
                TimeoutService.cancelTimeoutHandler(token);
                TimeoutState timeoutState = state;
                synchronized (timeoutState) {
                    if (state.timeoutSocketClosed) {
                        throw new IOException("This exception will be replaced by the one below =)");
                    }
                    state.isCancelled = true;
                }
            }
            return ci;
        }
        catch (SocketTimeoutException ste) {
            throw ste;
        }
        catch (IOException e1) {
            this.close(new Throwable("There was a problem during connect."), false);
            TimeoutState timeoutState = state;
            synchronized (timeoutState) {
                if (state.timeoutSocketClosed) {
                    throw new SocketTimeoutException("The kexTimeout (" + kexTimeout + " ms) expired.");
                }
            }
            if (e1 instanceof HTTPProxyException) {
                throw e1;
            }
            throw (IOException)new IOException("There was a problem while connecting to " + this.hostname + ":" + this.port).initCause(e1);
        }
    }

    public synchronized LocalPortForwarder createLocalPortForwarder(int local_port, String host_to_connect, int port_to_connect) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward ports, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward ports, connection is not authenticated.");
        }
        return new LocalPortForwarder(this.cm, local_port, host_to_connect, port_to_connect);
    }

    public synchronized LocalPortForwarder createLocalPortForwarder(InetSocketAddress addr, String host_to_connect, int port_to_connect) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward ports, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward ports, connection is not authenticated.");
        }
        return new LocalPortForwarder(this.cm, addr, host_to_connect, port_to_connect);
    }

    public synchronized LocalStreamForwarder createLocalStreamForwarder(String host_to_connect, int port_to_connect) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward, connection is not authenticated.");
        }
        return new LocalStreamForwarder(this.cm, host_to_connect, port_to_connect);
    }

    public synchronized void forceKeyExchange() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        this.tm.forceKeyExchange(this.cryptoWishList, this.dhgexpara);
    }

    public synchronized String getHostname() {
        return this.hostname;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized ConnectionInfo getConnectionInfo() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot get details of connection, you need to establish a connection first.");
        }
        return this.tm.getConnectionInfo(1);
    }

    public synchronized String[] getRemainingAuthMethods(String user) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("user argument may not be NULL!");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        return this.am.getRemainingMethods(user);
    }

    public synchronized boolean isAuthenticationComplete() {
        return this.authenticated;
    }

    public synchronized boolean isAuthenticationPartialSuccess() {
        if (this.am == null) {
            return false;
        }
        return this.am.getPartialSuccess();
    }

    public synchronized boolean isAuthMethodAvailable(String user, String method) throws IOException {
        if (method == null) {
            throw new IllegalArgumentException("method argument may not be NULL!");
        }
        String[] methods = this.getRemainingAuthMethods(user);
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].compareTo(method) != 0) continue;
            return true;
        }
        return false;
    }

    private final SecureRandom getOrCreateSecureRND() {
        if (this.generator == null) {
            this.generator = new SecureRandom();
        }
        return this.generator;
    }

    public synchronized Session openSession() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot open session, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot open session, connection is not authenticated.");
        }
        return new Session(this.cm, this.getOrCreateSecureRND());
    }

    public synchronized void sendIgnorePacket() throws IOException {
        SecureRandom rnd = this.getOrCreateSecureRND();
        byte[] data = new byte[rnd.nextInt(16)];
        rnd.nextBytes(data);
        this.sendIgnorePacket(data);
    }

    public synchronized void sendIgnorePacket(byte[] data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("data argument must not be null.");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Cannot send SSH_MSG_IGNORE packet, you need to establish a connection first.");
        }
        PacketIgnore pi = new PacketIgnore();
        pi.setData(data);
        this.tm.sendMessage(pi.getPayload());
    }

    private String[] removeDuplicates(String[] list) {
        if (list == null || list.length < 2) {
            return list;
        }
        String[] list2 = new String[list.length];
        int count = 0;
        for (int i = 0; i < list.length; ++i) {
            boolean duplicate = false;
            String element = list[i];
            for (int j = 0; j < count; ++j) {
                if ((element != null || list2[j] != null) && (element == null || !element.equals(list2[j]))) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            list2[count++] = list[i];
        }
        if (count == list2.length) {
            return list2;
        }
        String[] tmp = new String[count];
        System.arraycopy(list2, 0, tmp, 0, count);
        return tmp;
    }

    public synchronized void setClient2ServerCiphers(String[] ciphers) {
        if (ciphers == null || ciphers.length == 0) {
            throw new IllegalArgumentException();
        }
        ciphers = this.removeDuplicates(ciphers);
        BlockCipherFactory.checkCipherList(ciphers);
        this.cryptoWishList.c2s_enc_algos = ciphers;
    }

    public synchronized void setClient2ServerMACs(String[] macs) {
        if (macs == null || macs.length == 0) {
            throw new IllegalArgumentException();
        }
        macs = this.removeDuplicates(macs);
        MAC.checkMacList(macs);
        this.cryptoWishList.c2s_mac_algos = macs;
    }

    public synchronized void setDHGexParameters(DHGexParameters dgp) {
        if (dgp == null) {
            throw new IllegalArgumentException();
        }
        this.dhgexpara = dgp;
    }

    public synchronized void setServer2ClientCiphers(String[] ciphers) {
        if (ciphers == null || ciphers.length == 0) {
            throw new IllegalArgumentException();
        }
        ciphers = this.removeDuplicates(ciphers);
        BlockCipherFactory.checkCipherList(ciphers);
        this.cryptoWishList.s2c_enc_algos = ciphers;
    }

    public synchronized void setServer2ClientMACs(String[] macs) {
        if (macs == null || macs.length == 0) {
            throw new IllegalArgumentException();
        }
        macs = this.removeDuplicates(macs);
        MAC.checkMacList(macs);
        this.cryptoWishList.s2c_mac_algos = macs;
    }

    public synchronized void setServerHostKeyAlgorithms(String[] algos) {
        if (algos == null || algos.length == 0) {
            throw new IllegalArgumentException();
        }
        algos = this.removeDuplicates(algos);
        KexManager.checkServerHostkeyAlgorithmsList(algos);
        this.cryptoWishList.serverHostKeyAlgorithms = algos;
    }

    public synchronized void setTCPNoDelay(boolean enable) throws IOException {
        this.tcpNoDelay = enable;
        if (this.tm != null) {
            this.tm.setTcpNoDelay(enable);
        }
    }

    public synchronized void setProxyData(ProxyData proxyData) {
        this.proxyData = proxyData;
    }

    public synchronized void requestRemotePortForwarding(String bindAddress, int bindPort, String targetAddress, int targetPort) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("The connection is not authenticated.");
        }
        if (bindAddress == null || targetAddress == null || bindPort <= 0 || targetPort <= 0) {
            throw new IllegalArgumentException();
        }
        this.cm.requestGlobalForward(bindAddress, bindPort, targetAddress, targetPort);
    }

    public synchronized void cancelRemotePortForwarding(int bindPort) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("The connection is not authenticated.");
        }
        this.cm.requestCancelGlobalForward(bindPort);
    }

    public synchronized void setSecureRandom(SecureRandom rnd) {
        if (rnd == null) {
            throw new IllegalArgumentException();
        }
        this.generator = rnd;
    }
}

