/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPReply;
import java.io.IOException;

public class FTPException
extends IOException {
    private int replyCode = -1;

    public FTPException(String msg) {
        super(msg);
    }

    public FTPException(String msg, int replyCode) {
        super(msg);
        this.replyCode = replyCode;
    }

    public FTPException(String msg, String replyCode) {
        super(msg);
        try {
            this.replyCode = Integer.parseInt(replyCode);
        }
        catch (NumberFormatException ex) {
            this.replyCode = -1;
        }
    }

    public FTPException(FTPReply reply) {
        super(reply.getReplyText());
        try {
            this.replyCode = Integer.parseInt(reply.getReplyCode());
        }
        catch (NumberFormatException ex) {
            this.replyCode = -1;
        }
    }

    public int getReplyCode() {
        return this.replyCode;
    }
}

