/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.NullPathFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.Preferences;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache<E extends AbstractPath> {
    protected static Logger log = Logger.getLogger(Cache.class);
    private Map<String, AttributedList<E>> _impl = Collections.synchronizedMap(new LRUMap(Preferences.instance().getInteger("browser.cache.size")){

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            log.debug((Object)("Removing from cache:" + entry));
            return true;
        }
    });

    public E lookup(PathReference path) {
        AttributedList<E> childs = this.get(Path.getParent(path.toString()));
        if (null == childs) {
            log.warn((Object)("Lookup failed for " + path + " in cache"));
            return null;
        }
        return childs.get(path);
    }

    public boolean containsKey(E path) {
        return this.containsKey(((AbstractPath)path).getAbsolute());
    }

    public boolean containsKey(String path) {
        return this._impl.containsKey(path);
    }

    public AttributedList<E> remove(E path) {
        return this._impl.remove(((AbstractPath)path).getAbsolute());
    }

    public AttributedList<E> get(E path) {
        return this.get(((AbstractPath)path).getAbsolute());
    }

    public AttributedList<E> get(String path) {
        return this.get(path, (Comparator<E>)new NullComparator(), (PathFilter<E>)new NullPathFilter());
    }

    public AttributedList<E> get(E path, Comparator<E> comparator, PathFilter<E> filter) {
        return this.get(((AbstractPath)path).getAbsolute(), comparator, filter);
    }

    public AttributedList<E> get(String path, Comparator<E> comparator, PathFilter<E> filter) {
        boolean needsFiltering;
        AttributedList<E> childs = this._impl.get(path);
        if (null == childs) {
            log.warn((Object)("No cache for " + path));
            return AttributedList.emptyList();
        }
        boolean needsSorting = !childs.attributes().get("COMPARATOR").equals(comparator);
        boolean bl = needsFiltering = !childs.attributes().get("FILTER").equals(filter);
        if (needsSorting) {
            if (!needsFiltering) {
                Collections.sort(childs, comparator);
            }
            childs.attributes().put("COMPARATOR", comparator);
        }
        if (needsFiltering) {
            Set<E> hidden = childs.attributes().getHidden();
            childs.addAll(hidden);
            hidden.clear();
            Iterator i = childs.iterator();
            while (i.hasNext()) {
                AbstractPath child = (AbstractPath)i.next();
                if (filter.accept(child)) continue;
                childs.attributes().addHidden(child);
                i.remove();
            }
            childs.attributes().put("FILTER", filter);
            Collections.sort(childs, comparator);
        }
        return childs;
    }

    public AttributedList<E> put(E path, AttributedList<E> childs) {
        return this._impl.put(((AbstractPath)path).getAbsolute(), childs);
    }

    public void clear() {
        log.info((Object)("Clearing cache " + this.toString()));
        this._impl.clear();
    }
}

