/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Proxy;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiddenFilesPathFilter<E extends AbstractPath>
implements PathFilter<E> {
    private static Logger log = Logger.getLogger(Proxy.class);
    private Pattern HIDDEN_PATTERN;

    public HiddenFilesPathFilter() {
        try {
            this.HIDDEN_PATTERN = Pattern.compile(Preferences.instance().getProperty("browser.hidden.regex"));
        }
        catch (PatternSyntaxException e) {
            log.warn((Object)e.getMessage());
        }
    }

    @Override
    public boolean accept(E file) {
        if (null == this.HIDDEN_PATTERN) {
            return true;
        }
        return !this.HIDDEN_PATTERN.matcher(((AbstractPath)file).getName()).matches();
    }
}

