/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AbstractStreamListener;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.TransferOptions;
import ch.cyberduck.core.TransferPrompt;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.IOResumeException;
import ch.cyberduck.core.io.ThrottledInputStream;
import ch.cyberduck.core.io.ThrottledOutputStream;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.DeserializerFactory;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.serializer.SerializerFactory;
import ch.cyberduck.ui.cocoa.model.CDPathReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Path
extends AbstractPath
implements Serializable {
    private static Logger log = Logger.getLogger(Path.class);
    private PathReference reference;
    private String path;
    private Local local;
    private Status status;
    private Pattern TEXT_FILETYPE_PATTERN = null;
    private Pattern BINARY_FILETYPE_PATTERN;
    private Path parent;

    public Pattern getTextFiletypePattern() {
        String regex = Preferences.instance().getProperty("filetype.text.regex");
        if (null == this.TEXT_FILETYPE_PATTERN || !this.TEXT_FILETYPE_PATTERN.pattern().equals(regex)) {
            try {
                this.TEXT_FILETYPE_PATTERN = Pattern.compile(regex, 2);
            }
            catch (PatternSyntaxException e) {
                log.warn((Object)e.getMessage());
            }
        }
        return this.TEXT_FILETYPE_PATTERN;
    }

    public Pattern getBinaryFiletypePattern() {
        String regex = Preferences.instance().getProperty("filetype.binary.regex");
        if (null == this.BINARY_FILETYPE_PATTERN || !this.BINARY_FILETYPE_PATTERN.pattern().equals(regex)) {
            try {
                this.BINARY_FILETYPE_PATTERN = Pattern.compile(regex, 2);
            }
            catch (PatternSyntaxException e) {
                log.warn((Object)e.getMessage());
            }
        }
        return this.BINARY_FILETYPE_PATTERN;
    }

    protected <T> Path(T dict) {
        this.attributes = new PathAttributes();
        this.init(dict);
    }

    @Override
    public <T> void init(T serialized) {
        Object attributesObj;
        String symlinkObj;
        String localObj;
        Deserializer dict = DeserializerFactory.createDeserializer(serialized);
        String pathObj = dict.stringForKey("Remote");
        if (pathObj != null) {
            this.setPath(pathObj);
        }
        if ((localObj = dict.stringForKey("Local")) != null) {
            this.setLocal(LocalFactory.createLocal(localObj));
        }
        if ((symlinkObj = dict.stringForKey("Symlink")) != null) {
            this.setSymbolicLinkPath(symlinkObj);
        }
        if ((attributesObj = dict.objectForKey("Attributes")) != null) {
            this.attributes = new PathAttributes(attributesObj);
        }
        if (dict.stringForKey("Complete") != null) {
            this.getStatus().setComplete(true);
        }
        if (dict.stringForKey("Skipped") != null) {
            this.getStatus().setSkipped(true);
        }
    }

    public <S> S getAsDictionary() {
        Serializer dict = SerializerFactory.createSerializer();
        dict.setStringForKey(this.getAbsolute(), "Remote");
        if (this.local != null) {
            dict.setStringForKey(this.local.toString(), "Local");
        }
        if (StringUtils.isNotBlank((String)this.getSymbolicLinkPath())) {
            dict.setStringForKey(this.getSymbolicLinkPath(), "Symlink");
        }
        dict.setObjectForKey((PathAttributes)this.attributes, "Attributes");
        if (this.getStatus().isComplete()) {
            dict.setStringForKey(String.valueOf(true), "Complete");
        }
        if (this.getStatus().isSkipped()) {
            dict.setStringForKey(String.valueOf(true), "Skipped");
        }
        return (S)dict.getSerialized();
    }

    protected Path(String parent, String name, int type) {
        this.attributes = new PathAttributes();
        this.setPath(parent, name);
        this.attributes.setType(type);
    }

    protected Path(String path, int type) {
        this.attributes = new PathAttributes();
        this.setPath(path);
        this.attributes.setType(type);
    }

    protected Path(String parent, Local local) {
        this.attributes = new PathAttributes();
        this.setPath(parent, local);
        this.attributes.setType(local.attributes.isDirectory() ? 2 : 1);
    }

    public void setPath(String parent, Local file) {
        this.setPath(parent, file.getName());
        this.setLocal(file);
    }

    @Override
    public void setPath(String name) {
        this.path = Path.normalize(name);
        this.parent = null;
    }

    public void setParent(Path parent) {
        this.parent = parent;
    }

    @Override
    public Path getParent() {
        return this.getParent(true);
    }

    public Path getParent(boolean create) {
        if (null == this.parent && create) {
            if (this.isRoot()) {
                return this;
            }
            String parent = Path.getParent(this.getAbsolute());
            this.parent = "/".equals(parent) ? PathFactory.createPath(this.getSession(), "/", 10) : PathFactory.createPath(this.getSession(), parent, 2);
        }
        return this.parent;
    }

    public Status getStatus() {
        if (null == this.status) {
            this.status = new Status();
        }
        return this.status;
    }

    public Host getHost() {
        return this.getSession().getHost();
    }

    public Cache<Path> cache() {
        return this.getSession().cache();
    }

    public void writeOwner(String owner, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    public void writeGroup(String group, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    public abstract void readSize();

    public abstract void readTimestamp();

    public abstract void readPermission();

    @Override
    public String getName() {
        if (this.isRoot()) {
            return "/";
        }
        String abs = this.getAbsolute();
        int index = abs.lastIndexOf("/");
        return abs.substring(index + 1);
    }

    @Override
    public String getAbsolute() {
        return this.path;
    }

    @Override
    public <T> PathReference<T> getReference() {
        if (null == this.reference) {
            this.reference = new CDPathReference(this.getAbsolute());
        }
        return this.reference;
    }

    public void setLocal(Local file) {
        if (null != file && file.attributes.isSymbolicLink() && null != file.getSymbolicLinkPath()) {
            this.local = LocalFactory.createLocal(file.getSymbolicLinkPath());
            return;
        }
        this.local = file;
    }

    public Local getLocal() {
        if (null == this.local) {
            return this.getDefaultLocal();
        }
        return this.local;
    }

    private Local getDefaultLocal() {
        return LocalFactory.createLocal(this.getHost().getDownloadFolder(), this.getName());
    }

    public String kind() {
        if (this.attributes.isSymbolicLink()) {
            if (this.attributes.isFile()) {
                return Locale.localizedString("Symbolic Link (File)");
            }
            if (this.attributes.isDirectory()) {
                return Locale.localizedString("Symbolic Link (Folder)");
            }
        }
        if (this.attributes.isFile()) {
            return this.getLocal().kind();
        }
        if (this.attributes.isDirectory()) {
            return Locale.localizedString("Folder");
        }
        return Locale.localizedString("Unknown");
    }

    public abstract Session getSession();

    public void download() {
        this.download(new AbstractStreamListener());
    }

    public void download(boolean check) {
        this.download(new BandwidthThrottle(-1.0f), new AbstractStreamListener(), check);
    }

    public void download(StreamListener listener) {
        this.download(new BandwidthThrottle(-1.0f), listener);
    }

    public void download(BandwidthThrottle throttle, StreamListener listener) {
        this.download(throttle, listener, false);
    }

    public abstract void download(BandwidthThrottle var1, StreamListener var2, boolean var3);

    public void upload() {
        this.upload(new AbstractStreamListener());
    }

    public void upload(StreamListener listener) {
        this.upload(new BandwidthThrottle(-1.0f), listener);
    }

    public void upload(BandwidthThrottle throttle, StreamListener listener) {
        this.upload(throttle, listener, null);
    }

    public void upload(BandwidthThrottle throttle, StreamListener listener, Permission p) {
        this.upload(throttle, listener, p, false);
        this.getParent().invalidate();
    }

    protected abstract void upload(BandwidthThrottle var1, StreamListener var2, Permission var3, boolean var4);

    protected void upload(OutputStream out, InputStream in, BandwidthThrottle throttle, StreamListener l) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("upload(" + out.toString() + ", " + in.toString()));
        }
        this.getSession().message(MessageFormat.format(Locale.localizedString("Uploading {0}", "Status"), this.getName()));
        if (this.getStatus().isResume()) {
            long skipped = in.skip(this.getStatus().getCurrent());
            log.info((Object)("Skipping " + skipped + " bytes"));
            if (skipped < this.getStatus().getCurrent()) {
                throw new IOResumeException("Skipped " + skipped + " bytes instead of " + this.getStatus().getCurrent());
            }
        }
        this.transfer(in, new ThrottledOutputStream(out, throttle), l);
    }

    protected void download(InputStream in, OutputStream out, BandwidthThrottle throttle, final StreamListener l) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("download(" + in.toString() + ", " + out.toString()));
        }
        this.getSession().message(MessageFormat.format(Locale.localizedString("Downloading {0}", "Status"), this.getName()));
        final boolean updateIcon = this.attributes.getSize() > 0x500000L;
        this.getLocal().setIcon(0);
        if (Preferences.instance().getBoolean("queue.download.quarantine")) {
            this.getLocal().setQuarantine(this.getHost().toURL(), this.toURL());
        }
        if (Preferences.instance().getBoolean("queue.download.wherefrom")) {
            this.getLocal().setWhereFrom(this.toURL());
        }
        StreamListener listener = new StreamListener(){
            int step = 0;

            public void bytesSent(long bytes) {
                l.bytesSent(bytes);
            }

            public void bytesReceived(long bytes) {
                if (-1L == bytes) {
                    Path.this.getLocal().setIcon(-1);
                } else {
                    int fraction;
                    l.bytesReceived(bytes);
                    if (updateIcon && (fraction = (int)(Path.this.getStatus().getCurrent() / Path.this.attributes.getSize() * 10L)) > this.step) {
                        Path.this.getLocal().setIcon(++this.step);
                    }
                }
            }
        };
        this.transfer(new ThrottledInputStream(in, throttle), out, listener);
    }

    private void transfer(InputStream in, OutputStream out, StreamListener listener) throws IOException {
        int chunksize = 32768;
        byte[] chunk = new byte[32768];
        long bytesTransferred = this.getStatus().getCurrent();
        while (!this.getStatus().isCanceled()) {
            int read = in.read(chunk, 0, 32768);
            listener.bytesReceived(read);
            if (-1 == read) {
                this.getStatus().setComplete(true);
                break;
            }
            out.write(chunk, 0, read);
            listener.bytesSent(read);
            this.getStatus().setCurrent(bytesTransferred += (long)read);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(AbstractPath copy) {
        Local local = LocalFactory.createLocal(Preferences.instance().getProperty("tmp.dir"), copy.getName());
        TransferOptions options = new TransferOptions();
        options.closeSession = false;
        try {
            this.setLocal(local);
            DownloadTransfer download = new DownloadTransfer(this);
            download.start(new TransferPrompt(){

                public TransferAction prompt() {
                    return TransferAction.ACTION_OVERWRITE;
                }
            }, options);
            ((Path)copy).setLocal(local);
            UploadTransfer upload = new UploadTransfer((Path)copy);
            upload.start(new TransferPrompt(){

                public TransferAction prompt() {
                    return TransferAction.ACTION_OVERWRITE;
                }
            }, options);
        }
        finally {
            local.delete();
        }
    }

    @Override
    public boolean exists() {
        if (this.isRoot()) {
            return true;
        }
        return this.getParent().childs().contains(this);
    }

    public int hashCode() {
        return this.getAbsolute().hashCode();
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof Path) {
            return this.getAbsolute().equals(((Path)other).getAbsolute());
        }
        return this.getAbsolute().equals(other.toString());
    }

    public String toString() {
        return this.getAbsolute();
    }

    public String encode(String p) {
        try {
            StringBuffer b = new StringBuffer();
            StringTokenizer t = new StringTokenizer(p, "/");
            while (t.hasMoreTokens()) {
                b.append("/").append(URLEncoder.encode(t.nextToken(), "UTF-8"));
            }
            return b.toString().replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    @Override
    public String toURL() {
        return this.getHost().toURL() + this.encode(this.getAbsolute());
    }

    public String toHttpURL() {
        return this.toHttpURL(this.getHost().getWebURL());
    }

    protected String toHttpURL(String host) {
        String absolute = this.encode(this.getAbsolute());
        if (StringUtils.isNotBlank((String)this.getHost().getDefaultPath()) && absolute.startsWith(this.getHost().getDefaultPath())) {
            absolute = absolute.substring(this.getHost().getDefaultPath().length());
        }
        if (!absolute.startsWith("/")) {
            absolute = "/" + absolute;
        }
        return host + absolute;
    }

    protected void error(String message) {
        this.error(message, null);
    }

    protected void error(String message, Throwable e) {
        this.getSession().error(this, message, e);
    }
}

