/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Attributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.DeserializerFactory;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.serializer.SerializerFactory;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathAttributes
implements Attributes,
Serializable {
    private static Logger log = Logger.getLogger(PathAttributes.class);
    private long size = -1L;
    private long modified = -1L;
    private long accessed = -1L;
    private long created = -1L;
    private String owner = null;
    private String group = null;
    private int type = 1;
    protected Permission permission = null;

    public PathAttributes() {
    }

    public <T> PathAttributes(T dict) {
        this.init(dict);
    }

    @Override
    public <T> void init(T serialized) {
        Object permissionObj;
        String modifiedObj;
        String sizeObj;
        Deserializer dict = DeserializerFactory.createDeserializer(serialized);
        String typeObj = dict.stringForKey("Type");
        if (typeObj != null) {
            this.type = Integer.parseInt(typeObj);
        }
        if ((sizeObj = dict.stringForKey("Size")) != null) {
            this.size = Long.parseLong(sizeObj);
        }
        if ((modifiedObj = dict.stringForKey("Modified")) != null) {
            this.modified = Long.parseLong(modifiedObj);
        }
        if ((permissionObj = dict.objectForKey("Permission")) != null) {
            this.permission = new Permission(permissionObj);
        }
    }

    @Override
    public <T> T getAsDictionary() {
        Serializer dict = SerializerFactory.createSerializer();
        dict.setStringForKey(String.valueOf(this.type), "Type");
        if (this.size != -1L) {
            dict.setStringForKey(String.valueOf(this.size), "Size");
        }
        if (this.modified != -1L) {
            dict.setStringForKey(String.valueOf(this.modified), "Modified");
        }
        if (null != this.permission) {
            dict.setObjectForKey(this.permission, "Permission");
        }
        return dict.getSerialized();
    }

    @Override
    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getModificationDate() {
        return this.modified;
    }

    @Override
    public void setModificationDate(long millis) {
        this.modified = millis;
    }

    @Override
    public long getCreationDate() {
        return this.created;
    }

    @Override
    public void setCreationDate(long millis) {
        this.created = millis;
    }

    @Override
    public long getAccessedDate() {
        return this.accessed;
    }

    @Override
    public void setAccessedDate(long millis) {
        this.accessed = millis;
    }

    @Override
    public void setPermission(Permission p) {
        this.permission = p;
    }

    @Override
    public Permission getPermission() {
        return this.permission;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isVolume() {
        return (this.type & 8) == 8;
    }

    @Override
    public boolean isDirectory() {
        return (this.type & 2) == 2 || this.isVolume();
    }

    @Override
    public boolean isFile() {
        return (this.type & 1) == 1;
    }

    @Override
    public boolean isSymbolicLink() {
        return (this.type & 4) == 4;
    }

    @Override
    public void setOwner(String o) {
        this.owner = o;
    }

    @Override
    public String getOwner() {
        if (null == this.owner) {
            return Locale.localizedString("Unknown");
        }
        return this.owner;
    }

    @Override
    public void setGroup(String g) {
        this.group = g;
    }

    @Override
    public String getGroup() {
        if (null == this.group) {
            return Locale.localizedString("Unknown");
        }
        return this.group;
    }
}

