/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PathFactory<S extends Session> {
    private static Map<Protocol, PathFactory> factories = new HashMap<Protocol, PathFactory>();

    protected abstract Path create(S var1, String var2, int var3);

    protected abstract Path create(S var1, String var2, String var3, int var4);

    protected abstract Path create(S var1, String var2, Local var3);

    protected abstract <T> Path create(S var1, T var2);

    public static void addFactory(Protocol protocol, PathFactory f) {
        factories.put(protocol, f);
    }

    public static Path createPath(Session session, String parent, String name, int type) {
        PathFactory.loadClass(session.getHost().getProtocol());
        return factories.get(session.getHost().getProtocol()).create(session, parent, name, type);
    }

    public static Path createPath(Session session, String path, int type) {
        PathFactory.loadClass(session.getHost().getProtocol());
        return factories.get(session.getHost().getProtocol()).create(session, path, type);
    }

    public static Path createPath(Session session, String parent, Local file) {
        PathFactory.loadClass(session.getHost().getProtocol());
        return factories.get(session.getHost().getProtocol()).create(session, parent, file);
    }

    public static <T> Path createPath(Session session, T dict) {
        PathFactory.loadClass(session.getHost().getProtocol());
        return factories.get(session.getHost().getProtocol()).create(session, dict);
    }

    private static void loadClass(Protocol protocol) {
        if (!factories.containsKey(protocol)) {
            try {
                Class.forName("ch.cyberduck.core." + protocol.getIdentifier() + "." + protocol.getIdentifier().toUpperCase() + "Path");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("No class for type: " + protocol);
            }
            if (!factories.containsKey(protocol)) {
                throw new RuntimeException("No class for type: " + protocol);
            }
        }
    }
}

