/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.RendezvousListener;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.cocoa.foundation.NSAutoreleasePool;
import com.apple.dnssd.BrowseListener;
import com.apple.dnssd.DNSSD;
import com.apple.dnssd.DNSSDException;
import com.apple.dnssd.DNSSDService;
import com.apple.dnssd.ResolveListener;
import com.apple.dnssd.TXTRecord;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Rendezvous
implements BrowseListener,
ResolveListener {
    private static Logger log = Logger.getLogger(Rendezvous.class);
    private static final String SERVICE_TYPE_SFTP = "_sftp._tcp.";
    private static final String SERVICE_TYPE_SSH = "_ssh._tcp.";
    private static final String SERVICE_TYPE_FTP = "_ftp._tcp.";
    private static final String SERVICE_TYPE_WEBDAV = "_webdav._tcp";
    private static final String[] serviceTypes = new String[]{"_sftp._tcp.", "_ssh._tcp.", "_ftp._tcp.", "_webdav._tcp"};
    private Map<String, Host> services;
    private Map<String, DNSSDService> browsers;
    private static Rendezvous instance = null;
    private static final Object lock = new Object();
    private Set<RendezvousListener> listeners = Collections.synchronizedSet(new HashSet());
    private RendezvousListener notifier = new RendezvousListener(){

        public void serviceResolved(String servicename, String hostname) {
            RendezvousListener[] l;
            log.info((Object)("Service resolved:" + servicename));
            for (RendezvousListener listener : l = Rendezvous.this.listeners.toArray(new RendezvousListener[Rendezvous.this.listeners.size()])) {
                listener.serviceResolved(servicename, hostname);
            }
        }

        public void serviceLost(String servicename) {
            RendezvousListener[] l;
            log.info((Object)("Service lost:" + servicename));
            for (RendezvousListener listener : l = Rendezvous.this.listeners.toArray(new RendezvousListener[Rendezvous.this.listeners.size()])) {
                listener.serviceLost(servicename);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rendezvous instance() {
        Object object = lock;
        synchronized (object) {
            if (null == instance) {
                instance = new Rendezvous();
            }
        }
        return instance;
    }

    private Rendezvous() {
        log.debug((Object)"Rendezvous");
        this.services = Collections.synchronizedMap(new HashMap());
        this.browsers = Collections.synchronizedMap(new HashMap());
    }

    public void init() {
        log.debug((Object)"init");
        try {
            for (String protocol : serviceTypes) {
                log.info((Object)("Adding Rendezvous service listener for " + protocol));
                this.browsers.put(protocol, DNSSD.browse((String)protocol, (BrowseListener)this));
            }
        }
        catch (DNSSDException e) {
            log.error((Object)e.getMessage());
            this.quit();
        }
    }

    public void quit() {
        for (String protocol : serviceTypes) {
            log.info((Object)("Removing Rendezvous service listener for " + protocol));
            DNSSDService service = this.browsers.get(protocol);
            if (null == service) continue;
            service.stop();
        }
    }

    public void addListener(RendezvousListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RendezvousListener listener) {
        this.listeners.remove(listener);
    }

    public Host getServiceWithIdentifier(String identifier) {
        log.debug((Object)("getService:" + identifier));
        return this.services.get(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host getServiceWithDisplayedName(String displayedName) {
        Rendezvous rendezvous = this;
        synchronized (rendezvous) {
            for (Host h : this.services.values()) {
                if (!h.getNickname().equals(displayedName)) continue;
                return h;
            }
        }
        log.warn((Object)("No identifier for displayed name:" + displayedName));
        return null;
    }

    public int numberOfServices() {
        return this.services.size();
    }

    public Host getService(int index) {
        return this.services.values().toArray(new Host[this.services.size()])[index];
    }

    public String getDisplayedName(int index) {
        if (index < this.numberOfServices()) {
            return this.services.values().toArray(new Host[this.services.size()])[index].getNickname();
        }
        return Locale.localizedString("Unknown");
    }

    public String getDisplayedName(String identifier) {
        Host host = this.services.get(identifier);
        if (null == host) {
            return Locale.localizedString("Unknown");
        }
        return host.getNickname();
    }

    public void serviceFound(DNSSDService browser, int flags, int ifIndex, String servicename, String regType, String domain) {
        log.debug((Object)("serviceFound:" + servicename));
        try {
            DNSSD.resolve((int)flags, (int)ifIndex, (String)servicename, (String)regType, (String)domain, (ResolveListener)this);
        }
        catch (DNSSDException e) {
            log.error((Object)e.getMessage());
        }
    }

    public void serviceLost(DNSSDService browser, int flags, int ifIndex, String serviceName, String regType, String domain) {
        log.debug((Object)("serviceLost:" + serviceName));
        try {
            String identifier = DNSSD.constructFullName((String)serviceName, (String)regType, (String)domain);
            if (null == this.services.remove(identifier)) {
                return;
            }
            this.notifier.serviceLost(identifier);
        }
        catch (DNSSDException e) {
            log.error((Object)e.getMessage());
        }
    }

    public void operationFailed(DNSSDService resolver, int errorCode) {
        log.warn((Object)("operationFailed:" + errorCode));
        resolver.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceResolved(DNSSDService resolver, int flags, int ifIndex, String fullname, String hostname, int port, TXTRecord txtRecord) {
        log.debug((Object)("serviceResolved:" + hostname));
        NSAutoreleasePool pool = NSAutoreleasePool.push();
        try {
            Host host = new Host(this.getProtocol(fullname, port), hostname, port);
            host.getCredentials().setUsername(null);
            if (null == this.services.put(fullname, host)) {
                this.notifier.serviceResolved(fullname, hostname);
            }
        }
        finally {
            resolver.stop();
            pool.drain();
        }
    }

    public Protocol getProtocol(String serviceType, int port) {
        if (serviceType.contains(SERVICE_TYPE_SFTP) || serviceType.contains(SERVICE_TYPE_SSH)) {
            return Protocol.SFTP;
        }
        if (serviceType.contains(SERVICE_TYPE_FTP)) {
            return Protocol.FTP;
        }
        if (serviceType.contains(SERVICE_TYPE_WEBDAV)) {
            if (Protocol.WEBDAV_SSL.getDefaultPort() == port) {
                return Protocol.WEBDAV_SSL;
            }
            return Protocol.WEBDAV;
        }
        return Protocol.getDefaultProtocol(port);
    }
}

