/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import java.util.HashMap;
import java.util.Map;

public abstract class SessionFactory {
    private static Map<Protocol, SessionFactory> factories = new HashMap<Protocol, SessionFactory>();

    protected abstract Session create(Host var1);

    public static void addFactory(Protocol protocol, SessionFactory f) {
        factories.put(protocol, f);
    }

    public static Session createSession(Host h) {
        Protocol protocol = h.getProtocol();
        if (!factories.containsKey(protocol)) {
            try {
                Class.forName("ch.cyberduck.core." + protocol.getIdentifier() + "." + protocol.getIdentifier().toUpperCase() + "Session");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("No class for type: " + protocol);
            }
            if (!factories.containsKey(protocol)) {
                throw new RuntimeException("No class for type: " + protocol);
            }
        }
        return factories.get(protocol).create(h);
    }
}

