/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.serializer.TransferReaderFactory;
import ch.cyberduck.core.serializer.TransferWriterFactory;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferCollection
extends Collection<Transfer> {
    private static Logger log = Logger.getLogger(TransferCollection.class);
    private static TransferCollection instance;
    private static final Object lock;
    private static final Local QUEUE_FILE;

    private TransferCollection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransferCollection instance() {
        Object object = lock;
        synchronized (object) {
            if (null == instance) {
                instance = new TransferCollection();
            }
            return instance;
        }
    }

    @Override
    public synchronized boolean add(Transfer o) {
        boolean r = super.add(o);
        this.save();
        return r;
    }

    @Override
    public synchronized void add(int row, Transfer o) {
        super.add(row, o);
        this.save();
    }

    @Override
    public synchronized Transfer remove(int row) {
        return (Transfer)super.remove(row);
    }

    public void save() {
        this.save(QUEUE_FILE);
    }

    private synchronized void save(Local f) {
        log.debug((Object)"save");
        if (Preferences.instance().getBoolean("queue.save")) {
            TransferWriterFactory.instance().write((Transfer)((Object)this), f);
        }
    }

    public void load() {
        this.load(QUEUE_FILE);
    }

    private synchronized void load(Local f) {
        log.debug((Object)"load");
        if (f.exists()) {
            log.info((Object)("Found Queue file: " + f.toString()));
            super.addAll(TransferReaderFactory.instance().readCollection(f));
        }
    }

    public synchronized int numberOfRunningTransfers() {
        int running = 0;
        for (Transfer t : this) {
            if (null == t || !t.isRunning()) continue;
            ++running;
        }
        log.debug((Object)("numberOfRunningTransfers:" + running));
        return running;
    }

    public synchronized int numberOfQueuedTransfers() {
        int queued = 0;
        for (Transfer t : this) {
            if (null == t || !t.isQueued()) continue;
            ++queued;
        }
        log.debug((Object)("numberOfQueuedTransfers:" + queued));
        return queued;
    }

    static {
        lock = new Object();
        QUEUE_FILE = LocalFactory.createLocal(Preferences.instance().getProperty("application.support.path"), "Queue.plist");
        QUEUE_FILE.getParent().mkdir();
    }
}

