/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AbstractStreamListener;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.ui.growl.Growl;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadTransfer
extends Transfer {
    private final PathFilter<Local> childFilter = new PathFilter<Local>(){

        @Override
        public boolean accept(Local child) {
            try {
                if (Preferences.instance().getBoolean("queue.upload.skip.enable") && Pattern.compile(Preferences.instance().getProperty("queue.upload.skip.regex")).matcher(child.getName()).matches()) {
                    return false;
                }
            }
            catch (PatternSyntaxException e) {
                Transfer.log.warn((Object)e.getMessage());
            }
            return true;
        }
    };
    private final Transfer.TransferFilter ACTION_OVERWRITE = new UploadTransferFilter(){

        public boolean accept(Path p) {
            if (super.accept(p)) {
                if (p.attributes.isDirectory()) {
                    return !p.exists();
                }
                return true;
            }
            return false;
        }

        public void prepare(Path p) {
            if (p.attributes.isFile()) {
                p.getStatus().setResume(false);
            }
            super.prepare(p);
        }
    };
    private final Transfer.TransferFilter ACTION_RESUME = new UploadTransferFilter(){

        public boolean accept(Path p) {
            if (super.accept(p)) {
                if (p.getStatus().isComplete() || p.getLocal().attributes.getSize() == p.attributes.getSize()) {
                    p.getStatus().setComplete(true);
                    return false;
                }
                if (p.attributes.isDirectory()) {
                    return !p.exists();
                }
                return true;
            }
            return false;
        }

        public void prepare(Path p) {
            if (p.exists()) {
                if (p.attributes.getSize() == -1L) {
                    p.readSize();
                }
                if (p.attributes.getModificationDate() == -1L && Preferences.instance().getBoolean("queue.upload.preserveDate")) {
                    p.readTimestamp();
                }
                if (p.attributes.getPermission() == null && Preferences.instance().getBoolean("queue.upload.changePermissions")) {
                    p.readPermission();
                }
            }
            if (p.attributes.isFile()) {
                boolean resume = p.exists() && p.attributes.getSize() > 0L;
                p.getStatus().setResume(resume);
                if (p.getStatus().isResume()) {
                    p.getStatus().setCurrent(p.attributes.getSize());
                }
            }
            super.prepare(p);
        }
    };
    private final Transfer.TransferFilter ACTION_RENAME = new UploadTransferFilter(){

        public boolean accept(Path p) {
            return super.accept(p);
        }

        public void prepare(Path p) {
            if (p.exists()) {
                String parent = p.getParent().getAbsolute();
                String filename = p.getName();
                int no = 0;
                while (p.exists()) {
                    String proposal = FilenameUtils.getBaseName((String)filename) + "-" + ++no;
                    if (StringUtils.isNotBlank((String)FilenameUtils.getExtension((String)filename))) {
                        proposal = proposal + "." + FilenameUtils.getExtension((String)filename);
                    }
                    p.setPath(parent, proposal);
                }
                Transfer.log.info((Object)("Changed local name to:" + p.getName()));
            }
            if (p.attributes.isFile()) {
                p.getStatus().setResume(false);
            }
            super.prepare(p);
        }
    };
    private final Transfer.TransferFilter ACTION_SKIP = new UploadTransferFilter(){

        public boolean accept(Path p) {
            return super.accept(p) && !p.exists();
        }
    };

    public UploadTransfer(Path root) {
        super(root);
    }

    public UploadTransfer(List<Path> roots) {
        super(roots);
    }

    public <T> UploadTransfer(T dict, Session s) {
        super(dict, s);
    }

    @Override
    public <T> T getAsDictionary() {
        Serializer dict = super.getSerializer();
        dict.setStringForKey(String.valueOf(1), "Kind");
        return dict.getSerialized();
    }

    @Override
    protected void init() {
        log.debug((Object)"init");
        this.bandwidth = new BandwidthThrottle(Preferences.instance().getFloat("queue.upload.bandwidth.bytes"));
    }

    @Override
    protected void setRoots(List<Path> uploads) {
        Collection<Path> normalized = new Collection<Path>();
        for (Path upload : uploads) {
            boolean duplicate = false;
            Iterator iter = normalized.iterator();
            while (iter.hasNext()) {
                Path n = (Path)iter.next();
                if (upload.getLocal().isChild(n.getLocal())) {
                    duplicate = true;
                    break;
                }
                if (n.getLocal().isChild(upload.getLocal())) {
                    iter.remove();
                }
                if (!upload.getName().equals(n.getName())) continue;
                String parent = upload.getParent().getAbsolute();
                String filename = upload.getName();
                int no = 0;
                int index = filename.lastIndexOf(".");
                String proposal = index != -1 && index != 0 ? filename.substring(0, index) + "-" + no + filename.substring(index) : filename + "-" + ++no;
                upload.setPath(parent, proposal);
                log.info((Object)("Changed name to:" + upload.getName()));
            }
            if (duplicate) continue;
            normalized.add(upload);
        }
        super.setRoots(normalized);
    }

    @Override
    public AttributedList<Path> childs(Path parent) {
        if (!parent.getLocal().exists()) {
            return AttributedList.emptyList();
        }
        AttributedList<Path> childs = new AttributedList<Path>();
        Cache<Path> cache = this.getSession().cache();
        for (Local local : parent.getLocal().childs(this.childFilter)) {
            Local download = LocalFactory.createLocal(((AbstractPath)local).getAbsolute());
            Path upload = PathFactory.createPath(parent.getSession(), parent.getAbsolute(), download);
            if (upload.exists()) {
                upload = cache.lookup(upload.getReference());
                upload.setLocal(download);
            }
            upload.getStatus().setSkipped(parent.getStatus().isSkipped());
            childs.add(upload);
        }
        return childs;
    }

    @Override
    public boolean isResumable() {
        if (this.getSession() instanceof S3Session) {
            return false;
        }
        return super.isResumable();
    }

    @Override
    public Transfer.TransferFilter filter(TransferAction action) {
        log.debug((Object)("filter:" + action));
        if (action.equals(TransferAction.ACTION_OVERWRITE)) {
            return this.ACTION_OVERWRITE;
        }
        if (action.equals(TransferAction.ACTION_RESUME)) {
            return this.ACTION_RESUME;
        }
        if (action.equals(TransferAction.ACTION_RENAME)) {
            return this.ACTION_RENAME;
        }
        if (action.equals(TransferAction.ACTION_SKIP)) {
            return this.ACTION_SKIP;
        }
        if (action.equals(TransferAction.ACTION_CALLBACK)) {
            for (Path root : this.getRoots()) {
                if (!root.exists() || root.getLocal().attributes.isDirectory() && 0 == this.childs(root).size()) continue;
                TransferAction result = this.prompt.prompt();
                return this.filter(result);
            }
            return this.filter(TransferAction.ACTION_OVERWRITE);
        }
        return super.filter(action);
    }

    @Override
    public TransferAction action(boolean resumeRequested, boolean reloadRequested) {
        log.debug((Object)("action:" + resumeRequested + "," + reloadRequested));
        if (resumeRequested) {
            return TransferAction.ACTION_RESUME;
        }
        if (reloadRequested) {
            return TransferAction.forName(Preferences.instance().getProperty("queue.upload.reload.fileExists"));
        }
        return TransferAction.forName(Preferences.instance().getProperty("queue.upload.fileExists"));
    }

    @Override
    protected void _transferImpl(Path p) {
        Permission permission = null;
        if (Preferences.instance().getBoolean("queue.upload.changePermissions") && null == (permission = p.attributes.getPermission())) {
            if (Preferences.instance().getBoolean("queue.upload.permissions.useDefault")) {
                if (p.attributes.isFile()) {
                    permission = new Permission(Preferences.instance().getInteger("queue.upload.permissions.file.default"));
                }
                if (p.attributes.isDirectory()) {
                    permission = new Permission(Preferences.instance().getInteger("queue.upload.permissions.folder.default"));
                }
            } else {
                permission = p.getLocal().attributes.getPermission();
            }
        }
        p.upload(this.bandwidth, new AbstractStreamListener(){

            public void bytesSent(long bytes) {
                UploadTransfer.this.transferred += (double)bytes;
            }
        }, permission);
    }

    @Override
    protected void fireTransferDidEnd() {
        if (this.isReset() && this.isComplete() && !this.isCanceled() && this.getTransferred() != 0.0) {
            Growl.instance().notify("Upload complete", this.getName());
        }
        super.fireTransferDidEnd();
    }

    private abstract class UploadTransferFilter
    extends Transfer.TransferFilter {
        private UploadTransferFilter() {
        }

        public boolean accept(Path file) {
            return file.getLocal().exists();
        }

        public void prepare(Path p) {
            if (p.attributes.isFile()) {
                UploadTransfer.this.size += (double)p.getLocal().attributes.getSize();
                if (p.getStatus().isResume()) {
                    UploadTransfer.this.transferred += (double)p.attributes.getSize();
                }
            }
            if (p.attributes.isDirectory() && !p.exists()) {
                p.cache().put(p, new AttributedList());
            }
        }
    }
}

