/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.IOResumeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.webdav.lib.WebdavResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAVPath
extends Path {
    private static Logger log = Logger.getLogger(DAVPath.class);
    private final DAVSession session;

    protected DAVPath(DAVSession s, String parent, String name, int type) {
        super(parent, name, type);
        this.session = s;
    }

    protected DAVPath(DAVSession s, String path, int type) {
        super(path, type);
        this.session = s;
    }

    protected DAVPath(DAVSession s, String parent, Local file) {
        super(parent, file);
        this.session = s;
    }

    protected <T> DAVPath(DAVSession s, T dict) {
        super(dict);
        this.session = s;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void readSize() {
        try {
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Getting size of {0}", "Status"), this.getName()));
            this.session.DAV.setPath(this.attributes.isDirectory() ? this.getAbsolute() + "/" : this.getAbsolute());
            this.session.DAV.setProperties(3, 1);
            this.attributes.setSize(this.session.DAV.getGetContentLength());
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    @Override
    public void readTimestamp() {
        try {
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Getting timestamp of {0}", "Status"), this.getName()));
            this.session.DAV.setPath(this.attributes.isDirectory() ? this.getAbsolute() + "/" : this.getAbsolute());
            this.session.DAV.setProperties(3, 1);
            this.attributes.setModificationDate(this.session.DAV.getGetLastModified());
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    @Override
    public void readPermission() {
    }

    @Override
    public void delete() {
        block4: {
            log.debug((Object)("delete:" + this.toString()));
            try {
                this.session.check();
                this.session.message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                if (!this.session.DAV.deleteMethod(this.getAbsolute())) {
                    throw new IOException(this.session.DAV.getStatusMessage());
                }
            }
            catch (IOException e) {
                if (this.attributes.isFile()) {
                    this.error("Cannot delete file", e);
                }
                if (!this.attributes.isDirectory()) break block4;
                this.error("Cannot delete folder", e);
            }
        }
    }

    public AttributedList<Path> list() {
        AttributedList<Path> childs = new AttributedList<Path>();
        try {
            WebdavResource[] resources;
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Listing directory {0}", "Status"), this.getName()));
            this.session.setWorkdir(this);
            this.session.DAV.setContentType("text/xml");
            for (WebdavResource resource : resources = this.session.DAV.listWebdavResources()) {
                boolean collection = false;
                if (null != resource.getResourceType()) {
                    collection = resource.getResourceType().isCollection();
                }
                Path p = PathFactory.createPath((Session)this.session, resource.getPath(), collection ? 2 : 1);
                p.setParent(this);
                p.attributes.setOwner(resource.getOwner());
                if (resource.getGetLastModified() > 0L) {
                    p.attributes.setModificationDate(resource.getGetLastModified());
                }
                if (resource.getCreationDate() > 0L) {
                    p.attributes.setCreationDate(resource.getCreationDate());
                }
                p.attributes.setSize(resource.getGetContentLength());
                childs.add(p);
            }
        }
        catch (IOException e) {
            childs.attributes().setReadable(false);
            this.error("Listing directory failed", e);
        }
        return childs;
    }

    @Override
    public void mkdir(boolean recursive) {
        log.debug((Object)("mkdir:" + this.getName()));
        try {
            if (recursive && !this.getParent().exists()) {
                this.getParent().mkdir(recursive);
            }
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Making directory {0}", "Status"), this.getName()));
            this.session.DAV.setContentType("text/xml");
            if (!this.session.DAV.mkcolMethod(this.getAbsolute())) {
                throw new IOException(this.session.DAV.getStatusMessage());
            }
        }
        catch (IOException e) {
            this.error("Cannot create folder", e);
        }
    }

    @Override
    public void writePermissions(Permission perm, boolean recursive) {
    }

    @Override
    public void rename(AbstractPath renamed) {
        block4: {
            log.debug((Object)("rename:" + renamed));
            try {
                this.session.check();
                this.session.message(MessageFormat.format(Locale.localizedString("Renaming {0} to {1}", "Status"), this.getName(), renamed.getName()));
                if (!this.session.DAV.moveMethod(this.getAbsolute(), renamed.getAbsolute())) {
                    throw new IOException(this.session.DAV.getStatusMessage());
                }
                this.setPath(renamed.getAbsolute());
            }
            catch (IOException e) {
                if (this.attributes.isFile()) {
                    this.error("Cannot rename file", e);
                }
                if (!this.attributes.isDirectory()) break block4;
                this.error("Cannot rename folder", e);
            }
        }
    }

    @Override
    public void copy(AbstractPath copy) {
        block4: {
            try {
                this.session.check();
                this.session.message(MessageFormat.format(Locale.localizedString("Copying {0} to {1}", "Status"), this.getName(), copy));
                if (!this.session.DAV.copyMethod(this.getAbsolute(), copy.getAbsolute())) {
                    throw new IOException(this.session.DAV.getStatusMessage());
                }
            }
            catch (IOException e) {
                if (this.attributes.isFile()) {
                    this.error("Cannot copy file", e);
                }
                if (!this.attributes.isDirectory()) break block4;
                this.error("Cannot copy folder", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        block11: {
            if (this.attributes.isFile()) {
                Local.OutputStream out = null;
                InputStream in = null;
                try {
                    if (check) {
                        this.session.check();
                    }
                    if (this.getStatus().isResume()) {
                        this.session.DAV.addRequestHeader("Range", "bytes=" + this.getStatus().getCurrent() + "-");
                    }
                    this.session.DAV.addRequestHeader("Accept-Encoding", "gzip");
                    in = this.session.DAV.getMethodData(this.getAbsolute());
                    if (null == in) {
                        throw new IOException("Unable opening data stream");
                    }
                    if (!this.session.DAV.isResume()) {
                        this.getStatus().setCurrent(0L);
                    }
                    out = new Local.OutputStream(this.getLocal(), this.getStatus().isResume());
                    this.download(in, out, throttle, listener);
                    IOUtils.closeQuietly((InputStream)in);
                }
                catch (IOException e) {
                    this.error("Download failed", e);
                    break block11;
                }
                finally {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        if (this.attributes.isDirectory()) {
            this.getLocal().mkdir(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(BandwidthThrottle throttle, StreamListener listener, Permission p, boolean check) {
        try {
            if (check) {
                this.session.check();
            }
            if (this.attributes.isFile()) {
                this.getSession().message(MessageFormat.format(Locale.localizedString("Uploading {0}", "Status"), this.getName()));
                Local.InputStream in = new Local.InputStream(this.getLocal());
                try {
                    Status stat = this.getStatus();
                    if (stat.isResume()) {
                        this.session.DAV.addRequestHeader("Content-Range", "bytes " + stat.getCurrent() + "-" + (this.getLocal().attributes.getSize() - 1L) + "/" + this.getLocal().attributes.getSize());
                        long skipped = ((InputStream)((Object)in)).skip(stat.getCurrent());
                        log.info((Object)("Skipping " + skipped + " bytes"));
                        if (skipped < stat.getCurrent()) {
                            throw new IOResumeException("Skipped " + skipped + " bytes instead of " + stat.getCurrent());
                        }
                    }
                    if (!this.session.DAV.putMethod(this.getAbsolute(), (RequestEntity)new InputStreamRequestEntity((InputStream)((Object)in), this.getLocal().attributes.getSize() - stat.getCurrent(), this.getLocal().getMimeType(), (InputStream)((Object)in), stat, throttle, listener){
                        boolean requested;
                        final /* synthetic */ InputStream val$in;
                        final /* synthetic */ Status val$stat;
                        final /* synthetic */ BandwidthThrottle val$throttle;
                        final /* synthetic */ StreamListener val$listener;
                        {
                            this.val$in = inputStream;
                            this.val$stat = status;
                            this.val$throttle = bandwidthThrottle;
                            this.val$listener = streamListener;
                            super(x0, x1, x2);
                            this.requested = false;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void writeRequest(OutputStream out) throws IOException {
                            if (this.requested) {
                                this.val$in.reset();
                                this.val$stat.reset();
                                this.val$stat.setCurrent(0L);
                            }
                            try {
                                DAVPath.this.upload(out, this.val$in, this.val$throttle, this.val$listener);
                            }
                            finally {
                                this.requested = true;
                            }
                        }

                        public boolean isRepeatable() {
                            return true;
                        }
                    })) {
                        throw new IOException(this.session.DAV.getStatusMessage());
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)((Object)in));
                }
            }
            if (this.attributes.isDirectory()) {
                this.mkdir();
            }
        }
        catch (IOException e) {
            this.error("Upload failed", e);
        }
    }

    @Override
    public String toHttpURL() {
        return this.toURL();
    }

    static {
        PathFactory.addFactory(Protocol.WEBDAV, new Factory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<DAVSession> {
        private Factory() {
        }

        @Override
        protected Path create(DAVSession session, String path, int type) {
            return new DAVPath(session, path, type);
        }

        @Override
        protected Path create(DAVSession session, String parent, String name, int type) {
            return new DAVPath(session, parent, name, type);
        }

        @Override
        protected Path create(DAVSession session, String path, Local file) {
            return new DAVPath(session, path, file);
        }

        @Override
        protected <T> Path create(DAVSession session, T dict) {
            return new DAVPath(session, dict);
        }
    }
}

