/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.util.WebdavStatus;

public class DAVResource
extends WebdavResource {
    private static Logger log = Logger.getLogger(DAVResource.class);
    private boolean resume;

    public DAVResource(String url) throws IOException {
        super(url);
    }

    protected synchronized boolean isTheClient() throws URIException {
        HostConfiguration hostConfig = this.client.getHostConfiguration();
        this.client.getState().setCredentials(null, this.httpURL.getHost(), this.hostCredentials);
        return this.httpURL.getHost().equalsIgnoreCase(hostConfig.getHost()) && this.httpURL.getPort() == hostConfig.getProtocol().resolvePort(hostConfig.getPort());
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    protected void generateAdditionalHeaders(HttpMethod method) {
        for (Object o : this.headers.keySet()) {
            String header = (String)o;
            method.setRequestHeader(header, (String)this.headers.get(header));
        }
    }

    public boolean isResume() {
        return this.resume;
    }

    protected void setStatusCode(int statusCode, String message) {
        this.latestStatusCode = statusCode;
        String statusText = WebdavStatus.getStatusText((int)statusCode);
        StringBuffer text = new StringBuffer();
        text.append(statusCode).append(" ").append(StringUtils.isNotBlank((String)statusText) ? statusText : "").append(" ").append(StringUtils.isNotBlank((String)message) ? message : "");
        this.latestStatusMessage = text.toString();
    }

    public InputStream getMethodData(String path) throws IOException {
        this.setClient();
        GetMethod method = new GetMethod(URIUtil.encodePathQuery((String)path));
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader((HttpMethod)method);
        this.generateAdditionalHeaders((HttpMethod)method);
        int statusCode = this.client.executeMethod((HttpMethod)method);
        Header contentRange = method.getResponseHeader("Content-Range");
        this.resume = contentRange != null;
        this.setStatusCode(statusCode, method.getStatusText());
        if (this.isHttpSuccess(statusCode)) {
            boolean zipped;
            Header contentEncoding = method.getResponseHeader("Content-Encoding");
            boolean bl = zipped = contentEncoding != null && "gzip".equalsIgnoreCase(contentEncoding.getValue());
            if (zipped) {
                return new GZIPInputStream(method.getResponseBodyAsStream());
            }
            return method.getResponseBodyAsStream();
        }
        throw new IOException("Couldn't get file");
    }

    public boolean putMethod(String path, RequestEntity requestEntity) throws IOException {
        this.setClient();
        PutMethod method = new PutMethod(URIUtil.encodePathQuery((String)path));
        method.setUseExpectHeader(true);
        this.generateIfHeader((HttpMethod)method);
        method.setRequestEntity(requestEntity);
        this.generateTransactionHeader((HttpMethod)method);
        this.generateAdditionalHeaders((HttpMethod)method);
        int statusCode = this.client.executeMethod((HttpMethod)method);
        this.setStatusCode(statusCode, method.getStatusText());
        return this.isHttpSuccess(statusCode);
    }

    private boolean isHttpSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    public static boolean verifyEscaped(char[] original) {
        for (int i = 0; i < original.length; ++i) {
            char c = original[i];
            if (c > '\u0080') {
                return false;
            }
            if (c != '%' || Character.digit(original[++i], 16) != -1 && Character.digit(original[++i], 16) != -1) continue;
            return false;
        }
        return true;
    }

    protected void setWebdavProperties(final Enumeration responses) throws HttpException, IOException {
        super.setWebdavProperties(new Enumeration(){

            public boolean hasMoreElements() {
                return responses.hasMoreElements();
            }

            public Object nextElement() {
                final ResponseEntity response = (ResponseEntity)responses.nextElement();
                return new ResponseEntity(){

                    public int getStatusCode() {
                        return response.getStatusCode();
                    }

                    public Enumeration getProperties() {
                        return response.getProperties();
                    }

                    public Enumeration getHistories() {
                        return response.getHistories();
                    }

                    public Enumeration getWorkspaces() {
                        return response.getWorkspaces();
                    }

                    public String getHref() {
                        if (StringUtils.isNotBlank((String)response.getHref())) {
                            String escaped = StringUtils.replace((String)response.getHref(), (String)" ", (String)"%20");
                            if (!DAVResource.verifyEscaped(escaped.toCharArray())) {
                                try {
                                    return URIUtil.encodePath((String)response.getHref());
                                }
                                catch (URIException e) {
                                    log.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                            return escaped;
                        }
                        return response.getHref();
                    }
                };
            }
        });
    }
}

