/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.io.BandwidthThrottle;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class ThrottledInputStream
extends InputStream {
    private static Logger log = Logger.getLogger(ThrottledInputStream.class);
    private InputStream _delegate;
    private BandwidthThrottle _throttle;

    public ThrottledInputStream(InputStream delegate, BandwidthThrottle throttle) {
        this._delegate = delegate;
        this._throttle = throttle;
    }

    public int read() throws IOException {
        int allow = this._throttle.request(1);
        assert (allow == 1);
        return this._delegate.read();
    }

    public int read(byte[] data, int offset, int totalLength) throws IOException {
        int totalRead = 0;
        while (totalLength > 0) {
            int length = this._throttle.request(totalLength);
            assert (length + offset <= data.length);
            int read = this._delegate.read(data, offset, length);
            if (-1 == read) {
                if (0 != totalRead) break;
                totalRead = -1;
                break;
            }
            totalRead += read;
            totalLength -= read;
            offset += read;
        }
        return totalRead;
    }

    public void close() throws IOException {
        this._delegate.close();
    }
}

