/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Proxy;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.http.HTTPSession;
import ch.cyberduck.core.http.StickyHostConfiguration;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.s3.S3Path;
import ch.cyberduck.core.ssl.AbstractX509TrustManager;
import ch.cyberduck.core.ssl.CustomTrustSSLProtocolSocketFactory;
import ch.cyberduck.core.ssl.IgnoreX509TrustManager;
import ch.cyberduck.core.ssl.KeychainX509TrustManager;
import ch.cyberduck.core.ssl.SSLSession;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.CloudFrontService;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.cloudfront.Distribution;
import org.jets3t.service.model.cloudfront.DistributionConfig;
import org.jets3t.service.model.cloudfront.LoggingStatus;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.ServiceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3Session
extends HTTPSession
implements SSLSession {
    private static Logger log = Logger.getLogger(S3Session.class);
    protected S3Service S3;
    private AbstractX509TrustManager trustManager;
    protected Jets3tProperties configuration = new Jets3tProperties();
    private List<S3Bucket> buckets = new ArrayList<S3Bucket>();
    private CloudFrontService cloudfront;

    @Override
    public AbstractX509TrustManager getTrustManager() {
        if (null == this.trustManager) {
            if (Preferences.instance().getBoolean("s3.tls.acceptAnyCertificate")) {
                this.setTrustManager(new IgnoreX509TrustManager());
            } else {
                this.setTrustManager(new KeychainX509TrustManager(this.host.getHostname()));
            }
        }
        return this.trustManager;
    }

    @Override
    public void setTrustManager(AbstractX509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    protected S3Session(Host h) {
        super(h);
    }

    protected void configure() {
        this.configuration.setProperty("s3service.https-only", String.valueOf(this.host.getProtocol().isSecure()));
        this.configuration.setProperty("s3service.internal-error-retry-max", String.valueOf(0));
        this.configuration.setProperty("s3service.max-thread-count", String.valueOf(1));
        this.configuration.setProperty("httpclient.proxy-autodetect", "false");
        if (this.host.getProtocol().isSecure()) {
            if (Proxy.isHTTPSProxyEnabled()) {
                this.configuration.setProperty("httpclient.proxy-host", Proxy.getHTTPSProxyHost());
                this.configuration.setProperty("httpclient.proxy-port", String.valueOf(Proxy.getHTTPSProxyPort()));
            }
        } else if (Proxy.isHTTPProxyEnabled()) {
            this.configuration.setProperty("httpclient.proxy-host", Proxy.getHTTPProxyHost());
            this.configuration.setProperty("httpclient.proxy-port", String.valueOf(Proxy.getHTTPProxyPort()));
        }
        this.configuration.setProperty("httpclient.connection-timeout-ms", String.valueOf(this.timeout()));
        this.configuration.setProperty("httpclient.socket-timeout-ms", String.valueOf(this.timeout()));
        this.configuration.setProperty("httpclient.useragent", this.getUserAgent());
        this.configuration.setProperty("httpclient.authentication-preemptive", String.valueOf(false));
        this.configuration.setProperty("downloads.restoreLastModifiedDate", Preferences.instance().getProperty("queue.download.preserveDate"));
    }

    protected String getHostnameForBucket(String bucket) {
        return S3Service.generateS3HostnameForBucket((String)bucket, (boolean)this.configuration.getBoolProperty("s3service.disable-dns-buckets", false));
    }

    protected String getBucketForHostname(String hostname) {
        if (hostname.equals(Constants.S3_HOSTNAME)) {
            return null;
        }
        return ServiceUtils.findBucketNameInHostname((String)hostname);
    }

    protected List<S3Bucket> getBuckets(boolean reload) throws IOException, S3ServiceException {
        if (this.buckets.isEmpty() || reload) {
            this.buckets.clear();
            if (this.host.getCredentials().isAnonymousLogin()) {
                String bucketname = this.getBucketForHostname(this.host.getHostname());
                if (null == bucketname && StringUtils.isNotBlank((String)this.host.getDefaultPath())) {
                    bucketname = this.host.getDefaultPath();
                }
                if (null == bucketname) {
                    return this.buckets;
                }
                if (!this.S3.isBucketAccessible(bucketname)) {
                    throw new IOException("Bucket not available: " + bucketname);
                }
                S3Path thirdparty = (S3Path)PathFactory.createPath((Session)this, bucketname, 10);
                this.buckets.add(new S3Bucket(thirdparty.getContainerName()));
            } else {
                this.getTrustManager().setHostname(Constants.S3_HOSTNAME);
                this.buckets.addAll(Arrays.asList(this.S3.listAllBuckets()));
            }
        }
        return this.buckets;
    }

    @Override
    protected void connect() throws IOException, ConnectionCanceledException, LoginCanceledException {
        if (this.isConnected()) {
            return;
        }
        this.fireConnectionWillOpenEvent();
        this.message(MessageFormat.format(Locale.localizedString("Opening {0} connection to {1}", "Status"), this.host.getProtocol().getName(), this.host.getHostname()));
        this.configure();
        this.login();
        this.message(MessageFormat.format(Locale.localizedString("{0} connection opened", "Status"), this.host.getProtocol().getName()));
        this.fireConnectionDidOpenEvent();
    }

    @Override
    protected void login(Credentials credentials) throws IOException {
        StickyHostConfiguration hostconfig = new StickyHostConfiguration();
        if (this.host.getProtocol().isSecure()) {
            hostconfig.setHost(this.host.getHostname(), this.host.getPort(), new org.apache.commons.httpclient.protocol.Protocol(this.host.getProtocol().getScheme(), (ProtocolSocketFactory)new CustomTrustSSLProtocolSocketFactory(this.getTrustManager()), this.host.getPort()));
        } else {
            hostconfig.setHost(this.host.getHostname(), this.host.getPort(), new org.apache.commons.httpclient.protocol.Protocol(this.host.getProtocol().getScheme(), (ProtocolSocketFactory)new DefaultProtocolSocketFactory(), this.host.getPort()));
        }
        this.login(credentials, hostconfig);
    }

    protected void login(Credentials credentials, HostConfiguration hostconfig) throws IOException {
        try {
            this.S3 = new RestS3Service(credentials.isAnonymousLogin() ? null : new AWSCredentials(credentials.getUsername(), credentials.getPassword()), this.getUserAgent(), new CredentialsProvider(){

                public org.apache.commons.httpclient.Credentials getCredentials(AuthScheme authscheme, String hostname, int port, boolean proxy) throws CredentialsNotAvailableException {
                    log.error((Object)("Additional HTTP authentication not supported:" + authscheme.getSchemeName()));
                    throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
                }
            }, this.configuration, hostconfig);
            this.getBuckets(true);
        }
        catch (S3ServiceException e) {
            if (this.isLoginFailure(e)) {
                this.message(Locale.localizedString("Login failed", "Credentials"));
                this.login.fail(this.host, Locale.localizedString("Login with username and password", "Credentials"));
                this.login();
            }
            throw new IOException(e.getS3ErrorMessage());
        }
    }

    private boolean isLoginFailure(S3ServiceException e) {
        if (null == e.getS3ErrorCode()) {
            return false;
        }
        return e.getS3ErrorCode().equals("InvalidAccessKeyId") || e.getS3ErrorCode().equals("SignatureDoesNotMatch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.isConnected()) {
                this.fireConnectionWillCloseEvent();
            }
        }
        finally {
            this.S3 = null;
            this.fireConnectionDidCloseEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        try {
            super.interrupt();
            if (this.isConnected()) {
                this.fireConnectionWillCloseEvent();
            }
        }
        finally {
            this.S3 = null;
            this.fireConnectionDidCloseEvent();
        }
    }

    @Override
    public Path workdir() throws IOException {
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        if (null == this.workdir) {
            this.workdir = PathFactory.createPath((Session)this, "/", 10);
        }
        return this.workdir;
    }

    @Override
    protected void noop() throws IOException {
    }

    @Override
    public void sendCommand(String command) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isConnected() {
        return this.S3 != null;
    }

    public Distribution createDistribution(boolean enabled, String bucket, String[] cnames, LoggingStatus logging) throws CloudFrontServiceException {
        long reference = System.currentTimeMillis();
        return this.createCloudFrontService().createDistribution(this.getHostnameForBucket(bucket), String.valueOf(reference), cnames, new Date(reference).toString(), enabled, logging);
    }

    public void updateDistribution(boolean enabled, Distribution distribution, String[] cnames, LoggingStatus logging) throws CloudFrontServiceException {
        long reference = System.currentTimeMillis();
        this.createCloudFrontService().updateDistributionConfig(distribution.getId(), cnames, new Date(reference).toString(), enabled, logging);
    }

    public Distribution[] listDistributions(String bucket) throws CloudFrontServiceException {
        return this.createCloudFrontService().listDistributions(bucket);
    }

    protected DistributionConfig getDistributionConfig(Distribution distribution) throws CloudFrontServiceException {
        return this.createCloudFrontService().getDistributionConfig(distribution.getId());
    }

    public void deleteDistribution(Distribution distribution) throws CloudFrontServiceException {
        this.createCloudFrontService().deleteDistribution(distribution.getId());
    }

    private CloudFrontService createCloudFrontService() throws CloudFrontServiceException {
        if (null == this.cloudfront) {
            Credentials credentials = this.host.getCredentials();
            StickyHostConfiguration hostconfig = null;
            try {
                hostconfig = new StickyHostConfiguration();
                HttpHost endpoint = new HttpHost(new URI("https://cloudfront.amazonaws.com/", false));
                hostconfig.setHost(endpoint.getHostName(), endpoint.getPort(), new org.apache.commons.httpclient.protocol.Protocol(endpoint.getProtocol().getScheme(), (ProtocolSocketFactory)new CustomTrustSSLProtocolSocketFactory(new KeychainX509TrustManager(endpoint.getHostName())), endpoint.getPort()));
            }
            catch (URIException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            this.cloudfront = new CloudFrontService(new AWSCredentials(credentials.getUsername(), credentials.getPassword()), this.getUserAgent(), null, new Jets3tProperties(), (HostConfiguration)hostconfig);
        }
        return this.cloudfront;
    }

    static {
        SessionFactory.addFactory(Protocol.S3, new Factory());
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new S3Session(h);
        }
    }
}

