/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.ethz.ssh2.sftp.SFTPv3FileHandle;
import java.io.IOException;
import java.io.InputStream;

public class SFTPInputStream
extends InputStream {
    private SFTPv3FileHandle handle;
    private long readOffset = 0L;

    public SFTPInputStream(SFTPv3FileHandle handle) {
        if (null == handle) {
            throw new IllegalArgumentException("Cannot accept null argument!");
        }
        if (null == handle.getClient()) {
            throw new IllegalArgumentException("Cannot accept null client!");
        }
        this.handle = handle;
    }

    public int read(byte[] buffer, int offset, int len) throws IOException {
        int read = this.handle.getClient().read(this.handle, this.readOffset, buffer, offset, len);
        if (read > 0) {
            this.readOffset += (long)read;
        }
        return read;
    }

    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int read = this.handle.getClient().read(this.handle, this.readOffset, buffer, 0, 1);
        if (read > 0) {
            this.readOffset += (long)read;
        }
        return read;
    }

    public long skip(long n) {
        this.readOffset += n;
        return n;
    }

    public void close() throws IOException {
        this.handle.getClient().closeFile(this.handle);
    }
}

