/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.IOResumeException;
import ch.cyberduck.core.sftp.SFTPInputStream;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.sftp.SFTPv3DirectoryEntry;
import ch.ethz.ssh2.sftp.SFTPv3FileAttributes;
import ch.ethz.ssh2.sftp.SFTPv3FileHandle;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFTPPath
extends Path {
    private static Logger log = Logger.getLogger(SFTPPath.class);
    private final SFTPSession session;

    private SFTPPath(SFTPSession s, String parent, String name, int type) {
        super(parent, name, type);
        this.session = s;
    }

    private SFTPPath(SFTPSession s, String path, int type) {
        super(path, type);
        this.session = s;
    }

    private SFTPPath(SFTPSession s, String parent, Local file) {
        super(parent, file);
        this.session = s;
    }

    private <T> SFTPPath(SFTPSession s, T dict) {
        super(dict);
        this.session = s;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public AttributedList<Path> list() {
        AttributedList<Path> childs = new AttributedList<Path>();
        try {
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Listing directory {0}", "Status"), this.getName()));
            Vector children = this.session.sftp().ls(this.getAbsolute());
            for (SFTPv3DirectoryEntry f : children) {
                String perm;
                if (f.filename.equals(".") || f.filename.equals("..")) continue;
                SFTPPath p = new SFTPPath(this.session, this.getAbsolute(), f.filename, f.attributes.isDirectory() ? 2 : 1);
                p.setParent(this);
                if (null != f.attributes.uid) {
                    p.attributes.setOwner(f.attributes.uid.toString());
                }
                if (null != f.attributes.gid) {
                    p.attributes.setGroup(f.attributes.gid.toString());
                }
                if (null != f.attributes.size) {
                    p.attributes.setSize(f.attributes.size);
                }
                if (null != f.attributes.mtime) {
                    p.attributes.setModificationDate(Long.parseLong(f.attributes.mtime.toString()) * 1000L);
                }
                if (null != f.attributes.atime) {
                    p.attributes.setAccessedDate(Long.parseLong(f.attributes.atime.toString()) * 1000L);
                }
                if (f.attributes.isSymlink()) {
                    try {
                        String target = this.session.sftp().readLink(p.getAbsolute());
                        if (!target.startsWith("/")) {
                            target = Path.normalize(this.getAbsolute() + "/" + target);
                        }
                        p.setSymbolicLinkPath(target);
                        SFTPv3FileAttributes attr = this.session.sftp().stat(target);
                        if (attr.isDirectory()) {
                            p.attributes.setType(6);
                        } else if (attr.isRegularFile()) {
                            p.attributes.setType(5);
                        }
                    }
                    catch (IOException e) {
                        log.warn((Object)("Cannot read symbolic link target of " + p.getAbsolute() + ":" + e.getMessage()));
                        p.attributes.setType(5);
                    }
                }
                if (null != (perm = f.attributes.getOctalPermissions())) {
                    p.attributes.setPermission(new Permission(Integer.parseInt(perm.substring(perm.length() - 3))));
                }
                childs.add(p);
            }
        }
        catch (IOException e) {
            childs.attributes().setReadable(false);
            this.error("Listing directory failed", e);
        }
        return childs;
    }

    @Override
    public void mkdir(boolean recursive) {
        log.debug((Object)("mkdir:" + this.getName()));
        try {
            if (recursive && !this.getParent().exists()) {
                this.getParent().mkdir(recursive);
            }
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Making directory {0}", "Status"), this.getName()));
            Permission perm = new Permission(Preferences.instance().getInteger("queue.upload.permissions.folder.default"));
            this.session.sftp().mkdir(this.getAbsolute(), perm.getOctalNumber());
        }
        catch (IOException e) {
            this.error("Cannot create folder", e);
        }
    }

    @Override
    public void rename(AbstractPath renamed) {
        block4: {
            try {
                this.session.check();
                this.session.message(MessageFormat.format(Locale.localizedString("Renaming {0} to {1}", "Status"), this.getName(), renamed));
                if (renamed.exists()) {
                    renamed.delete();
                }
                this.session.sftp().mv(this.getAbsolute(), renamed.getAbsolute());
                this.setPath(renamed.getAbsolute());
            }
            catch (IOException e) {
                if (this.attributes.isFile()) {
                    this.error("Cannot rename file", e);
                }
                if (!this.attributes.isDirectory()) break block4;
                this.error("Cannot rename folder", e);
            }
        }
    }

    @Override
    public void delete() {
        block7: {
            log.debug((Object)("delete:" + this.toString()));
            try {
                this.session.check();
                if (this.attributes.isFile() || this.attributes.isSymbolicLink()) {
                    this.session.message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                    this.session.sftp().rm(this.getAbsolute());
                } else if (this.attributes.isDirectory()) {
                    for (AbstractPath child : this.childs()) {
                        if (!this.session.isConnected()) break;
                        child.delete();
                    }
                    this.session.message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                    this.session.sftp().rmdir(this.getAbsolute());
                }
            }
            catch (IOException e) {
                if (this.attributes.isFile()) {
                    this.error("Cannot delete file", e);
                }
                if (!this.attributes.isDirectory()) break block7;
                this.error("Cannot delete folder", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readSize() {
        if (this.attributes.isFile()) {
            SFTPv3FileHandle handle = null;
            try {
                this.session.check();
                handle = this.session.sftp().openFileRO(this.getAbsolute());
                SFTPv3FileAttributes attr = this.session.sftp().fstat(handle);
                this.session.message(MessageFormat.format(Locale.localizedString("Getting size of {0}", "Status"), this.getName()));
                this.attributes.setSize(attr.size);
                this.session.sftp().closeFile(handle);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
            finally {
                if (handle != null) {
                    try {
                        this.session.sftp().closeFile(handle);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void readTimestamp() {
        if (!this.attributes.isFile()) return;
        SFTPv3FileHandle handle = null;
        try {
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Getting timestamp of {0}", "Status"), this.getName()));
            handle = this.session.sftp().openFileRO(this.getAbsolute());
            SFTPv3FileAttributes attr = this.session.sftp().fstat(handle);
            this.attributes.setModificationDate(Long.parseLong(attr.mtime.toString()) * 1000L);
            this.session.sftp().closeFile(handle);
            if (handle == null) return;
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
            return;
        }
        try {
            this.session.sftp().closeFile(handle);
            return;
        }
        catch (IOException e) {
            return;
        }
        finally {
            if (handle != null) {
                try {
                    this.session.sftp().closeFile(handle);
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void readPermission() {
        if (!this.attributes.isFile()) return;
        SFTPv3FileHandle handle = null;
        try {
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Getting permission of {0}", "Status"), this.getName()));
            handle = this.session.sftp().openFileRO(this.getAbsolute());
            SFTPv3FileAttributes attr = this.session.sftp().fstat(handle);
            String perm = attr.getOctalPermissions();
            try {
                this.attributes.setPermission(new Permission(Integer.parseInt(perm.substring(perm.length() - 3))));
            }
            catch (NumberFormatException e) {
                this.attributes.setPermission(Permission.EMPTY);
            }
            this.session.sftp().closeFile(handle);
            if (handle == null) return;
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
            return;
        }
        try {
            this.session.sftp().closeFile(handle);
            return;
        }
        catch (IOException e) {
            return;
        }
        finally {
            if (handle != null) {
                try {
                    this.session.sftp().closeFile(handle);
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void writeOwner(String owner, boolean recursive) {
        log.debug((Object)"changeOwner");
        try {
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Changing owner of {0} to {1}", "Status"), this.getName(), owner));
            SFTPv3FileAttributes attr = new SFTPv3FileAttributes();
            attr.uid = new Integer(owner);
            this.session.sftp().setstat(this.getAbsolute(), attr);
            if (this.attributes.isDirectory() && recursive) {
                Iterator iter = this.childs().iterator();
                while (iter.hasNext() && this.session.isConnected()) {
                    ((Path)iter.next()).writeOwner(owner, recursive);
                }
            }
        }
        catch (NumberFormatException e) {
            this.error("Cannot change owner", e);
        }
        catch (IOException e) {
            this.error("Cannot change owner", e);
        }
    }

    @Override
    public void writeGroup(String group, boolean recursive) {
        log.debug((Object)"changeGroup");
        try {
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Changing group of {0} to {1}", "Status"), this.getName(), group));
            SFTPv3FileAttributes attr = new SFTPv3FileAttributes();
            attr.gid = new Integer(group);
            this.session.sftp().setstat(this.getAbsolute(), attr);
            if (this.attributes.isDirectory() && recursive) {
                Iterator iter = this.childs().iterator();
                while (iter.hasNext() && this.session.isConnected()) {
                    ((Path)iter.next()).writeGroup(group, recursive);
                }
            }
        }
        catch (NumberFormatException e) {
            this.error("Cannot change group", e);
        }
        catch (IOException e) {
            this.error("Cannot change group", e);
        }
    }

    @Override
    public void writePermissions(Permission perm, boolean recursive) {
        log.debug((Object)"changePermissions");
        try {
            this.session.check();
            this.session.message(MessageFormat.format(Locale.localizedString("Changing permission of {0} to {1}", "Status"), this.getName(), perm.getOctalString()));
            SFTPv3FileAttributes attr = new SFTPv3FileAttributes();
            if (recursive && this.attributes.isFile()) {
                Permission modified = new Permission(perm);
                if (!this.attributes.getPermission().getOwnerPermissions()[2]) {
                    modified.getOwnerPermissions()[2] = false;
                }
                if (!this.attributes.getPermission().getGroupPermissions()[2]) {
                    modified.getGroupPermissions()[2] = false;
                }
                if (!this.attributes.getPermission().getOtherPermissions()[2]) {
                    modified.getOtherPermissions()[2] = false;
                }
                attr.permissions = modified.getOctalNumber();
            } else {
                attr.permissions = perm.getOctalNumber();
            }
            this.session.sftp().setstat(this.getAbsolute(), attr);
            if (this.attributes.isDirectory() && recursive) {
                for (AbstractPath child : this.childs()) {
                    if (!this.session.isConnected()) break;
                    child.writePermissions(perm, recursive);
                }
                this.invalidate();
            }
        }
        catch (IOException e) {
            this.error("Cannot change permissions", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        log.debug((Object)("download:" + this.toString()));
        InputStream in = null;
        Local.OutputStream out = null;
        try {
            if (check) {
                this.session.check();
            }
            if (this.attributes.isFile()) {
                if (Preferences.instance().getProperty("ssh.transfer").equals(Protocol.SFTP.getIdentifier())) {
                    SFTPv3FileHandle handle = this.session.sftp().openFileRO(this.getAbsolute());
                    in = new SFTPInputStream(handle);
                    if (this.getStatus().isResume()) {
                        log.info((Object)("Skipping " + this.getStatus().getCurrent() + " bytes"));
                        long skipped = in.skip(this.getStatus().getCurrent());
                        if (skipped < this.getStatus().getCurrent()) {
                            throw new IOResumeException("Skipped " + skipped + " bytes instead of " + this.getStatus().getCurrent());
                        }
                    }
                }
                if (Preferences.instance().getProperty("ssh.transfer").equals(Protocol.SCP.getIdentifier())) {
                    SCPClient scp = this.session.openScp();
                    scp.setCharset(this.session.getEncoding());
                    in = scp.get(this.getAbsolute());
                }
                out = new Local.OutputStream(this.getLocal(), this.getStatus().isResume());
                this.download(in, out, throttle, listener);
            } else if (this.attributes.isDirectory()) {
                this.getLocal().mkdir(true);
            }
        }
        catch (IOException e) {
            this.error("Download failed", e);
        }
        finally {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void upload(BandwidthThrottle throttle, StreamListener listener, Permission p, boolean check) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        PathFactory.addFactory(Protocol.SFTP, new Factory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<SFTPSession> {
        private Factory() {
        }

        @Override
        protected Path create(SFTPSession session, String path, int type) {
            return new SFTPPath(session, path, type);
        }

        @Override
        protected Path create(SFTPSession session, String parent, String name, int type) {
            return new SFTPPath(session, parent, name, type);
        }

        @Override
        protected Path create(SFTPSession session, String path, Local file) {
            return new SFTPPath(session, path, file);
        }

        @Override
        protected <T> Path create(SFTPSession session, T dict) {
            return new SFTPPath(session, dict);
        }
    }
}

