/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractBackgroundAction
implements BackgroundAction {
    private boolean canceled;
    private boolean running;
    private Set<BackgroundActionListener> listeners = Collections.synchronizedSet(new HashSet());
    private final Object lock = new Object();

    public void init() {
    }

    public void cancel() {
        BackgroundActionListener[] l;
        this.canceled = true;
        for (BackgroundActionListener listener : l = this.listeners.toArray(new BackgroundActionListener[this.listeners.size()])) {
            listener.cancel(this);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean prepare() {
        BackgroundActionListener[] l;
        if (this.isCanceled()) {
            return false;
        }
        this.running = true;
        for (BackgroundActionListener listener : l = this.listeners.toArray(new BackgroundActionListener[this.listeners.size()])) {
            listener.start(this);
        }
        return true;
    }

    public void finish() {
        BackgroundActionListener[] l;
        this.running = false;
        for (BackgroundActionListener listener : l = this.listeners.toArray(new BackgroundActionListener[this.listeners.size()])) {
            listener.stop(this);
        }
    }

    public void addListener(BackgroundActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(BackgroundActionListener listener) {
        this.listeners.remove(listener);
    }

    public String getActivity() {
        return Locale.localizedString("Unknown");
    }

    public String toString() {
        return this.getActivity();
    }

    public Object lock() {
        return this.lock;
    }
}

