/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPDataSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class FTPActiveDataSocket
implements FTPDataSocket {
    protected ServerSocket sock = null;
    protected Socket acceptedSock = null;

    public FTPActiveDataSocket(ServerSocket sock) {
        this.sock = sock;
    }

    public void setTimeout(int millis) throws IOException {
        this.sock.setSoTimeout(millis);
        if (this.acceptedSock != null) {
            this.acceptedSock.setSoTimeout(millis);
        }
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    protected void acceptConnection() throws IOException {
        if (null == this.acceptedSock) {
            this.acceptedSock = this.sock.accept();
            try {
                this.acceptedSock.setSoTimeout(this.sock.getSoTimeout());
            }
            catch (SocketException e) {
                // empty catch block
            }
            try {
                this.acceptedSock.setKeepAlive(true);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public OutputStream getOutputStream() throws IOException {
        this.acceptConnection();
        return this.acceptedSock.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        this.acceptConnection();
        return this.acceptedSock.getInputStream();
    }

    public void close() throws IOException {
        if (this.acceptedSock != null) {
            this.acceptedSock.close();
            this.acceptedSock = null;
        }
        this.sock.close();
    }
}

