/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class FTPClient {
    protected static Logger log = Logger.getLogger(FTPClient.class);
    private static final String SOCKS_PORT = "socksProxyPort";
    private static final String SOCKS_HOST = "socksProxyHost";
    protected FTPControlSocket control = null;
    protected FTPDataSocket data = null;
    private int timeout = 0;
    private boolean strictReturnCodes = true;
    private boolean cancelTransfer = false;
    private FTPTransferType transferType = FTPTransferType.ASCII;
    private FTPConnectMode connectMode = FTPConnectMode.PASV;
    protected FTPReply lastValidReply;
    private FTPMessageListener listener;
    private String[] features;
    private boolean statListSupportedEnabled = true;
    private boolean extendedListEnabled = true;
    private SimpleDateFormat tsFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private boolean utimeSupported;
    private boolean chmodSupported;
    private boolean featSupported;
    private boolean mlsdListSupportedEnabled;

    public FTPClient(String encoding, FTPMessageListener listener) {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.utimeSupported = true;
        this.chmodSupported = true;
        this.featSupported = true;
        this.mlsdListSupportedEnabled = true;
        this.listener = listener;
        this.control = new FTPControlSocket(encoding, listener);
    }

    public void connect(String remoteHost, int controlPort) throws IOException, FTPException {
        this.control.connect(InetAddress.getByName(remoteHost), controlPort);
    }

    public boolean isConnected() {
        if (null == this.control) {
            return false;
        }
        return this.control.isConnected();
    }

    public void interrupt() throws IOException {
        if (null == this.control) {
            log.warn((Object)"No control channel to interrupt");
            return;
        }
        this.control.interrupt();
        if (null == this.data) {
            log.info((Object)"No data channel to interrupt");
            return;
        }
        this.data.close();
    }

    public void setStrictReturnCodes(boolean strict) {
        this.strictReturnCodes = strict;
        if (this.control != null) {
            this.control.setStrictReturnCodes(strict);
        }
    }

    public boolean isStrictReturnCodes() {
        return this.strictReturnCodes;
    }

    public void setTimeout(int millis) throws IOException {
        this.timeout = millis;
        this.control.setTimeout(millis);
    }

    public void setConnectMode(FTPConnectMode mode) {
        this.connectMode = mode;
    }

    public void cancelTransfer() {
        this.cancelTransfer = true;
    }

    public void noop() throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("NOOP");
        this.lastValidReply = this.control.validateReply(reply, "200");
    }

    public void login(String user, String password) throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("USER " + user);
        String[] validCodes = new String[]{"230", "331"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        if (this.lastValidReply.getReplyCode().equals("230")) {
            return;
        }
        this.password(password);
    }

    public void user(String user) throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("USER " + user);
        String[] validCodes = new String[]{"230", "331"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void password(String password) throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("PASS " + password);
        String[] validCodes = new String[]{"230", "202"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void reinitialize() throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("REIN");
        String[] validCodes = new String[]{"120", "220"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public static void initSOCKS(int port, String host) {
        Properties props = System.getProperties();
        props.put(SOCKS_PORT, "" + port);
        props.put(SOCKS_HOST, host);
        System.setProperties(props);
    }

    public static void initSOCKSAuthentication(String username, String password) {
        Properties props = System.getProperties();
        props.put("java.net.socks.username", username);
        props.put("java.net.socks.password", password);
        System.setProperties(props);
    }

    public static void clearSOCKS() {
        Properties prop = System.getProperties();
        prop.remove(SOCKS_HOST);
        prop.remove(SOCKS_PORT);
        System.setProperties(prop);
    }

    String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    public String quote(String command) throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand(command);
        return reply.getReplyText();
    }

    public long size(String remoteFile) throws IOException, FTPException {
        if (this.isFeatureSupported("SIZE")) {
            FTPReply reply = this.control.sendCommand("SIZE " + remoteFile);
            this.lastValidReply = this.control.validateReply(reply, "213");
            String replyText = this.lastValidReply.getReplyText();
            int spacePos = replyText.indexOf(32);
            if (spacePos >= 0) {
                replyText = replyText.substring(0, spacePos);
            }
            try {
                return Long.parseLong(replyText);
            }
            catch (NumberFormatException ex) {
                log.warn((Object)("Failed to parse reply: " + replyText));
            }
        }
        return -1L;
    }

    private void restart(long size) throws IOException, FTPException {
        if (this.isFeatureSupported("REST STREAM")) {
            String[] validReplyCodes = new String[]{"125", "350"};
            FTPReply reply = this.control.sendCommand("REST " + size);
            this.lastValidReply = this.control.validateReply(reply, validReplyCodes);
        }
    }

    public void validateTransfer() throws IOException, FTPException {
        String[] validCodes = new String[]{"225", "226", "250", "426", "450"};
        FTPReply reply = this.control.readReply();
        String code = reply.getReplyCode();
        if ((code.equals("426") || code.equals("450")) && !this.cancelTransfer) {
            throw new FTPException(reply);
        }
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    private void closeDataSocket() {
        if (this.data != null) {
            try {
                this.data.close();
                this.data = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void initPut(String remoteFile, boolean append) throws IOException, FTPException {
        String cmd = (append ? "APPE " : "STOR ") + remoteFile;
        this.pret(cmd);
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        FTPReply reply = this.control.sendCommand(cmd);
        String[] validCodes = new String[]{"125", "150"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    private void initGet(String remoteFile, long resume) throws IOException, FTPException {
        String cmd = "RETR " + remoteFile;
        this.pret(cmd);
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        if (resume > 0L) {
            this.restart(resume);
        }
        FTPReply reply = this.control.sendCommand(cmd);
        String[] validCodes1 = new String[]{"125", "150"};
        this.lastValidReply = this.control.validateReply(reply, validCodes1);
    }

    public OutputStream put(String remoteFile, boolean append) throws IOException, FTPException {
        this.initPut(remoteFile, append);
        return this.data.getOutputStream();
    }

    public InputStream get(String remoteFile, long resume) throws IOException, FTPException {
        this.initGet(remoteFile, resume);
        return this.data.getInputStream();
    }

    public boolean site(String command) throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("SITE " + command);
        String[] validCodes = new String[]{"200", "202", "250", "502", "253"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        return reply.getReplyCode().equals("200");
    }

    public void setStatListSupportedEnabled(boolean statListSupportedEnabled) {
        this.statListSupportedEnabled = statListSupportedEnabled;
    }

    public BufferedReader stat(String pathname) throws IOException, FTPException {
        if (this.statListSupportedEnabled) {
            try {
                FTPReply reply = this.control.sendCommand("STAT " + pathname);
                this.lastValidReply = this.control.validateReply(reply, new String[]{"211", "212", "213"});
                if (null == this.lastValidReply.getReplyData() || 0 == this.lastValidReply.getReplyData().length) {
                    this.statListSupportedEnabled = false;
                    return null;
                }
                StringBuilder result = new StringBuilder();
                for (int i = 0; i < this.lastValidReply.getReplyData().length; ++i) {
                    String line = this.lastValidReply.getReplyData()[i];
                    if (line.startsWith(this.lastValidReply.getReplyCode())) {
                        try {
                            result.append(line.substring(line.indexOf(this.lastValidReply.getReplyCode()) + this.lastValidReply.getReplyCode().length() + 1).trim()).append('\n');
                        }
                        catch (IndexOutOfBoundsException e) {
                            log.error((Object)("Failed parsing line '" + line + "':" + e.getMessage()));
                        }
                        continue;
                    }
                    result.append(line.trim()).append('\n');
                }
                return new BufferedReader(new StringReader(result.toString()));
            }
            catch (FTPException e) {
                this.statListSupportedEnabled = false;
                log.error((Object)e.getMessage());
            }
        }
        return null;
    }

    public void setExtendedListEnabled(boolean extendedListEnabled) {
        this.extendedListEnabled = extendedListEnabled;
    }

    public BufferedReader list(String encoding, boolean flag) throws IOException, FTPException {
        if (this.extendedListEnabled && flag) {
            try {
                return this.dir(encoding, "LIST -a");
            }
            catch (FTPException e) {
                this.extendedListEnabled = false;
                log.error((Object)e.getMessage());
            }
        }
        return this.dir(encoding, "LIST");
    }

    public BufferedReader dir(String encoding, String command) throws IOException, FTPException {
        this.pret(command);
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        FTPReply reply = this.control.sendCommand(command);
        this.lastValidReply = this.control.validateReply(reply, new String[]{"125", "150", "450", "550"});
        String replyCode = this.lastValidReply.getReplyCode();
        if (!replyCode.equals("450") && !replyCode.equals("550")) {
            return new BufferedReader(new InputStreamReader(this.data.getInputStream(), Charset.forName(encoding))){

                public String readLine() throws IOException {
                    String line = super.readLine();
                    if (null != line) {
                        FTPClient.this.listener.logReply(line);
                    }
                    return line;
                }
            };
        }
        this.closeDataSocket();
        return null;
    }

    public void finishDir() throws IOException, FTPException {
        this.closeDataSocket();
        this.lastValidReply = this.control.validateReply(this.control.readReply(), new String[]{"226", "250"});
    }

    protected String readLine(LineNumberReader in) throws IOException {
        return in.readLine();
    }

    public FTPReply getLastValidReply() {
        return this.lastValidReply;
    }

    public FTPTransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(FTPTransferType type) throws IOException, FTPException {
        if (!type.equals(this.transferType)) {
            String typeStr = FTPTransferType.ASCII_CHAR;
            if (type.equals(FTPTransferType.BINARY)) {
                typeStr = FTPTransferType.BINARY_CHAR;
            }
            FTPReply reply = this.control.sendCommand("TYPE " + typeStr);
            this.lastValidReply = this.control.validateReply(reply, "200");
        }
        this.transferType = type;
    }

    public void delete(String remoteFile) throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("DELE " + remoteFile);
        this.lastValidReply = this.control.validateReply(reply, new String[]{"200", "250"});
    }

    public void rename(String from, String to) throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("RNFR " + from);
        this.lastValidReply = this.control.validateReply(reply, "350");
        reply = this.control.sendCommand("RNTO " + to);
        this.lastValidReply = this.control.validateReply(reply, new String[]{"200", "250"});
    }

    public void rmdir(String dir) throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("RMD " + dir);
        this.lastValidReply = this.control.validateReply(reply, new String[]{"200", "250", "257"});
    }

    public void mkdir(String dir) throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("MKD " + dir);
        this.lastValidReply = this.control.validateReply(reply, new String[]{"200", "250", "257"});
    }

    public void chdir(String dir) throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("CWD " + dir);
        this.lastValidReply = this.control.validateReply(reply, new String[]{"200", "250", "257"});
    }

    public void cdup() throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("CDUP");
        this.lastValidReply = this.control.validateReply(reply, new String[]{"200", "250", "257"});
    }

    public long parseTimestamp(String timestamp) {
        return this.tsFormat.parse(timestamp, new ParsePosition(0)).getTime();
    }

    protected boolean isMDTMSupported() throws IOException {
        Iterator<String> iter = Arrays.asList(this.features()).iterator();
        while (iter.hasNext()) {
            if (!"MDTM".equals(iter.next().trim())) continue;
            return true;
        }
        log.warn((Object)"No MDTM support");
        return false;
    }

    public long mdtm(String remoteFile) throws IOException, FTPException {
        if (this.isMDTMSupported()) {
            FTPReply reply = this.control.sendCommand("MDTM " + remoteFile);
            this.lastValidReply = this.control.validateReply(reply, "213");
            return this.parseTimestamp(this.lastValidReply.getReplyText());
        }
        return -1L;
    }

    private void utime(long modtime, long createdtime, String remoteFile) throws IOException, FTPException {
        if (this.utimeSupported) {
            try {
                this.site("UTIME " + remoteFile + " " + this.tsFormat.format(new Date(modtime)) + " " + this.tsFormat.format(new Date(modtime)) + " " + this.tsFormat.format(new Date(createdtime)) + " UTC");
            }
            catch (FTPException e) {
                this.utimeSupported = false;
                log.warn((Object)"UTIME not supported");
            }
        }
    }

    public void chmod(String octal, String remoteFile) throws IOException, FTPException {
        if (this.chmodSupported) {
            try {
                this.site("CHMOD " + octal + " " + remoteFile);
            }
            catch (FTPException e) {
                this.chmodSupported = false;
                throw e;
            }
        }
        throw new FTPException("CHMOD not supported");
    }

    public String pwd() throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("PWD");
        this.lastValidReply = this.control.validateReply(reply, "257");
        String text = this.lastValidReply.getReplyText();
        int start = text.indexOf(34);
        int end = text.indexOf(34, start + 1);
        if (start >= 0 && end > start) {
            return text.substring(start + 1, end);
        }
        return text;
    }

    public void abor() throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("ABOR");
        this.lastValidReply = this.control.validateReply(reply, new String[]{"225", "226", "426", "450", "451"});
        String replyCode = this.lastValidReply.getReplyCode();
        if (replyCode.equals("426") || replyCode.equals("450") || replyCode.equals("451")) {
            String[] c = new String[]{"225", "226"};
            this.lastValidReply = this.control.validateReply(this.control.readReply(), c);
        }
    }

    public String[] features() throws IOException, FTPException {
        if (null == this.features) {
            if (this.featSupported) {
                try {
                    FTPReply reply = this.control.sendCommand("FEAT");
                    this.lastValidReply = this.control.validateReply(reply, "211");
                    this.features = this.lastValidReply.getReplyData();
                }
                catch (FTPException e) {
                    this.featSupported = false;
                }
            }
            if (null == this.features) {
                return new String[0];
            }
        }
        return this.features;
    }

    public boolean isFeatureSupported(String feature) throws IOException {
        Iterator<String> iter = Arrays.asList(this.features()).iterator();
        while (iter.hasNext()) {
            if (!feature.equals(iter.next().trim())) continue;
            return true;
        }
        log.warn((Object)("No " + feature + " support"));
        return false;
    }

    public String system() throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("SYST");
        this.lastValidReply = this.control.validateReply(reply, new String[]{"200", "213", "215"});
        return this.lastValidReply.getReplyText();
    }

    private void pret(String cmd) throws IOException {
        if (this.isFeatureSupported("PRET")) {
            FTPReply reply = this.control.sendCommand("PRET " + cmd);
            this.lastValidReply = this.control.validateReply(reply, "200");
        }
    }

    public void utf8() throws IOException {
        if (this.isFeatureSupported("UTF8")) {
            try {
                FTPReply reply = this.control.sendCommand("OPTS UTF8 ON");
                this.lastValidReply = this.control.validateReply(reply, new String[]{"200"});
            }
            catch (FTPException e) {
                log.warn((Object)("Failed to negogiate UTF-8 charset:" + e.getMessage()));
            }
        }
    }

    public String[] mlst(String path) throws IOException {
        if (this.isFeatureSupported("MLST")) {
            FTPReply reply = this.control.sendCommand("MLST " + path);
            this.lastValidReply = this.control.validateReply(reply, new String[]{"250"});
            return this.lastValidReply.getReplyData();
        }
        return null;
    }

    public void setMlsdListSupportedEnabled(boolean mlsdListSupportedEnabled) {
        this.mlsdListSupportedEnabled = mlsdListSupportedEnabled;
    }

    public BufferedReader mlsd(String encoding) throws IOException {
        if (this.mlsdListSupportedEnabled && this.isFeatureSupported("MLSD")) {
            this.data = this.control.createDataSocket(this.connectMode);
            this.data.setTimeout(this.timeout);
            FTPReply reply = this.control.sendCommand("MLSD");
            this.lastValidReply = this.control.validateReply(reply, "150");
            return new BufferedReader(new InputStreamReader(this.data.getInputStream(), Charset.forName(encoding))){

                public String readLine() throws IOException {
                    String line = super.readLine();
                    if (null != line) {
                        FTPClient.this.listener.logReply(line);
                    }
                    return line;
                }
            };
        }
        return null;
    }

    public void mfmt(long modtime, long createdate, String remoteFile) throws IOException, FTPException {
        if (this.isFeatureSupported("MFMT")) {
            FTPReply reply = this.control.sendCommand("MFMT " + this.tsFormat.format(modtime) + " " + remoteFile);
            this.lastValidReply = this.control.validateReply(reply, "213");
        } else {
            this.utime(modtime, createdate, remoteFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() throws IOException, FTPException {
        try {
            FTPReply reply = this.control.sendCommand("QUIT");
            this.lastValidReply = this.control.validateReply(reply, new String[]{"221", "226"});
        }
        finally {
            this.control.logout();
            this.control = null;
        }
    }
}

