/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.ui.cocoa.foundation.NSObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeCache<K> {
    private static Logger log = Logger.getLogger(AttributeCache.class);
    private Map<K, Map<String, NSObject>> impl;

    public AttributeCache(int size) {
        this.impl = new LRUMap(size){

            protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
                log.debug((Object)("Removing from cache:" + entry));
                return true;
            }
        };
    }

    public NSObject put(K key, String attribute, NSObject value) {
        Map<String, NSObject> attributes = this.impl.containsKey(key) ? this.impl.get(key) : new HashMap<String, NSObject>();
        attributes.put(attribute, value);
        this.impl.put(key, attributes);
        return value;
    }

    public NSObject get(K key, String attribute) {
        if (!this.impl.containsKey(key)) {
            log.warn((Object)("No cached attributes for " + key));
            return null;
        }
        Map<String, NSObject> attributes = this.impl.get(key);
        return attributes.get(attribute);
    }

    public void remove(K key) {
        this.impl.remove(key);
    }

    public void clear() {
        this.impl.clear();
    }
}

