/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.ui.cocoa.CDController;
import ch.cyberduck.ui.cocoa.CDTableDelegate;
import ch.cyberduck.ui.cocoa.application.NSOutlineView;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import java.util.Comparator;
import org.apache.log4j.Logger;
import org.rococoa.ID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDAbstractTableDelegate<E>
extends CDController
implements CDTableDelegate<E> {
    private static Logger log = Logger.getLogger(CDAbstractTableDelegate.class);
    private NSTableColumn selectedColumn;
    private Boolean sortAscending;

    protected void setSelectedColumn(NSTableColumn selectedColumn) {
        this.selectedColumn = selectedColumn;
        Preferences.instance().setProperty("browser.sort.column", this.selectedColumnIdentifier());
    }

    protected String selectedColumnIdentifier() {
        if (null == this.selectedColumn) {
            return Preferences.instance().getProperty("browser.sort.column");
        }
        return this.selectedColumn.identifier();
    }

    public boolean isColumnEditable(NSTableColumn column) {
        return false;
    }

    public boolean tableView_shouldSelectRow(NSTableView view, int rowIndex) {
        return true;
    }

    public boolean outlineView_shouldSelectItem(NSOutlineView view, NSObject item) {
        return true;
    }

    public boolean tableView_shouldEditTableColumn_row(NSTableView view, NSTableColumn tableColumn, int row) {
        return false;
    }

    public boolean outlineView_shouldEditTableColumn_item(NSOutlineView view, NSTableColumn tableColumn, NSObject item) {
        return false;
    }

    public boolean selectionShouldChange() {
        return true;
    }

    public boolean selectionShouldChangeInTableView(NSTableView view) {
        return this.selectionShouldChange();
    }

    public boolean selectionShouldChangeInOutlineView(NSTableView view) {
        return this.selectionShouldChange();
    }

    public abstract void tableColumnClicked(NSTableView var1, NSTableColumn var2);

    public void outlineView_didClickTableColumn(NSOutlineView view, NSTableColumn tableColumn) {
        this.tableColumnClicked(view, tableColumn);
    }

    public void tableView_didClickTableColumn(NSOutlineView view, NSTableColumn tableColumn) {
        this.tableColumnClicked(view, tableColumn);
    }

    public abstract void tableRowDoubleClicked(ID var1);

    public void tableViewSelectionDidChange(NSNotification notification) {
        this.selectionDidChange(notification);
    }

    public void tableViewSelectionIsChanging(NSNotification notification) {
        this.selectionIsChanging(notification);
    }

    public void outlineViewSelectionDidChange(NSNotification notification) {
        this.selectionDidChange(notification);
    }

    public void outlineViewSelectionIsChanging(NSNotification notification) {
        this.selectionIsChanging(notification);
    }

    public abstract void selectionDidChange(NSNotification var1);

    public void selectionIsChanging(NSNotification notification) {
    }

    @Override
    public Comparator<E> getSortingComparator() {
        return new NullComparator();
    }

    public void setSortedAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
        Preferences.instance().setProperty("browser.sort.ascending", this.sortAscending.booleanValue());
    }

    @Override
    public boolean isSortedAscending() {
        if (null == this.sortAscending) {
            return Preferences.instance().getBoolean("browser.sort.ascending");
        }
        return this.sortAscending;
    }
}

