/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostFilter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.serializer.HostReaderFactory;
import ch.cyberduck.core.serializer.HostWriterFactory;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.AttributeCache;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDListDataSource;
import ch.cyberduck.ui.cocoa.CDTransferController;
import ch.cyberduck.ui.cocoa.HostPasteboard;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSDraggingInfo;
import ch.cyberduck.ui.cocoa.application.NSEvent;
import ch.cyberduck.ui.cocoa.application.NSImage;
import ch.cyberduck.ui.cocoa.application.NSPasteboard;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSIndexSet;
import ch.cyberduck.ui.cocoa.foundation.NSMutableArray;
import ch.cyberduck.ui.cocoa.foundation.NSMutableDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

public class CDBookmarkTableDataSource
extends CDListDataSource {
    private static Logger log = Logger.getLogger(CDBookmarkTableDataSource.class);
    public static final String ICON_COLUMN = "ICON";
    public static final String BOOKMARK_COLUMN = "BOOKMARK";
    public static final String STATUS_COLUMN = "STATUS";
    protected static final String TYPEAHEAD_COLUMN = "TYPEAHEAD";
    protected CDBrowserController controller;
    private BookmarkCollection source = BookmarkCollection.empty();
    private CollectionListener<Host> listener;
    private HostFilter filter;
    private BookmarkCollection filtered;
    private static final NSImage STATUS_GREEN = CDIconCache.iconNamed("statusGreen.tiff");
    private static final NSImage STATUS_YELLOW = CDIconCache.iconNamed("statusYellow.tiff");
    private AttributeCache<Host> cache = new AttributeCache(Preferences.instance().getInteger("bookmark.model.cache.size"));

    public CDBookmarkTableDataSource(CDBrowserController controller, BookmarkCollection source) {
        this.controller = controller;
        this.setSource(source);
    }

    public void setSource(final BookmarkCollection source) {
        this.source.removeListener(this.listener);
        this.source = source;
        this.listener = new CollectionListener<Host>(){
            private Timer delayed = null;

            public void collectionItemAdded(Host item) {
                CDBookmarkTableDataSource.this.cache.clear();
                CDBookmarkTableDataSource.this.controller.reloadBookmarks();
            }

            public void collectionItemRemoved(Host item) {
                CDBookmarkTableDataSource.this.cache.clear();
                CDBookmarkTableDataSource.this.controller.reloadBookmarks();
            }

            public void collectionItemChanged(Host item) {
                CDBookmarkTableDataSource.this.cache.clear();
                CDBookmarkTableDataSource.this.controller.reloadBookmarks();
                if (null != this.delayed) {
                    this.delayed.cancel();
                }
                this.delayed = new Timer();
                this.delayed.schedule(new TimerTask(){

                    public void run() {
                        CDBookmarkTableDataSource.this.controller.invoke((MainAction)new DefaultMainAction(){

                            public void run() {
                                source.save();
                            }
                        });
                    }
                }, 5000L);
            }
        };
        this.source.addListener((CollectionListener)this.listener);
        this.setFilter(null);
    }

    protected void invalidate() {
        this.cache.clear();
        this.source.removeListener(this.listener);
        super.invalidate();
    }

    public void setFilter(HostFilter filter) {
        this.filter = filter;
        this.filtered = null;
    }

    protected BookmarkCollection getSource() {
        if (null == this.filter) {
            return this.source;
        }
        if (null == this.filtered) {
            this.filtered = new BookmarkCollection(){

                public boolean allowsAdd() {
                    return CDBookmarkTableDataSource.this.source.allowsAdd();
                }

                public boolean allowsDelete() {
                    return CDBookmarkTableDataSource.this.source.allowsDelete();
                }

                public boolean allowsEdit() {
                    return CDBookmarkTableDataSource.this.source.allowsEdit();
                }

                public void save() {
                    CDBookmarkTableDataSource.this.source.save();
                }

                public void load() {
                    CDBookmarkTableDataSource.this.source.load();
                }
            };
            for (Host bookmark : this.source) {
                if (!this.filter.accept(bookmark)) continue;
                this.filtered.add((Object)bookmark);
            }
            this.filtered.addListener((CollectionListener)new CollectionListener<Host>(){

                public void collectionItemAdded(Host item) {
                    CDBookmarkTableDataSource.this.source.add((Object)item);
                }

                public void collectionItemRemoved(Host item) {
                    CDBookmarkTableDataSource.this.source.remove((Object)item);
                }

                public void collectionItemChanged(Host item) {
                    CDBookmarkTableDataSource.this.source.collectionItemChanged((Object)item);
                }
            });
        }
        return this.filtered;
    }

    public NSInteger numberOfRowsInTableView(NSTableView view) {
        return new NSInteger(this.getSource().size());
    }

    public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
        String identifier = tableColumn.identifier();
        Host host = (Host)this.getSource().get(row.intValue());
        NSObject cached = this.cache.get(host, identifier);
        if (null == cached) {
            if (identifier.equals(ICON_COLUMN)) {
                return CDIconCache.iconNamed(host.getProtocol().disk(), Preferences.instance().getInteger("bookmark.icon.size"));
            }
            if (identifier.equals(BOOKMARK_COLUMN)) {
                NSMutableDictionary dict = NSMutableDictionary.dictionaryWithDictionary((NSDictionary)host.getAsDictionary());
                dict.setObjectForKey(host.toURL() + Path.normalize((String)host.getDefaultPath()), "URL");
                if (StringUtils.isNotBlank((String)host.getComment())) {
                    dict.setObjectForKey(StringUtils.remove((String)StringUtils.remove((String)host.getComment(), (char)'\n'), (char)'\r'), "Comment");
                }
                return this.cache.put(host, identifier, dict);
            }
            if (identifier.equals(STATUS_COLUMN)) {
                Session session;
                if (this.controller.hasSession() && host.equals((Object)(session = this.controller.getSession()).getHost())) {
                    if (session.isConnected()) {
                        return STATUS_GREEN;
                    }
                    if (session.isOpening()) {
                        return STATUS_YELLOW;
                    }
                }
                return null;
            }
            if (identifier.equals(TYPEAHEAD_COLUMN)) {
                return this.cache.put(host, identifier, NSString.stringWithString(host.getNickname()));
            }
            throw new IllegalArgumentException("Unknown identifier: " + identifier);
        }
        return cached;
    }

    public NSUInteger tableView_validateDrop_proposedRow_proposedDropOperation(NSTableView view, NSDraggingInfo draggingInfo, NSInteger index, NSUInteger operation) {
        int i;
        NSArray elements;
        NSObject o;
        NSPasteboard draggingPasteboard = draggingInfo.draggingPasteboard();
        if (!this.getSource().allowsEdit()) {
            return NSDraggingInfo.NSDragOperationNone;
        }
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject("NSStringPboardType")) != null) {
            String o2 = draggingPasteboard.stringForType("NSStringPboardType");
            if (o2 != null && Protocol.isURL((String)o2)) {
                view.setDropRow(index, NSTableView.NSTableViewDropAbove);
                return NSDraggingInfo.NSDragOperationCopy;
            }
            return NSDraggingInfo.NSDragOperationNone;
        }
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null && (o = draggingPasteboard.propertyListForType("NSFilenamesPboardType")) != null) {
            elements = Rococoa.cast(o, NSArray.class);
            for (i = 0; i < elements.count().intValue(); ++i) {
                String file = elements.objectAtIndex(new NSUInteger(i)).toString();
                if (!file.contains(".duck")) continue;
                return NSDraggingInfo.NSDragOperationCopy;
            }
            if (index.intValue() > -1 && index.intValue() < view.numberOfRows().intValue()) {
                view.setDropRow(index, NSTableView.NSTableViewDropOn);
                return NSDraggingInfo.NSDragOperationCopy;
            }
        }
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject("Apple URL pasteboard type")) != null) {
            o = draggingPasteboard.propertyListForType("Apple URL pasteboard type");
            if (o != null) {
                elements = Rococoa.cast(o, NSArray.class);
                for (i = 0; i < elements.count().intValue(); ++i) {
                    if (!Protocol.isURL((String)elements.objectAtIndex(new NSUInteger(i)).toString())) continue;
                    view.setDropRow(index, NSTableView.NSTableViewDropAbove);
                    return NSDraggingInfo.NSDragOperationCopy;
                }
            }
            return NSDraggingInfo.NSDragOperationNone;
        }
        if (!HostPasteboard.getPasteboard().isEmpty() && index.intValue() > -1 && index.intValue() < view.numberOfRows().intValue()) {
            view.setDropRow(index, NSTableView.NSTableViewDropAbove);
            return NSDraggingInfo.NSDragOperationMove;
        }
        return NSDraggingInfo.NSDragOperationNone;
    }

    public boolean tableView_acceptDrop_row_dropOperation(NSTableView view, NSDraggingInfo draggingInfo, NSInteger row, NSUInteger operation) {
        NSPasteboard draggingPasteboard = draggingInfo.draggingPasteboard();
        log.debug((Object)("tableViewAcceptDrop:" + (Object)((Object)row)));
        BookmarkCollection source = this.getSource();
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null) {
            UploadTransfer q;
            NSArray filesList = Rococoa.cast(draggingPasteboard.propertyListForType("NSFilenamesPboardType"), NSArray.class);
            Collection roots = new Collection();
            Session session = null;
            for (int i = 0; i < filesList.count().intValue(); ++i) {
                String filename = filesList.objectAtIndex(new NSUInteger(i)).toString();
                if (filename.endsWith(".duck")) {
                    if (row.intValue() < 0) {
                        row = new NSInteger(0L);
                    }
                    if (row.intValue() > view.numberOfRows().intValue()) {
                        row = new NSInteger(view.numberOfRows().intValue());
                    }
                    source.add(row.intValue(), (Object)HostReaderFactory.instance().read(LocalFactory.createLocal((String)filename)));
                    view.selectRowIndexes(NSIndexSet.indexSetWithIndex(row), false);
                    view.scrollRowToVisible(row);
                    continue;
                }
                Host h = (Host)source.get(row.intValue());
                if (null == session) {
                    session = SessionFactory.createSession((Host)h);
                }
                roots.add(PathFactory.createPath((Session)session, (String)h.getDefaultPath(), (Local)LocalFactory.createLocal((String)filename)));
            }
            if (!roots.isEmpty() && (q = new UploadTransfer((List)roots)).numberOfRoots() > 0) {
                CDTransferController.instance().startTransfer((Transfer)q);
            }
            return true;
        }
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject("Apple URL pasteboard type")) != null) {
            NSObject o = draggingPasteboard.propertyListForType("Apple URL pasteboard type");
            if (o != null) {
                NSArray elements = Rococoa.cast(o, NSArray.class);
                for (int i = 0; i < elements.count().intValue(); ++i) {
                    String url = elements.objectAtIndex(new NSUInteger(i)).toString();
                    if (!StringUtils.isNotBlank((String)url)) continue;
                    Host h = Host.parse((String)url);
                    source.add(row.intValue(), (Object)h);
                    view.selectRowIndexes(NSIndexSet.indexSetWithIndex(row), false);
                    view.scrollRowToVisible(row);
                }
                return true;
            }
            return false;
        }
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject("NSStringPboardType")) != null) {
            String o = draggingPasteboard.stringForType("NSStringPboardType");
            if (o != null) {
                Host h = Host.parse((String)o);
                source.add(row.intValue(), (Object)h);
                view.selectRowIndexes(NSIndexSet.indexSetWithIndex(row), false);
                view.scrollRowToVisible(row);
                return true;
            }
            return false;
        }
        if (!HostPasteboard.getPasteboard().isEmpty()) {
            Iterator i$ = HostPasteboard.getPasteboard().iterator();
            while (i$.hasNext()) {
                Host promisedDragBookmark = (Host)i$.next();
                source.remove(source.indexOf((Object)promisedDragBookmark));
                source.add(row.intValue(), (Object)promisedDragBookmark);
                view.selectRowIndexes(NSIndexSet.indexSetWithIndex(row), false);
                view.scrollRowToVisible(row);
            }
            return true;
        }
        return false;
    }

    public void draggedImage_endedAt_operation(NSImage image, NSPoint point, NSUInteger operation) {
        if (NSDraggingInfo.NSDragOperationDelete.intValue() == operation.intValue()) {
            this.controller.deleteBookmarkButtonClicked(null);
        }
        NSPasteboard.pasteboardWithName("Apple CFPasteboard drag").declareTypes_owner(null, null);
        HostPasteboard.getPasteboard().clear();
    }

    public NSUInteger draggingSourceOperationMaskForLocal(boolean local) {
        log.debug((Object)("draggingSourceOperationMaskForLocal:" + local));
        if (local) {
            return new NSUInteger(NSDraggingInfo.NSDragOperationMove.intValue() | NSDraggingInfo.NSDragOperationCopy.intValue());
        }
        return new NSUInteger(NSDraggingInfo.NSDragOperationCopy.intValue() | NSDraggingInfo.NSDragOperationDelete.intValue());
    }

    public boolean tableView_writeRowsWithIndexes_toPasteboard(NSTableView view, NSIndexSet rowIndexes, NSPasteboard pboard) {
        NSUInteger index = rowIndexes.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            HostPasteboard.getPasteboard().add(this.getSource().get(index.intValue()));
            index = rowIndexes.indexGreaterThanIndex(index);
        }
        NSEvent event = NSApplication.sharedApplication().currentEvent();
        if (event != null) {
            NSPoint dragPosition = view.convertPoint_fromView(event.locationInWindow(), null);
            NSRect imageRect = new NSRect(new NSPoint(dragPosition.x.doubleValue() - 16.0, dragPosition.y.doubleValue() - 16.0), new NSSize(32.0, 32.0));
            view.dragPromisedFilesOfTypes(NSArray.arrayWithObject("duck"), imageRect, this.id(), true, event);
            return true;
        }
        return false;
    }

    public NSArray namesOfPromisedFilesDroppedAtDestination(NSURL dropDestination) {
        log.debug((Object)("namesOfPromisedFilesDroppedAtDestination:" + dropDestination));
        NSMutableArray promisedDragNames = NSMutableArray.array();
        if (null != dropDestination) {
            HostPasteboard pasteboard = HostPasteboard.getPasteboard();
            Iterator i$ = pasteboard.iterator();
            while (i$.hasNext()) {
                Host promisedDragBookmark = (Host)i$.next();
                Local file = LocalFactory.createLocal((String)dropDestination.path(), (String)(promisedDragBookmark.getNickname() + ".duck"));
                HostWriterFactory.instance().write((Serializable)promisedDragBookmark, file);
                promisedDragNames.addObject(NSString.stringWithString(file.getName()));
            }
            pasteboard.clear();
        }
        return promisedDragNames;
    }
}

