/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDFileController;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSImageView;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import java.text.MessageFormat;
import java.util.Collections;
import org.apache.log4j.Logger;

public class CDFolderController
extends CDFileController {
    private static Logger log = Logger.getLogger(CDFolderController.class);
    protected NSImageView iconView;

    public void setIconView(NSImageView iconView) {
        this.iconView = iconView;
        this.iconView.setImage(CDIconCache.iconNamed("newfolder.icns", 128));
    }

    public CDFolderController(CDWindowController parent) {
        super(parent);
    }

    protected String getBundleName() {
        return "Folder";
    }

    public void callback(int returncode) {
        if (returncode == 1) {
            this.createFolder(this.getWorkdir(), this.filenameField.stringValue());
        }
    }

    protected void createFolder(final Path workdir, final String filename) {
        final CDBrowserController c = (CDBrowserController)this.parent;
        c.background((BackgroundAction)new BrowserBackgroundAction(c){
            final Path folder;
            {
                super(x0);
                this.folder = PathFactory.createPath((Session)workdir.getSession(), (String)workdir.getAbsolute(), (String)filename, (int)2);
            }

            public void run() {
                this.folder.mkdir(false);
                if (Preferences.instance().getBoolean("queue.upload.changePermissions") && Preferences.instance().getBoolean("queue.upload.permissions.useDefault")) {
                    this.folder.writePermissions(new Permission(Preferences.instance().getInteger("queue.upload.permissions.folder.default")), false);
                }
                this.folder.cache().put((AbstractPath)this.folder, AttributedList.emptyList());
                this.folder.getParent().invalidate();
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Making directory {0}", (String)"Status"), this.folder.getName());
            }

            public void cleanup() {
                if (filename.charAt(0) == '.') {
                    c.setShowHiddenFiles(true);
                }
                c.reloadData(Collections.singletonList(this.folder));
            }
        });
    }
}

