/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.cocoa.CDAlertController;
import ch.cyberduck.ui.cocoa.CDController;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.foundation.NSAutoreleasePool;
import ch.ethz.ssh2.KnownHosts;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class CDHostKeyController
extends CDController
implements ServerHostKeyVerifier {
    protected static Logger log = Logger.getLogger(CDHostKeyController.class);
    private CDWindowController parent;
    private KnownHosts database;

    public CDHostKeyController(CDWindowController windowController) {
        this.parent = windowController;
        Local f = LocalFactory.createLocal((String)Preferences.instance().getProperty("ssh.knownhosts"));
        if (!f.exists()) {
            f.getParent().mkdir(true);
            f.touch();
        }
        if (f.isReadable()) {
            try {
                this.database = new KnownHosts(f.getAbsolute());
            }
            catch (IOException e) {
                log.error((Object)("Cannot read " + f.getAbsolute()));
            }
        }
        if (null == this.database) {
            this.database = new KnownHosts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyServerHostKey(final String hostname, int port, final String serverHostKeyAlgorithm, final byte[] serverHostKey) throws Exception {
        NSAutoreleasePool pool;
        block6: {
            int result;
            block5: {
                boolean bl;
                result = this.database.verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey);
                if (0 == result) {
                    return true;
                }
                pool = NSAutoreleasePool.push();
                try {
                    if (1 != result) break block5;
                    NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Unknown host key for") + " " + hostname, Locale.localizedString((String)"The host is currently unknown to the system. The host key fingerprint is") + ": " + KnownHosts.createHexFingerprint((String)serverHostKeyAlgorithm, (byte[])serverHostKey) + ".", Locale.localizedString((String)"Allow"), Locale.localizedString((String)"Deny"), LocalFactory.createLocal((String)Preferences.instance().getProperty("ssh.knownhosts")).isWritable() ? Locale.localizedString((String)"Always") : null);
                    CDAlertController c = new CDAlertController(this.parent, alert){

                        public void callback(int returncode) {
                            if (returncode == 1) {
                                CDHostKeyController.this.allow(hostname, serverHostKeyAlgorithm, serverHostKey, false);
                            }
                            if (returncode == -1) {
                                CDHostKeyController.this.allow(hostname, serverHostKeyAlgorithm, serverHostKey, true);
                            }
                            if (returncode == 0) {
                                log.warn((Object)"Cannot continue without a valid host key");
                            }
                        }
                    };
                    c.beginSheet();
                    bl = c.returnCode() == 1 || c.returnCode() == -1;
                    Object var11_14 = null;
                }
                catch (Throwable throwable) {
                    Object var11_17 = null;
                    pool.drain();
                    throw throwable;
                }
                pool.drain();
                return bl;
            }
            if (2 != result) break block6;
            NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Host key mismatch:") + " " + hostname, Locale.localizedString((String)"The host key supplied is") + ": " + KnownHosts.createHexFingerprint((String)serverHostKeyAlgorithm, (byte[])serverHostKey) + Locale.localizedString((String)"Do you want to allow the host access?"), Locale.localizedString((String)"Allow"), Locale.localizedString((String)"Deny"), LocalFactory.createLocal((String)Preferences.instance().getProperty("ssh.knownhosts")).isWritable() ? Locale.localizedString((String)"Always") : null);
            CDAlertController c = new CDAlertController(this.parent, alert){

                public void callback(int returncode) {
                    if (returncode == 1) {
                        CDHostKeyController.this.allow(hostname, serverHostKeyAlgorithm, serverHostKey, false);
                    }
                    if (returncode == -1) {
                        CDHostKeyController.this.allow(hostname, serverHostKeyAlgorithm, serverHostKey, true);
                    }
                    if (returncode == 0) {
                        log.warn((Object)"Cannot continue without a valid host key");
                    }
                }
            };
            c.beginSheet();
            boolean bl = c.returnCode() == 1 || c.returnCode() == -1;
            Object var11_15 = null;
            pool.drain();
            return bl;
        }
        boolean bl = false;
        Object var11_16 = null;
        pool.drain();
        return bl;
    }

    private void allow(String hostname, String serverHostKeyAlgorithm, byte[] serverHostKey, boolean always) {
        String hashedHostname = KnownHosts.createHashedHostname((String)hostname);
        try {
            this.database.addHostkey(new String[]{hashedHostname}, serverHostKeyAlgorithm, serverHostKey);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        if (always) {
            try {
                KnownHosts.addHostkeyToFile((File)new File(LocalFactory.createLocal((String)Preferences.instance().getProperty("ssh.knownhosts")).getAbsolute()), (String[])new String[]{KnownHosts.createHashedHostname((String)hostname)}, (String)serverHostKeyAlgorithm, (byte[])serverHostKey);
            }
            catch (IOException ignore) {
                log.error((Object)ignore.getMessage());
            }
        }
    }
}

