/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Speedometer;
import ch.cyberduck.core.SyncTransfer;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAdapter;
import ch.cyberduck.core.TransferListener;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.CDBundleController;
import ch.cyberduck.ui.cocoa.CDDateFormatter;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDTableCellAttributes;
import ch.cyberduck.ui.cocoa.application.NSColor;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSImage;
import ch.cyberduck.ui.cocoa.application.NSImageView;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSProgressIndicator;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.delegate.MenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.TransferMenuDelegate;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;

public class CDProgressController
extends CDBundleController {
    private static Logger log = Logger.getLogger(CDProgressController.class);
    private Transfer transfer;
    private Speedometer meter;
    private String messageText;
    private ProgressListener pl;
    private TransferListener tl;
    private static final NSDictionary NORMAL_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSFont.systemFontOfSize(NSFont.smallSystemFontSize()), CDTableCellAttributes.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL), NSArray.arrayWithObjects("NSFont", "NSParagraphStyle"));
    private static final NSDictionary HIGHLIGHTED_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSFont.systemFontOfSize(NSFont.smallSystemFontSize()), NSColor.whiteColor(), CDTableCellAttributes.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL), NSArray.arrayWithObjects("NSFont", "NSColor", "NSParagraphStyle"));
    private static final NSDictionary DARK_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSFont.systemFontOfSize(NSFont.smallSystemFontSize()), NSColor.darkGrayColor(), CDTableCellAttributes.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL), NSArray.arrayWithObjects("NSFont", "NSColor", "NSParagraphStyle"));
    private NSPopUpButton filesPopup;
    private MenuDelegate filesPopupMenuDelegate;
    private NSTextField progressField;
    private NSTextField statusField;
    private NSTextField messageField;
    private NSProgressIndicator progressBar;
    private NSImageView statusIconView;
    private static final NSImage RED_ICON = CDIconCache.iconNamed("statusRed.tiff");
    private static final NSImage GREEN_ICON = CDIconCache.iconNamed("statusGreen.tiff");
    private static final NSImage YELLOW_ICON = CDIconCache.iconNamed("statusYellow.tiff");
    private NSImageView iconImageView;
    private NSView progressView;

    public CDProgressController(Transfer transfer) {
        this.transfer = transfer;
        this.meter = new Speedometer(transfer);
        this.init();
    }

    protected void invalidate() {
        this.transfer.getSession().removeProgressListener(this.pl);
        this.transfer.removeListener(this.tl);
        this.filesPopup.menu().setDelegate(null);
        super.invalidate();
    }

    protected String getBundleName() {
        return "Progress.nib";
    }

    private void init() {
        this.loadBundle();
        this.pl = new ProgressListener(){

            public void message(String message) {
                CDProgressController.this.messageText = message;
                CDProgressController.this.invoke((MainAction)new DefaultMainAction(){

                    public void run() {
                        CDProgressController.this.setMessageText();
                    }
                });
            }
        };
        this.transfer.getSession().addProgressListener(this.pl);
        this.tl = new TransferAdapter(){
            private Timer progressTimer;
            final long delay = 0L;
            final long period = 500L;

            public void transferWillStart() {
                CDProgressController.this.invoke((MainAction)new DefaultMainAction(){

                    public void run() {
                        CDProgressController.this.progressBar.setIndeterminate(true);
                        CDProgressController.this.progressBar.startAnimation(null);
                        CDProgressController.this.statusIconView.setImage(YELLOW_ICON);
                        CDProgressController.this.setProgressText();
                        CDProgressController.this.setStatusText();
                    }
                });
            }

            public void transferDidEnd() {
                CDProgressController.this.invoke((MainAction)new DefaultMainAction(){

                    public void run() {
                        CDProgressController.this.progressBar.stopAnimation(null);
                        CDProgressController.this.progressBar.setIndeterminate(true);
                        CDProgressController.this.messageText = null;
                        Date timestamp = CDProgressController.this.transfer.getTimestamp();
                        if (null != timestamp) {
                            CDProgressController.this.messageText = CDDateFormatter.getLongFormat(timestamp.getTime());
                        }
                        CDProgressController.this.setMessageText();
                        CDProgressController.this.setProgressText();
                        CDProgressController.this.setStatusText();
                        CDProgressController.this.statusIconView.setImage(CDProgressController.this.transfer.isComplete() ? GREEN_ICON : RED_ICON);
                        CDProgressController.this.filesPopup.itemAtIndex(0).setEnabled(CDProgressController.this.transfer.getRoot().getLocal().exists());
                    }
                });
            }

            public void willTransferPath(Path path) {
                CDProgressController.this.meter.reset();
                this.progressTimer = new Timer();
                this.progressTimer.scheduleAtFixedRate(new TimerTask(){

                    public void run() {
                        CDProgressController.this.invoke((MainAction)new DefaultMainAction(){

                            public void run() {
                                CDProgressController.this.setProgressText();
                                double transferred = CDProgressController.this.transfer.getTransferred();
                                if (transferred > 0.0) {
                                    CDProgressController.this.progressBar.setIndeterminate(false);
                                }
                                CDProgressController.this.progressBar.setMaxValue(CDProgressController.this.transfer.getSize());
                                CDProgressController.this.progressBar.setDoubleValue(transferred);
                            }
                        });
                    }
                }, 0L, 500L);
            }

            public void didTransferPath(Path path) {
                this.progressTimer.cancel();
                CDProgressController.this.meter.reset();
            }

            public void bandwidthChanged(BandwidthThrottle bandwidth) {
                CDProgressController.this.meter.reset();
            }
        };
        this.transfer.addListener(this.tl);
    }

    public void awakeFromNib() {
        this.setProgressText();
        this.setMessageText();
        this.setStatusText();
        super.awakeFromNib();
    }

    private void setMessageText() {
        StringBuffer b = new StringBuffer();
        if (this.messageText != null) {
            b.append(this.messageText);
        }
        this.messageField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(b.toString(), TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    private void setProgressText() {
        this.progressField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(this.meter.getProgress(), TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    private void setStatusText() {
        StringBuffer b = new StringBuffer();
        if (!this.transfer.isRunning()) {
            if (this.transfer instanceof DownloadTransfer) {
                b.append(this.transfer.isComplete() ? Locale.localizedString((String)"Download complete", (String)"Growl") : Locale.localizedString((String)"Transfer incomplete", (String)"Status"));
            }
            if (this.transfer instanceof UploadTransfer) {
                b.append(this.transfer.isComplete() ? Locale.localizedString((String)"Upload complete", (String)"Growl") : Locale.localizedString((String)"Transfer incomplete", (String)"Status"));
            }
            if (this.transfer instanceof SyncTransfer) {
                b.append(this.transfer.isComplete() ? Locale.localizedString((String)"Synchronization complete", (String)"Growl") : Locale.localizedString((String)"Transfer incomplete", (String)"Status"));
            }
        }
        this.statusField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(b.toString(), TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    public void setHighlighted(boolean highlighted) {
        this.statusField.setTextColor(highlighted ? NSColor.whiteColor() : NSColor.textColor());
        this.progressField.setTextColor(highlighted ? NSColor.whiteColor() : NSColor.darkGrayColor());
        this.messageField.setTextColor(highlighted ? NSColor.whiteColor() : NSColor.darkGrayColor());
        if (this.transfer.getRoot().getLocal().exists()) {
            this.filesPopup.itemAtIndex(0).setAttributedTitle(NSAttributedString.attributedStringWithAttributes(this.filesPopup.itemAtIndex(0).title(), highlighted ? HIGHLIGHTED_FONT_ATTRIBUTES : NORMAL_FONT_ATTRIBUTES));
        } else {
            this.filesPopup.itemAtIndex(0).setAttributedTitle(NSAttributedString.attributedStringWithAttributes(this.filesPopup.itemAtIndex(0).title(), highlighted ? HIGHLIGHTED_FONT_ATTRIBUTES : DARK_FONT_ATTRIBUTES));
        }
    }

    public void setFilesPopup(NSPopUpButton filesPopup) {
        this.filesPopup = filesPopup;
        this.filesPopup.setTarget(this.id());
        this.filesPopup.removeAllItems();
        Path path = this.transfer.getRoot();
        NSMenuItem item = this.filesPopup.menu().addItemWithTitle_action_keyEquivalent(path.getName(), Foundation.selector("reveal:"), "");
        item.setRepresentedObject(path.getAbsolute());
        item.setImage(CDIconCache.instance().iconForPath(path, (Integer)16));
        item.setEnabled(path.getLocal().exists());
        this.filesPopupMenuDelegate = new TransferMenuDelegate(this.transfer.getRoots());
        this.filesPopup.menu().setDelegate(this.filesPopupMenuDelegate.id());
    }

    public void setProgressField(NSTextField progressField) {
        this.progressField = progressField;
        this.progressField.setEditable(false);
        this.progressField.setSelectable(false);
        this.progressField.setTextColor(NSColor.darkGrayColor());
    }

    public void setStatusField(NSTextField statusField) {
        this.statusField = statusField;
        this.statusField.setEditable(false);
        this.statusField.setSelectable(false);
        this.statusField.setTextColor(NSColor.darkGrayColor());
    }

    public void setMessageField(NSTextField messageField) {
        this.messageField = messageField;
        this.messageField.setEditable(false);
        this.messageField.setSelectable(false);
        this.messageField.setTextColor(NSColor.darkGrayColor());
    }

    public void setProgressBar(NSProgressIndicator progressBar) {
        this.progressBar = progressBar;
        this.progressBar.setDisplayedWhenStopped(false);
        this.progressBar.setUsesThreadedAnimation(true);
        this.progressBar.setControlSize(1);
        this.progressBar.setStyle(0);
        this.progressBar.setMinValue(0.0);
    }

    public void setStatusIconView(NSImageView statusIconView) {
        this.statusIconView = statusIconView;
        this.statusIconView.setImage(this.transfer.isComplete() ? GREEN_ICON : RED_ICON);
    }

    public void setIconImageView(NSImageView iconImageView) {
        this.iconImageView = iconImageView;
        if (this.transfer instanceof DownloadTransfer) {
            iconImageView.setImage(CDIconCache.iconNamed("arrowDown", 32));
        } else if (this.transfer instanceof UploadTransfer) {
            iconImageView.setImage(CDIconCache.iconNamed("arrowUp", 32));
        } else if (this.transfer instanceof SyncTransfer) {
            iconImageView.setImage(CDIconCache.iconNamed("sync", 32));
        }
    }

    public void setProgressView(NSView v) {
        this.progressView = v;
    }

    public NSView view() {
        return this.progressView;
    }
}

