/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Queue;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SyncTransfer;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAdapter;
import ch.cyberduck.core.TransferCollection;
import ch.cyberduck.core.TransferListener;
import ch.cyberduck.core.TransferOptions;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.CDAbstractTableDelegate;
import ch.cyberduck.ui.cocoa.CDControllerCell;
import ch.cyberduck.ui.cocoa.CDHostKeyController;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDLoginController;
import ch.cyberduck.ui.cocoa.CDSheetCallback;
import ch.cyberduck.ui.cocoa.CDTranscriptController;
import ch.cyberduck.ui.cocoa.CDTransferPrompt;
import ch.cyberduck.ui.cocoa.CDTransferTableDataSource;
import ch.cyberduck.ui.cocoa.CDWindowController;
import ch.cyberduck.ui.cocoa.PathPasteboard;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSCell;
import ch.cyberduck.ui.cocoa.application.NSDrawer;
import ch.cyberduck.ui.cocoa.application.NSImageView;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSStepper;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSToolbar;
import ch.cyberduck.ui.cocoa.application.NSToolbarItem;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.delegate.MenuDelegate;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSIndexSet;
import ch.cyberduck.ui.cocoa.foundation.NSMutableAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.threading.AlertRepeatableBackgroundAction;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;
import ch.cyberduck.ui.cocoa.util.HyperlinkAttributedStringFactory;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.Selector;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

public class CDTransferController
extends CDWindowController
implements NSToolbar.Delegate {
    private static Logger log = Logger.getLogger(CDTransferController.class);
    private static CDTransferController instance = null;
    private NSToolbar toolbar;
    private NSTextField urlField;
    private NSTextField localField;
    private NSImageView iconView;
    private NSStepper queueSizeStepper;
    private NSTextField filterField;
    private CDTranscriptController transcript;
    private NSDrawer logDrawer;
    private NSPopUpButton bandwidthPopup;
    private MenuDelegate bandwidthPopupDelegate;
    private final TableColumnFactory tableColumnsFactory = new TableColumnFactory();
    private CDTransferTableDataSource transferModel;
    private NSTableView transferTable;
    private CDAbstractTableDelegate<Transfer> delegate;
    private final NSCell prototype = CDControllerCell.controllerCell();
    private static final String TOOLBAR_RESUME = "Resume";
    private static final String TOOLBAR_RELOAD = "Reload";
    private static final String TOOLBAR_STOP = "Stop";
    private static final String TOOLBAR_REMOVE = "Remove";
    private static final String TOOLBAR_CLEAN_UP = "Clean Up";
    private static final String TOOLBAR_OPEN = "Open";
    private static final String TOOLBAR_SHOW = "Show";
    private static final String TOOLBAR_TRASH = "Trash";
    private static final String TOOLBAR_FILTER = "Search";
    private Map<String, NSToolbarItem> toolbarItems = new HashMap<String, NSToolbarItem>();

    public void awakeFromNib() {
        this.toolbar = NSToolbar.toolbarWithIdentifier("Queue Toolbar");
        this.toolbar.setDelegate(this.id());
        this.toolbar.setAllowsUserCustomization(true);
        this.toolbar.setAutosavesConfiguration(true);
        this.window.setToolbar(this.toolbar);
        super.awakeFromNib();
    }

    public void setWindow(NSWindow window) {
        window.setMovableByWindowBackground(true);
        window.setTitle(Locale.localizedString((String)"Transfers"));
        window.setDelegate(this.id());
        super.setWindow(window);
    }

    public boolean isSingleton() {
        return true;
    }

    public void windowDidBecomeKey(NSNotification notification) {
        this.updateHighlight();
    }

    public void windowDidResignKey(NSNotification notification) {
        this.updateHighlight();
    }

    public void setUrlField(NSTextField urlField) {
        this.urlField = urlField;
        this.urlField.setAllowsEditingTextAttributes(true);
        this.urlField.setSelectable(true);
    }

    public void setLocalField(NSTextField localField) {
        this.localField = localField;
    }

    public void setIconView(NSImageView iconView) {
        this.iconView = iconView;
    }

    public void setQueueSizeStepper(NSStepper queueSizeStepper) {
        this.queueSizeStepper = queueSizeStepper;
        this.queueSizeStepper.setTarget(this.id());
        this.queueSizeStepper.setAction(Foundation.selector("queueSizeStepperChanged:"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueSizeStepperChanged(ID sender) {
        Queue queue = Queue.instance();
        synchronized (queue) {
            Queue.instance().notify();
        }
    }

    public void setFilterField(NSTextField filterField) {
        this.filterField = filterField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("filterFieldTextDidChange:"), "NSControlTextDidChangeNotification", this.filterField);
    }

    public void filterFieldTextDidChange(NSNotification notification) {
        this.transferModel.setFilter(this.filterField.stringValue());
        this.reloadData();
    }

    public void searchButtonClicked(ID sender) {
        this.window().makeFirstResponder(this.filterField);
    }

    public void drawerWillOpen(NSNotification notification) {
        this.logDrawer.setContentSize(new NSSize(this.logDrawer.contentSize().width.doubleValue(), Preferences.instance().getDouble("queue.logDrawer.size.height")));
    }

    public void drawerDidOpen(NSNotification notification) {
        Preferences.instance().setProperty("queue.logDrawer.isOpen", true);
    }

    public void drawerWillClose(NSNotification notification) {
        Preferences.instance().setProperty("queue.logDrawer.size.height", this.logDrawer.contentSize().height.doubleValue());
    }

    public void drawerDidClose(NSNotification notification) {
        Preferences.instance().setProperty("queue.logDrawer.isOpen", false);
    }

    public void setLogDrawer(NSDrawer logDrawer) {
        this.logDrawer = logDrawer;
        this.transcript = new CDTranscriptController();
        this.logDrawer.setContentView(this.transcript.getLogView());
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerWillOpen:"), "NSDrawerWillOpenNotification", this.logDrawer);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerDidOpen:"), "NSDrawerDidOpenNotification", this.logDrawer);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerWillClose:"), "NSDrawerWillCloseNotification", this.logDrawer);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerDidClose:"), "NSDrawerDidCloseNotification", this.logDrawer);
    }

    public void toggleLogDrawer(ID sender) {
        this.logDrawer.toggle(sender);
    }

    public void setBandwidthPopup(NSPopUpButton bandwidthPopup) {
        this.bandwidthPopup = bandwidthPopup;
        this.bandwidthPopup.setEnabled(false);
        this.bandwidthPopup.setAllowsMixedState(true);
        this.bandwidthPopup.setTarget(this.id());
        this.bandwidthPopup.setAction(Foundation.selector("bandwidthPopupChanged:"));
        this.bandwidthPopup.itemAtIndex(0).setImage(CDIconCache.iconNamed("bandwidth", 16));
        this.bandwidthPopupDelegate = new BandwidthDelegate();
        this.bandwidthPopup.menu().setDelegate(this.bandwidthPopupDelegate.id());
    }

    public void bandwidthPopupChanged(NSPopUpButton sender) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        int bandwidth = -1;
        if (sender.selectedItem().tag() > 0) {
            bandwidth = sender.selectedItem().tag() * 1024;
        }
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)TransferCollection.instance().get(index.intValue());
            transfer.setBandwidth((float)bandwidth);
            index = iterator.indexGreaterThanIndex(index);
        }
        this.updateBandwidthPopup();
    }

    private CDTransferController() {
        this.loadBundle();
        this.background((BackgroundAction)new AbstractBackgroundAction(){

            public void run() {
                TransferCollection.instance().load();
            }

            public void cleanup() {
                CDTransferController.this.transferTable.reloadData();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CDTransferController instance() {
        NSApplication nSApplication = NSApplication.sharedApplication();
        synchronized (nSApplication) {
            if (null == instance) {
                instance = new CDTransferController();
            }
            return instance;
        }
    }

    protected String getBundleName() {
        return "Transfer";
    }

    protected void invalidate() {
        this.toolbar.setDelegate(null);
        this.toolbarItems.clear();
        this.transferModel.invalidate();
        super.invalidate();
    }

    public static NSUInteger applicationShouldTerminate(final NSApplication app) {
        if (null != instance) {
            Preferences.instance().setProperty("queue.openByDefault", instance.window().isVisible());
            if (TransferCollection.instance().numberOfRunningTransfers() > 0) {
                NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Transfer in progress"), Locale.localizedString((String)"There are files currently being transferred. Quit anyway?"), Locale.localizedString((String)"Quit"), Locale.localizedString((String)"Cancel"), null);
                instance.alert(alert, new CDSheetCallback(){

                    public void callback(int returncode) {
                        if (returncode == 1) {
                            for (int i = 0; i < TransferCollection.instance().size(); ++i) {
                                Transfer transfer = (Transfer)TransferCollection.instance().get(i);
                                if (!transfer.isRunning()) continue;
                                transfer.interrupt();
                            }
                            app.replyToApplicationShouldTerminate(true);
                        }
                        if (returncode == 0) {
                            app.replyToApplicationShouldTerminate(false);
                        }
                    }
                });
                return NSApplication.NSTerminateLater;
            }
        }
        return NSApplication.NSTerminateNow;
    }

    public void setQueueTable(NSTableView view) {
        this.transferTable = view;
        this.transferModel = new CDTransferTableDataSource();
        this.transferTable.setDataSource(this.transferModel.id());
        this.delegate = new CDAbstractTableDelegate<Transfer>(){

            @Override
            public String tooltip(Transfer t) {
                return t.getName();
            }

            @Override
            public void enterKeyPressed(ID sender) {
                this.tableRowDoubleClicked(sender);
            }

            @Override
            public void deleteKeyPressed(ID sender) {
                CDTransferController.this.deleteButtonClicked(sender);
            }

            @Override
            public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
            }

            @Override
            public void tableRowDoubleClicked(ID sender) {
                CDTransferController.this.reloadButtonClicked(sender);
            }

            @Override
            public void selectionIsChanging(NSNotification notification) {
                CDTransferController.this.updateHighlight();
            }

            @Override
            public void selectionDidChange(NSNotification notification) {
                CDTransferController.this.updateHighlight();
                CDTransferController.this.updateSelection();
            }

            public void tableView_willDisplayCell_forTableColumn_row(NSTableView view, NSCell cell, NSTableColumn tableColumn, NSInteger row) {
                Rococoa.cast(cell, CDControllerCell.class).setView(CDTransferController.this.transferModel.getController(row.intValue()).view());
            }
        };
        this.transferTable.setDelegate(this.delegate.id());
        this.transferTable.registerForDraggedTypes(NSArray.arrayWithObjects("NSStringPboardType", "Apple files promise pasteboard type"));
        NSTableColumn c = this.tableColumnsFactory.create("PROGRESS");
        c.setMinWidth(80.0);
        c.setWidth(300.0);
        c.setResizingMask(1);
        c.setDataCell(this.prototype);
        this.transferTable.addTableColumn(c);
        this.transferTable.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
        this.transferTable.setRowHeight(new CGFloat(82.0));
        this.transferTable.setAllowsMultipleSelection(true);
        this.transferTable.setAllowsEmptySelection(true);
        this.transferTable.setAllowsColumnReordering(false);
        this.transferTable.sizeToFit();
    }

    private void updateHighlight() {
        boolean isKeyWindow = this.window().isKeyWindow();
        for (int i = 0; i < this.transferModel.getSource().size(); ++i) {
            this.transferModel.setHighlighted(i, this.transferTable.isRowSelected(new NSInteger(i)) && isKeyWindow);
        }
    }

    private void updateSelection() {
        log.debug((Object)"updateSelection");
        this.updateLabels();
        this.updateIcon();
        this.updateBandwidthPopup();
        this.toolbar.validateVisibleItems();
    }

    private void updateLabels() {
        log.debug((Object)"updateLabels");
        int selected = this.transferTable.numberOfSelectedRows().intValue();
        if (1 == selected) {
            Transfer transfer = (Transfer)this.transferModel.getSource().get(this.transferTable.selectedRow().intValue());
            String url = transfer.getRoot().toURL();
            this.urlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(url, TRUNCATE_MIDDLE_ATTRIBUTES), url));
            if (transfer.numberOfRoots() == 1) {
                this.localField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(transfer.getRoot().getLocal().getAbsolute(), TRUNCATE_MIDDLE_ATTRIBUTES));
            } else {
                this.localField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(Locale.localizedString((String)"Multiple files"), TRUNCATE_MIDDLE_ATTRIBUTES));
            }
        } else {
            this.urlField.setStringValue("");
            this.localField.setStringValue("");
        }
    }

    private void updateIcon() {
        log.debug((Object)"updateIcon");
        int selected = this.transferTable.numberOfSelectedRows().intValue();
        if (1 != selected) {
            this.iconView.setImage(null);
            return;
        }
        Transfer transfer = (Transfer)this.transferModel.getSource().get(this.transferTable.selectedRow().intValue());
        if (transfer.numberOfRoots() == 1) {
            this.iconView.setImage(CDIconCache.instance().iconForPath(transfer.getRoot().getLocal(), (Integer)32));
        } else {
            this.iconView.setImage(CDIconCache.iconNamed("multipleDocuments", 32));
        }
    }

    private void updateBandwidthPopup() {
        log.debug((Object)"updateBandwidthPopup");
        int selected = this.transferTable.numberOfSelectedRows().intValue();
        this.bandwidthPopup.setEnabled(selected > 0);
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)this.transferModel.getSource().get(index.intValue());
            if (transfer instanceof SyncTransfer) {
                this.bandwidthPopup.setEnabled(false);
                break;
            }
            if (transfer.getBandwidth() != -1.0f) {
                this.bandwidthPopup.itemAtIndex(0).setImage(CDIconCache.iconNamed("turtle.tiff"));
                return;
            }
            index = iterator.indexGreaterThanIndex(index);
        }
        this.bandwidthPopup.itemAtIndex(0).setImage(CDIconCache.iconNamed("bandwidth", 16));
    }

    private void reloadData() {
        while (this.transferTable.subviews().count().intValue() > 0) {
            Rococoa.cast(this.transferTable.subviews().lastObject(), NSView.class).removeFromSuperviewWithoutNeedingDisplay();
        }
        this.transferTable.reloadData();
        this.updateHighlight();
    }

    public void removeTransfer(Transfer transfer) {
        TransferCollection.instance().remove((Object)transfer);
        this.reloadData();
    }

    public void addTransfer(Transfer transfer) {
        TransferCollection.instance().add(transfer);
        int row = TransferCollection.instance().size() - 1;
        this.reloadData();
        NSInteger index = new NSInteger(row);
        this.transferTable.selectRowIndexes(NSIndexSet.indexSetWithIndex(index), false);
        this.transferTable.scrollRowToVisible(index);
    }

    public void startTransfer(Transfer transfer) {
        this.startTransfer(transfer, false, false);
    }

    private void startTransfer(final Transfer transfer, final boolean resumeRequested, final boolean reloadRequested) {
        if (!TransferCollection.instance().contains((Object)transfer)) {
            this.addTransfer(transfer);
        }
        if (Preferences.instance().getBoolean("queue.orderFrontOnStart")) {
            this.window.makeKeyAndOrderFront(null);
        }
        this.background((BackgroundAction)new AlertRepeatableBackgroundAction(this){
            private boolean resume;
            private boolean reload;
            private TransferListener tl;
            private final Object lock;
            {
                super(x0);
                this.resume = resumeRequested;
                this.reload = reloadRequested;
                this.lock = new Object();
            }

            public boolean prepare() {
                this.tl = new TransferAdapter(){

                    public void transferQueued() {
                        CDTransferController.this.validateToolbar();
                    }

                    public void transferResumed() {
                        CDTransferController.this.validateToolbar();
                    }

                    public void transferWillStart() {
                        CDTransferController.this.validateToolbar();
                    }

                    public void transferDidEnd() {
                        CDTransferController.this.validateToolbar();
                    }
                };
                transfer.addListener(this.tl);
                if (transfer.getSession() instanceof SFTPSession) {
                    ((SFTPSession)transfer.getSession()).setHostKeyVerificationController((ServerHostKeyVerifier)new CDHostKeyController(CDTransferController.this));
                }
                transfer.getSession().setLoginController((LoginController)new CDLoginController(CDTransferController.this));
                return super.prepare();
            }

            public void run() {
                TransferOptions options = new TransferOptions();
                options.reloadRequested = this.reload;
                options.resumeRequested = this.resume;
                transfer.start(CDTransferPrompt.create(CDTransferController.this, transfer), options);
            }

            public void finish() {
                super.finish();
                if (transfer.getSession() instanceof SFTPSession) {
                    ((SFTPSession)transfer.getSession()).setHostKeyVerificationController(null);
                }
                transfer.getSession().setLoginController(null);
                transfer.removeListener(this.tl);
            }

            public void cleanup() {
                if (transfer.isComplete() && !transfer.isCanceled() && transfer.isReset()) {
                    if (Preferences.instance().getBoolean("queue.removeItemWhenComplete")) {
                        CDTransferController.this.removeTransfer(transfer);
                    }
                    if (Preferences.instance().getBoolean("queue.orderBackOnStop") && TransferCollection.instance().numberOfRunningTransfers() <= 0) {
                        CDTransferController.this.window().close();
                    }
                }
                this.reload = false;
                this.resume = true;
                TransferCollection.instance().save();
            }

            public Session getSession() {
                return transfer.getSession();
            }

            public void pause() {
                transfer.fireTransferQueued();
                super.pause();
                transfer.fireTransferResumed();
            }

            public boolean isCanceled() {
                if ((transfer.isRunning() || transfer.isQueued()) && transfer.isCanceled()) {
                    return true;
                }
                return super.isCanceled();
            }

            public void log(final boolean request, final String message) {
                if (CDTransferController.this.logDrawer.state() == 2) {
                    CDTransferController.this.invoke((MainAction)new WindowMainAction(CDTransferController.this){

                        public void run() {
                            CDTransferController.this.transcript.log(request, message);
                        }
                    });
                }
                super.log(request, message);
            }

            public Object lock() {
                return this.lock;
            }
        });
    }

    private void validateToolbar() {
        this.invoke((MainAction)new WindowMainAction(this){

            public void run() {
                CDTransferController.this.window.toolbar().validateVisibleItems();
                CDTransferController.this.updateIcon();
            }
        });
    }

    public NSToolbarItem toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(NSToolbar toolbar, String itemIdentifier, boolean flag) {
        if (!this.toolbarItems.containsKey(itemIdentifier)) {
            this.toolbarItems.put(itemIdentifier, NSToolbarItem.itemWithIdentifier(itemIdentifier));
        }
        NSToolbarItem item = this.toolbarItems.get(itemIdentifier);
        if (itemIdentifier.equals(TOOLBAR_STOP)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_STOP));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_STOP));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_STOP));
            item.setImage(CDIconCache.iconNamed("stop", 32));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("stopButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_RESUME)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_RESUME));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_RESUME));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_RESUME));
            item.setImage(CDIconCache.iconNamed("resume.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("resumeButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_RELOAD)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_RELOAD));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_RELOAD));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_RELOAD));
            item.setImage(CDIconCache.iconNamed("reload.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("reloadButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_SHOW)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_SHOW));
            item.setPaletteLabel(Locale.localizedString((String)"Show in Finder"));
            item.setToolTip(Locale.localizedString((String)"Show in Finder"));
            item.setImage(CDIconCache.iconNamed("reveal.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("revealButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_OPEN)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_OPEN));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_OPEN));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_OPEN));
            item.setImage(CDIconCache.iconNamed("open.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("openButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_REMOVE)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_REMOVE));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_REMOVE));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_REMOVE));
            item.setImage(CDIconCache.iconNamed("clean.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("deleteButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_CLEAN_UP)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_CLEAN_UP));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_CLEAN_UP));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_CLEAN_UP));
            item.setImage(CDIconCache.iconNamed("cleanAll.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("clearButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_TRASH)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_TRASH));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_TRASH));
            item.setToolTip(Locale.localizedString((String)"Move to Trash"));
            item.setImage(CDIconCache.iconNamed("trash.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("trashButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_FILTER)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_FILTER));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_FILTER));
            item.setView(this.filterField);
            item.setMinSize(this.filterField.frame().size);
            item.setMaxSize(this.filterField.frame().size);
            return item;
        }
        return null;
    }

    public void paste(ID sender) {
        log.debug((Object)"paste");
        Map<Host, PathPasteboard<NSDictionary>> boards = PathPasteboard.allPasteboards();
        if (!boards.isEmpty()) {
            for (PathPasteboard<NSDictionary> pasteboard : boards.values()) {
                TransferCollection.instance().add((Transfer)new DownloadTransfer(pasteboard.getFiles()));
            }
            this.reloadData();
        }
        boards.clear();
    }

    public void stopButtonClicked(ID sender) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            final Transfer transfer = (Transfer)this.transferModel.getSource().get(index.intValue());
            if (transfer.isRunning() || transfer.isQueued()) {
                this.background((BackgroundAction)new AbstractBackgroundAction(){

                    public void run() {
                        transfer.cancel();
                    }

                    public void cleanup() {
                    }
                });
            }
            index = iterator.indexGreaterThanIndex(index);
        }
    }

    public void stopAllButtonClicked(ID sender) {
        Collection<Transfer> transfers = this.transferModel.getSource();
        for (final Transfer transfer : transfers) {
            if (!transfer.isRunning() && !transfer.isQueued()) continue;
            this.background((BackgroundAction)new AbstractBackgroundAction(){

                public void run() {
                    transfer.cancel();
                }

                public void cleanup() {
                }
            });
        }
    }

    public void resumeButtonClicked(ID sender) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Collection<Transfer> transfers = this.transferModel.getSource();
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            if (!transfer.isRunning() && !transfer.isQueued()) {
                this.startTransfer(transfer, true, false);
            }
            index = iterator.indexGreaterThanIndex(index);
        }
    }

    public void reloadButtonClicked(ID sender) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Collection<Transfer> transfers = this.transferModel.getSource();
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            if (!transfer.isRunning() && !transfer.isQueued()) {
                this.startTransfer(transfer, false, true);
            }
            index = iterator.indexGreaterThanIndex(index);
        }
    }

    public void openButtonClicked(ID sender) {
        if (this.transferTable.numberOfSelectedRows().intValue() == 1) {
            Transfer transfer = (Transfer)this.transferModel.getSource().get(this.transferTable.selectedRow().intValue());
            for (Path i : transfer.getRoots()) {
                Local l = i.getLocal();
                if (NSWorkspace.sharedWorkspace().openFile(l.getAbsolute())) continue;
                if (transfer.isComplete()) {
                    this.alert(NSAlert.alert(Locale.localizedString((String)"Could not open the file"), Locale.localizedString((String)"Could not open the file") + " \"" + l.getName() + "\". " + Locale.localizedString((String)"It moved since you downloaded it."), Locale.localizedString((String)"OK"), null, null));
                    continue;
                }
                this.alert(NSAlert.alert(Locale.localizedString((String)"Could not open the file"), Locale.localizedString((String)"Could not open the file") + " \"" + l.getName() + "\". " + Locale.localizedString((String)"The file has not yet been downloaded."), Locale.localizedString((String)"OK"), null, null));
            }
        }
    }

    public void revealButtonClicked(ID sender) {
        if (this.transferTable.numberOfSelectedRows().intValue() == 1) {
            Transfer transfer = (Transfer)this.transferModel.getSource().get(this.transferTable.selectedRow().intValue());
            for (Path i : transfer.getRoots()) {
                Local l = i.getLocal();
                if (NSWorkspace.sharedWorkspace().selectFile(l.getAbsolute(), l.getParent().getAbsolute())) break;
                if (transfer.isComplete()) {
                    this.alert(NSAlert.alert(Locale.localizedString((String)"Could not show the file in the Finder"), Locale.localizedString((String)"Could not show the file") + " \"" + l.getName() + "\". " + Locale.localizedString((String)"It moved since you downloaded it."), Locale.localizedString((String)"OK"), null, null));
                    continue;
                }
                this.alert(NSAlert.alert(Locale.localizedString((String)"Could not show the file in the Finder"), Locale.localizedString((String)"Could not show the file") + " \"" + l.getName() + "\". " + Locale.localizedString((String)"The file has not yet been downloaded."), Locale.localizedString((String)"OK"), null, null));
            }
        }
    }

    public void deleteButtonClicked(ID sender) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        Collection<Transfer> transfers = this.transferModel.getSource();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            if (!transfer.isRunning() && !transfer.isQueued()) {
                TransferCollection.instance().remove((Object)transfer);
            }
            index = iterator.indexGreaterThanIndex(index);
        }
        TransferCollection.instance().save();
        this.reloadData();
    }

    public void clearButtonClicked(ID sender) {
        Collection<Transfer> transfers = this.transferModel.getSource();
        for (Transfer transfer : transfers) {
            if (transfer.isRunning() || transfer.isQueued() || !transfer.isComplete()) continue;
            TransferCollection.instance().remove((Object)transfer);
        }
        TransferCollection.instance().save();
        this.reloadData();
    }

    public void trashButtonClicked(ID sender) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        Collection<Transfer> transfers = this.transferModel.getSource();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            if (!transfer.isRunning() && !transfer.isQueued()) {
                for (Path path : transfer.getRoots()) {
                    path.getLocal().delete();
                }
            }
            index = iterator.indexGreaterThanIndex(index);
        }
        this.updateIcon();
    }

    public NSArray toolbarDefaultItemIdentifiers(NSToolbar toolbar) {
        return NSArray.arrayWithObjects(TOOLBAR_RESUME, TOOLBAR_RELOAD, TOOLBAR_STOP, TOOLBAR_REMOVE, "NSToolbarFlexibleSpaceItem", TOOLBAR_OPEN, TOOLBAR_SHOW, TOOLBAR_FILTER);
    }

    public NSArray toolbarAllowedItemIdentifiers(NSToolbar toolbar) {
        return NSArray.arrayWithObjects(TOOLBAR_RESUME, TOOLBAR_RELOAD, TOOLBAR_STOP, TOOLBAR_REMOVE, TOOLBAR_CLEAN_UP, TOOLBAR_SHOW, TOOLBAR_OPEN, TOOLBAR_TRASH, TOOLBAR_FILTER, "NSToolbarCustomizeToolbarItem", "NSToolbarSpaceItem", "NSToolbarSeparatorItem", "NSToolbarFlexibleSpaceItem");
    }

    public NSArray toolbarSelectableItemIdentifiers(NSToolbar toolbar) {
        return NSArray.array();
    }

    public boolean validateMenuItem(NSMenuItem item) {
        Selector action = item.action();
        if (action.equals((Object)Foundation.selector("paste:"))) {
            Map<Host, PathPasteboard<NSDictionary>> boards = PathPasteboard.allPasteboards();
            if (!boards.isEmpty() && boards.size() == 1) {
                for (PathPasteboard<NSDictionary> pasteboard : boards.values()) {
                    if (pasteboard.size() == 1) {
                        item.setTitle(Locale.localizedString((String)"Paste") + " \"" + pasteboard.getFiles().get(0).getName() + "\"");
                        continue;
                    }
                    item.setTitle(Locale.localizedString((String)"Paste") + " (" + pasteboard.size() + " " + Locale.localizedString((String)"files") + ")");
                }
            } else {
                item.setTitle(Locale.localizedString((String)"Paste"));
            }
        }
        return this.validateItem(action);
    }

    public boolean validateToolbarItem(NSToolbarItem item) {
        return this.validateItem(item.action());
    }

    private boolean validateItem(Selector action) {
        if (action.equals((Object)Foundation.selector("paste:"))) {
            return !PathPasteboard.allPasteboards().isEmpty();
        }
        if (action.equals((Object)Foundation.selector("stopButtonClicked:"))) {
            return this.validate(new TransferToolbarValidator(){

                public boolean validate(Transfer transfer) {
                    return transfer.isRunning() || transfer.isQueued();
                }
            });
        }
        if (action.equals((Object)Foundation.selector("reloadButtonClicked:")) || action.equals((Object)Foundation.selector("deleteButtonClicked:"))) {
            return this.validate(new TransferToolbarValidator(){

                public boolean validate(Transfer transfer) {
                    return !transfer.isRunning() && !transfer.isQueued();
                }
            });
        }
        if (action.equals((Object)Foundation.selector("resumeButtonClicked:"))) {
            return this.validate(new TransferToolbarValidator(){

                public boolean validate(Transfer transfer) {
                    if (transfer.isRunning() || transfer.isQueued()) {
                        return false;
                    }
                    return transfer.isResumable();
                }
            });
        }
        if (action.equals((Object)Foundation.selector("openButtonClicked:")) || action.equals((Object)Foundation.selector("trashButtonClicked:"))) {
            return this.validate(new TransferToolbarValidator(){

                public boolean validate(Transfer transfer) {
                    if (!transfer.isRunning()) {
                        for (Path i : transfer.getRoots()) {
                            if (!i.getLocal().exists()) continue;
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
        if (action.equals((Object)Foundation.selector("revealButtonClicked:"))) {
            return this.validate(new TransferToolbarValidator(){

                public boolean validate(Transfer transfer) {
                    for (Path i : transfer.getRoots()) {
                        if (!i.getLocal().exists()) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        if (action.equals((Object)Foundation.selector("clearButtonClicked:"))) {
            return this.transferTable.numberOfRows().intValue() > 0;
        }
        return true;
    }

    private boolean validate(TransferToolbarValidator v) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        Collection<Transfer> transfers = this.transferModel.getSource();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            if (v.validate(transfer)) {
                return true;
            }
            index = iterator.indexGreaterThanIndex(index);
        }
        return false;
    }

    private static interface TransferToolbarValidator {
        public boolean validate(Transfer var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableColumnFactory
    extends HashMap<String, NSTableColumn> {
        private TableColumnFactory() {
        }

        private NSTableColumn create(String identifier) {
            if (!this.containsKey(identifier)) {
                this.put(identifier, NSTableColumn.tableColumnWithIdentifier(identifier));
            }
            return (NSTableColumn)this.get(identifier);
        }
    }

    private class BandwidthDelegate
    extends MenuDelegate {
        private BandwidthDelegate() {
        }

        public NSInteger numberOfItemsInMenu(NSMenu menu) {
            return menu.numberOfItems();
        }

        public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger i, boolean shouldCancel) {
            int selected = CDTransferController.this.transferTable.numberOfSelectedRows().intValue();
            int tag = item.tag();
            NSIndexSet iterator = CDTransferController.this.transferTable.selectedRowIndexes();
            NSUInteger index = iterator.firstIndex();
            while (!index.equals((Object)NSIndexSet.NSNotFound)) {
                Transfer transfer = (Transfer)TransferCollection.instance().get(index.intValue());
                if (-1.0f == transfer.getBandwidth()) {
                    if (-1 == tag) {
                        item.setState(selected > 1 ? -1 : 1);
                        break;
                    }
                    item.setState(0);
                } else {
                    int bandwidth = (int)transfer.getBandwidth() / 1024;
                    if (tag == bandwidth) {
                        item.setState(selected > 1 ? -1 : 1);
                        break;
                    }
                    item.setState(0);
                }
                index = iterator.indexGreaterThanIndex(index);
            }
            return !shouldCancel;
        }
    }
}

