/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.delegate.MenuDelegate;
import ch.cyberduck.ui.cocoa.model.CDPathReference;
import java.util.List;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.cocoa.foundation.NSInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PathHistoryMenuDelegate
extends MenuDelegate {
    private static Logger log = Logger.getLogger(PathHistoryMenuDelegate.class);
    protected CDBrowserController controller;

    public PathHistoryMenuDelegate(CDBrowserController controller) {
        this.controller = controller;
    }

    @Override
    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        List<Path> history = this.getHistory();
        if (history.size() > 0) {
            return new NSInteger(history.size() + 2);
        }
        return new NSInteger(0L);
    }

    public abstract List<Path> getHistory();

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem sender, NSInteger index, boolean shouldCancel) {
        List<Path> history = this.getHistory();
        int length = history.size();
        if (index.intValue() < length) {
            Path item = history.get(index.intValue());
            menu.removeItemAtIndex(index);
            NSMenuItem path = menu.insertItemWithTitle_action_keyEquivalent_atIndex(item.getName(), Foundation.selector("pathMenuItemClicked:"), "", index);
            path.setRepresentedObject(item.getAbsolute());
            path.setTarget(this.id());
            path.setEnabled(true);
            path.setImage(CDIconCache.instance().iconForPath(item, (Integer)16));
            return !shouldCancel;
        }
        if (index.intValue() == length) {
            menu.removeItemAtIndex(index);
            menu.insertItem_atIndex(NSMenuItem.separatorItem(), index);
            return !shouldCancel;
        }
        if (index.intValue() == length + 1) {
            menu.removeItemAtIndex(index);
            NSMenuItem clear = menu.insertItemWithTitle_action_keyEquivalent_atIndex(Locale.localizedString((String)"Clear Menu"), Foundation.selector("clearMenuItemClicked:"), "", index);
            clear.setTarget(this.id());
            clear.setEnabled(true);
            return !shouldCancel;
        }
        return true;
    }

    public void pathMenuItemClicked(NSMenuItem sender) {
        this.controller.setWorkdir(this.controller.lookup(new CDPathReference(sender.representedObject())));
    }

    public abstract void clearMenuItemClicked(NSMenuItem var1);
}

