/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Rendezvous;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.cocoa.CDBrowserController;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.CDMainController;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.delegate.MenuDelegate;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.cocoa.foundation.NSInteger;

public class RendezvousMenuDelegate
extends MenuDelegate {
    private static Logger log = Logger.getLogger(RendezvousMenuDelegate.class);

    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        int n = Rendezvous.instance().numberOfServices();
        if (n > 0) {
            return new NSInteger(n);
        }
        return new NSInteger(1L);
    }

    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean shouldCancel) {
        if (Rendezvous.instance().numberOfServices() == 0) {
            item.setTitle(Locale.localizedString((String)"No Bonjour services available"));
            item.setEnabled(false);
            return !shouldCancel;
        }
        String title = Rendezvous.instance().getDisplayedName(index.intValue());
        Host h = Rendezvous.instance().getServiceWithDisplayedName(title);
        item.setTitle(title);
        item.setTarget(this.id());
        item.setEnabled(true);
        item.setImage(CDIconCache.iconNamed(h.getProtocol().icon(), 16));
        item.setAction(Foundation.selector("rendezvousMenuClicked:"));
        item.setRepresentedObject(h.getNickname());
        return !shouldCancel;
    }

    public void rendezvousMenuClicked(NSMenuItem sender) {
        log.debug((Object)("rendezvousMenuClicked:" + sender));
        CDBrowserController controller = CDMainController.newDocument();
        controller.mount(Rendezvous.instance().getServiceWithDisplayedName(sender.representedObject()));
    }
}

