/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.model;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Native;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.CDController;
import ch.cyberduck.ui.cocoa.CDIconCache;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSDate;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSDistributedNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSFileManager;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNumber;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import java.io.File;
import org.apache.log4j.Logger;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSUInteger;

public class CDLocal
extends Local {
    private static Logger log = Logger.getLogger(CDLocal.class);
    private static boolean JNI_LOADED = false;

    public CDLocal(Local parent, String name) {
        super(parent, name);
    }

    public CDLocal(String parent, String name) {
        super(parent, name);
    }

    public CDLocal(String path) {
        super(path);
    }

    public CDLocal(File path) {
        super(path);
    }

    public static void register() {
        LocalFactory.addFactory((Factory.Platform)Factory.NATIVE_PLATFORM, (LocalFactory)new Factory());
    }

    public void setPath(String name) {
        super.setPath(CDLocal.stringByExpandingTildeInPath(name));
    }

    protected void init() {
        if (!CDLocal.loadNative()) {
            return;
        }
        super.init();
    }

    public String getAbbreviatedPath() {
        return CDLocal.stringByAbbreviatingWithTildeInPath(this.getAbsolute());
    }

    private static boolean loadNative() {
        if (!JNI_LOADED) {
            JNI_LOADED = Native.load((String)"Local");
        }
        return JNI_LOADED;
    }

    protected native String kind(String var1);

    public Permission getPermission() {
        try {
            NSDictionary fileAttributes = NSFileManager.defaultManager().fileAttributes(this._impl.getAbsolutePath());
            if (null == fileAttributes) {
                log.error((Object)("No such file:" + this.getAbsolute()));
                return null;
            }
            NSObject object = fileAttributes.objectForKey("NSFilePosixPermissions");
            if (null == object) {
                log.error((Object)("No such file:" + this.getAbsolute()));
                return null;
            }
            NSNumber posix = Rococoa.cast(object, NSNumber.class);
            String posixString = Integer.toString(posix.intValue() & 0xFFFF, 8);
            return new Permission(Integer.parseInt(posixString.substring(posixString.length() - 3)));
        }
        catch (NumberFormatException e) {
            return Permission.EMPTY;
        }
    }

    public void writePermissions(final Permission perm, final boolean recursive) {
        new CDController().invoke((MainAction)new DefaultMainAction(){

            public void run() {
                boolean success = NSFileManager.defaultManager().changeFileAttributes(NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObject(NSNumber.numberWithInt(perm.getOctalNumber())), NSArray.arrayWithObject("NSFilePosixPermissions")), CDLocal.this._impl.getAbsolutePath());
                if (!success) {
                    log.error((Object)("File attribute changed failed:" + CDLocal.this.getAbsolute()));
                }
                if (CDLocal.this.attributes.isDirectory() && recursive) {
                    for (AbstractPath child : CDLocal.this.childs()) {
                        child.writePermissions(perm, recursive);
                    }
                }
            }
        });
    }

    public void writeModificationDate(final long millis) {
        new CDController().invoke((MainAction)new DefaultMainAction(){

            public void run() {
                boolean success = NSFileManager.defaultManager().changeFileAttributes(NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObject(NSDate.dateWithTimeIntervalSince1970(millis / 1000L)), NSArray.arrayWithObject("NSFileModificationDate")), CDLocal.this._impl.getAbsolutePath());
                if (!success) {
                    log.error((Object)("File attribute changed failed:" + CDLocal.this.getAbsolute()));
                }
            }
        });
    }

    public long getCreationDate() {
        NSDictionary fileAttributes = NSFileManager.defaultManager().fileAttributes(this._impl.getAbsolutePath());
        if (null == fileAttributes) {
            log.error((Object)("No such file:" + this.getAbsolute()));
            return -1L;
        }
        NSObject date = fileAttributes.objectForKey("NSFileCreationDate");
        if (null == date) {
            log.error((Object)("No such file:" + this.getAbsolute()));
            return -1L;
        }
        return (long)(Rococoa.cast(date, NSDate.class).timeIntervalSince1970() * 1000.0);
    }

    public void trash() {
        if (this.exists()) {
            final CDLocal file = this;
            new CDController().invoke((MainAction)new DefaultMainAction(){

                public void run() {
                    log.debug((Object)("Move " + file + " to Trash"));
                    if (!NSWorkspace.sharedWorkspace().performFileOperation("recycle", file.getParent().getAbsolute(), "", NSArray.arrayWithObject(file.getName()))) {
                        log.warn((Object)("Failed to move " + file.getAbsolute() + " to Trash"));
                    }
                }
            });
        }
    }

    public void setQuarantine(final String originUrl, final String dataUrl) {
        if (!CDLocal.loadNative()) {
            return;
        }
        new CDController().invoke((MainAction)new DefaultMainAction(){

            public void run() {
                CDLocal.this.setQuarantine(CDLocal.this.getAbsolute(), originUrl, dataUrl);
            }
        });
    }

    private native void setQuarantine(String var1, String var2, String var3);

    public void setWhereFrom(final String dataUrl) {
        if (!CDLocal.loadNative()) {
            return;
        }
        new CDController().invoke((MainAction)new DefaultMainAction(){

            public void run() {
                CDLocal.this.setWhereFrom(CDLocal.this.getAbsolute(), dataUrl);
            }
        });
    }

    private native void setWhereFrom(String var1, String var2);

    public void setIcon(final int progress) {
        if (progress > 9 || progress < -1) {
            log.warn((Object)("Local#setIcon:" + progress));
            return;
        }
        if (Preferences.instance().getBoolean("queue.download.updateIcon")) {
            if (!CDLocal.loadNative()) {
                return;
            }
            String path = this.getAbsolute();
            new CDController().invoke((MainAction)new DefaultMainAction(){

                public void run() {
                    if (-1 == progress) {
                        CDLocal.this.removeResourceFork();
                    } else {
                        NSWorkspace.sharedWorkspace().setIcon_forFile_options(CDIconCache.iconNamed("download" + progress + ".icns"), CDLocal.this.getAbsolute(), new NSUInteger(0L));
                    }
                }
            });
        }
    }

    private void removeResourceFork() {
        this.removeCustomIcon();
    }

    private void removeCustomIcon() {
        this.removeCustomIcon(this.getAbsolute());
    }

    private native void removeCustomIcon(String var1);

    private static String stringByAbbreviatingWithTildeInPath(String string) {
        return NSString.stringByAbbreviatingWithTildeInPath(string);
    }

    private static String stringByExpandingTildeInPath(String string) {
        return NSString.stringByExpandingTildeInPath(string);
    }

    protected native String applicationForExtension(String var1);

    public void open() {
        NSWorkspace.sharedWorkspace().openFile(this.getAbsolute());
    }

    public void bounce() {
        NSDistributedNotificationCenter.defaultCenter().postNotification(NSNotification.notificationWithName("com.apple.DownloadFileFinished", this.getAbsolute()));
    }

    public String toString() {
        return this.toURL();
    }

    public String toURL() {
        return CDLocal.stringByAbbreviatingWithTildeInPath(this.getAbsolute());
    }

    private static class Factory
    extends LocalFactory {
        private Factory() {
        }

        protected Local create(Local parent, String name) {
            return new CDLocal(parent, name);
        }

        protected Local create(String parent, String name) {
            return new CDLocal(parent, name);
        }

        protected Local create(String path) {
            return new CDLocal(path);
        }

        protected Local create(File path) {
            return new CDLocal(path);
        }
    }
}

