/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.quicklook;

import ch.cyberduck.core.Local;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import ch.cyberduck.ui.cocoa.quicklook.AbstractQuickLook;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewItem;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewPanel;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewPanelDataSource;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.rococoa.ID;
import org.rococoa.cocoa.foundation.NSInteger;

public class QuartzQuickLook
extends AbstractQuickLook {
    private static Logger log = Logger.getLogger(QuartzQuickLook.class);
    private Map<Local, QLPreviewItem> previews = new HashMap<Local, QLPreviewItem>();
    private QLPreviewPanelDataSource model = new QLPreviewPanelDataSource(){

        public NSInteger numberOfPreviewItemsInPreviewPanel(QLPreviewPanel panel) {
            return new NSInteger(QuartzQuickLook.this.selected.size());
        }

        public ID previewPanel_previewItemAtIndex(QLPreviewPanel panel, int index) {
            final Local preview = (Local)QuartzQuickLook.this.selected.get(index);
            if (!QuartzQuickLook.this.previews.containsKey(preview)) {
                QLPreviewItem item = new QLPreviewItem(){

                    public NSURL previewItemURL() {
                        return NSURL.fileURLWithPath(preview.getAbsolute());
                    }

                    public String previewItemTitle() {
                        return preview.getName();
                    }
                };
                QuartzQuickLook.this.previews.put(preview, item);
            }
            return ((QLPreviewItem)QuartzQuickLook.this.previews.get(preview)).id();
        }
    };

    protected QuartzQuickLook() {
    }

    public boolean isAvailable() {
        return null != QLPreviewPanel.sharedPreviewPanel();
    }

    public boolean isOpen() {
        return QLPreviewPanel.sharedPreviewPanelExists() && QLPreviewPanel.sharedPreviewPanel().isVisible();
    }

    public void willBeginQuickLook() {
        QLPreviewPanel panel = QLPreviewPanel.sharedPreviewPanel();
        panel.setDataSource(this.model.id());
        super.willBeginQuickLook();
    }

    public void open() {
        QLPreviewPanel panel = QLPreviewPanel.sharedPreviewPanel();
        panel.makeKeyAndOrderFront(null);
    }

    public void close() {
        QLPreviewPanel panel = QLPreviewPanel.sharedPreviewPanel();
        NSNotificationCenter.defaultCenter().removeObserver(panel.id());
        panel.orderOut(null);
    }

    public void didEndQuickLook() {
        QLPreviewPanel panel = QLPreviewPanel.sharedPreviewPanel();
        panel.setDataSource(null);
        this.previews.clear();
        super.didEndQuickLook();
    }
}

