/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.serializer;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.serializer.SerializerFactory;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSMutableArray;
import ch.cyberduck.ui.cocoa.foundation.NSMutableDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlistSerializer
implements Serializer {
    final NSMutableDictionary dict;

    public static void register() {
        SerializerFactory.addFactory((Factory.Platform)Factory.NATIVE_PLATFORM, (SerializerFactory)new Factory());
    }

    public PlistSerializer() {
        this(NSMutableDictionary.dictionary());
    }

    public PlistSerializer(NSMutableDictionary dict) {
        this.dict = dict;
    }

    public void setStringForKey(String value, String key) {
        this.dict.setObjectForKey(value, key);
    }

    public void setObjectForKey(Serializable value, String key) {
        this.dict.setObjectForKey((NSObject)value.getAsDictionary(), key);
    }

    public <T extends Serializable> void setListForKey(List<T> value, String key) {
        NSMutableArray list = NSMutableArray.array();
        for (Serializable serializable : value) {
            list.addObject((NSObject)serializable.getAsDictionary());
        }
        this.dict.setObjectForKey(list, key);
    }

    public NSDictionary getSerialized() {
        return this.dict;
    }

    private static class Factory
    extends SerializerFactory {
        private Factory() {
        }

        protected Serializer create() {
            return new PlistSerializer();
        }
    }
}

