/*
 * Decompiled with CFR 0.152.
 */
package com.mosso.client.cloudfiles;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.log4j.Logger;

public class FilesResponse {
    private HttpMethod httpmethod = null;
    private static Logger logger = Logger.getLogger(FilesResponse.class);

    public FilesResponse(HttpMethod method) {
        this.httpmethod = method;
        if (logger.isDebugEnabled()) {
            Header[] reqHeaders;
            logger.debug((Object)("Request Method: " + method.getName()));
            logger.debug((Object)("Request Path: " + method.getPath()));
            logger.debug((Object)("Status Line: " + this.getStatusLine()));
            for (Header rH : reqHeaders = method.getRequestHeaders()) {
                logger.debug((Object)rH.toExternalForm());
            }
            Header[] responseHeaders = this.getResponseHeaders();
            for (int i = 0; i < responseHeaders.length; ++i) {
                logger.debug((Object)responseHeaders[i]);
            }
        }
    }

    public boolean loginSuccess() {
        if (this.getStatusCode() == 401) {
            return false;
        }
        return this.getStatusCode() == 204;
    }

    public String getAuthToken() {
        return this.getResponseHeader("X-Auth-Token").getValue();
    }

    public String getStorageURL() {
        return this.getResponseHeader("X-Storage-Url").getValue();
    }

    public String getCDNManagementURL() {
        Header header = this.getResponseHeader("X-CDN-Management-URL");
        return header == null ? null : header.getValue();
    }

    public String getContentType() {
        return this.getResponseHeader("Content-Type").getValue();
    }

    public String getContentLength() {
        Header hdr = this.getResponseHeader("Content-Length");
        if (hdr == null) {
            return "0";
        }
        return hdr.getValue();
    }

    public String getETag() {
        Header hdr = this.getResponseHeader("ETag");
        if (hdr == null) {
            return null;
        }
        return hdr.getValue();
    }

    public String getLastModified() {
        return this.getResponseHeader("Last-Modified").getValue();
    }

    public Header[] getResponseHeaders() {
        return this.httpmethod.getResponseHeaders();
    }

    public StatusLine getStatusLine() {
        return this.httpmethod.getStatusLine();
    }

    public int getStatusCode() {
        return this.httpmethod.getStatusCode();
    }

    public String getStatusMessage() {
        return this.httpmethod.getStatusText();
    }

    public String getMethodName() {
        return this.httpmethod.getName();
    }

    public String getResponseBodyAsString() throws IOException {
        return this.httpmethod.getResponseBodyAsString();
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        return this.httpmethod.getResponseBodyAsStream();
    }

    public byte[] getResponseBody() throws IOException {
        return this.httpmethod.getResponseBody();
    }

    public Header getResponseHeader(String headerName) {
        return this.httpmethod.getResponseHeader(headerName);
    }

    public int getContainerObjectCount() {
        Header contCountHeader = this.getResponseHeader("X-Container-Object-Count");
        if (contCountHeader != null) {
            return Integer.parseInt(contCountHeader.getValue());
        }
        return -1;
    }

    public long getContainerBytesUsed() {
        Header contBytesUsedHeader = this.getResponseHeader("X-Container-Bytes-Used");
        if (contBytesUsedHeader != null) {
            return Long.parseLong(contBytesUsedHeader.getValue());
        }
        return -1L;
    }

    public int getAccountContainerCount() {
        Header contCountHeader = this.getResponseHeader("X-Account-Container-Count");
        if (contCountHeader != null) {
            return Integer.parseInt(contCountHeader.getValue());
        }
        return -1;
    }

    public long getAccountBytesUsed() {
        Header accountBytesUsedHeader = this.getResponseHeader("X-Account-Bytes-Used");
        if (accountBytesUsedHeader != null) {
            return Long.parseLong(accountBytesUsedHeader.getValue());
        }
        return -1L;
    }

    public String getCdnUrl() {
        Header cdnHeader = this.getResponseHeader("X-CDN-URI");
        if (cdnHeader != null) {
            return cdnHeader.getValue();
        }
        return null;
    }

    public Header[] getResponseHeaders(String headerName) {
        return this.httpmethod.getResponseHeaders(headerName);
    }
}

