/*
 * Decompiled with CFR 0.152.
 */
package com.mosso.client.cloudfiles.sample;

import com.mosso.client.cloudfiles.FilesAccountInfo;
import com.mosso.client.cloudfiles.FilesClient;
import com.mosso.client.cloudfiles.FilesConstants;
import com.mosso.client.cloudfiles.FilesContainer;
import com.mosso.client.cloudfiles.FilesContainerExistsException;
import com.mosso.client.cloudfiles.FilesContainerInfo;
import com.mosso.client.cloudfiles.FilesContainerNotEmptyException;
import com.mosso.client.cloudfiles.FilesInvalidNameException;
import com.mosso.client.cloudfiles.FilesNotFoundException;
import com.mosso.client.cloudfiles.FilesObject;
import com.mosso.client.cloudfiles.FilesObjectMetaData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;

public class FilesCli {
    FilesClient client = null;
    BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
    private static final String HELP_STRING = "Commands:\n   get                               List the containers for this account\n   get container                     List the contents of the given container\n   get container/object destination  Download the given object and store it at the destination\n   head                              Get information about this account\n   head container                    Get the container's information\n   head container/object             Get the objects's information and metadata\n   put container                     Create the given container\n   put container localfile           Upload the local file to the container\n   delete container                  Delete the container\n   delete container/object           Delete the given object\n   help                              Print this help message\n   exit                              Exit the program\n";

    private boolean doLogin() {
        try {
            System.out.print("Username: ");
            String username = this.console.readLine().trim();
            System.out.print("Password: ");
            String password = this.console.readLine().trim();
            System.out.print("Account (return if using Mosso directly): ");
            String account = this.console.readLine().trim();
            if (account.length() == 0) {
                account = null;
            }
            this.client = new FilesClient(username, password, account);
            boolean result = this.client.login();
            if (result) {
                System.out.println("Logged in!");
            } else {
                System.out.println("Login failed");
            }
            return result;
        }
        catch (IOException e) {
            System.out.println("Error logging in!");
            e.printStackTrace();
            return false;
        }
    }

    private boolean evaluateCommand(String cmd) {
        cmd = cmd.trim();
        String[] components = cmd.split("\\s+");
        if (cmd.length() == 0 || "help".equals(components[0].toLowerCase())) {
            System.out.println(HELP_STRING);
            return true;
        }
        String command = components[0].toLowerCase();
        if ("exit".equals(command) || "quit".equals(command)) {
            System.out.println("Exiting");
            return false;
        }
        if ("get".equals(command)) {
            if (components.length == 1) {
                try {
                    List<FilesContainer> containers = this.client.listContainers();
                    int nContainers = containers.size();
                    System.out.println("The account has " + nContainers + (nContainers == 1 ? " container" : " containers"));
                    for (FilesContainer container : containers) {
                        System.out.println("   " + container.getName());
                    }
                    return true;
                }
                catch (Exception ex) {
                    System.out.println("Problem listing containers");
                    ex.printStackTrace();
                    return true;
                }
            }
            String name = components[1];
            int slashLocation = name.indexOf(47);
            if (slashLocation == -1) {
                try {
                    List<FilesObject> objects = this.client.listObjects(name);
                    if (objects.size() == 0) {
                        System.out.println("Container " + name + " was empty");
                        return true;
                    }
                    System.out.println("Contents of " + name + ":");
                    for (FilesObject obj : objects) {
                        System.out.println("  " + obj.getName() + " " + obj.getSizeString());
                    }
                    System.out.println();
                }
                catch (Exception e) {
                    System.out.println("Error trying to list container contents");
                    e.printStackTrace();
                    return true;
                }
            }
            if (components.length != 3) {
                System.out.println("usage:  get container/filename.ext destination.ext");
                return true;
            }
            String container = name.substring(0, slashLocation);
            String object = name.substring(slashLocation + 1);
            String destination = components[2];
            try {
                InputStream is = this.client.getObjectAsStream(container, object);
                FileOutputStream fos = new FileOutputStream(destination);
                byte[] buffer = new byte[4096];
                int read = -1;
                while ((read = is.read(buffer)) > 0) {
                    fos.write(buffer, 0, read);
                }
                fos.close();
                is.close();
                System.out.println(name + " downlaoded to " + destination);
            }
            catch (Exception ex) {
                System.out.println("Problem getting " + name);
                ex.printStackTrace();
                return true;
            }
            return true;
        }
        if ("head".equals(command)) {
            if (components.length == 1) {
                try {
                    FilesAccountInfo info = this.client.getAccountInfo();
                    System.out.println("Account information:");
                    System.out.println("  Number of Containers: " + info.getContainerCount());
                    System.out.println("    Total Account Size: " + info.getBytesUsed());
                    System.out.println();
                }
                catch (Exception e) {
                    System.err.println("Error getting container info");
                    e.printStackTrace();
                    return true;
                }
            }
            DecimalFormat format = new DecimalFormat();
            for (int i = 1; i < components.length; ++i) {
                String name = components[i];
                int slashLocation = name.indexOf(47);
                if (slashLocation == -1) {
                    try {
                        FilesContainerInfo containerInfo = this.client.getContainerInfo(name);
                        System.out.println("Information for " + name);
                        System.out.println("  Object Count: " + containerInfo.getObjectCount());
                        System.out.println("    Total Size: " + format.format(containerInfo.getTotalSize()) + " bytes");
                        System.out.println();
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println("Error getting container info");
                        e.printStackTrace();
                        return true;
                    }
                }
                String container = name.substring(0, slashLocation);
                String object = name.substring(slashLocation + 1);
                try {
                    FilesObjectMetaData metadata = this.client.getObjectMetaData(container, object);
                    if (metadata == null) {
                        System.out.println("Could not get metadata for " + name);
                        continue;
                    }
                    System.out.println("LGV: " + container + ":" + object + ":" + metadata);
                    System.out.println("Information for " + name);
                    System.out.println("  Total Size: " + metadata.getContentLength() + " bytes");
                    System.out.println("  MIME type: " + metadata.getMimeType());
                    Map<String, String> md = metadata.getMetaData();
                    if (md.size() == 0) {
                        System.out.println("  Contains no metadata");
                    } else {
                        System.out.println("  Metadata:");
                        for (String key : md.keySet()) {
                            System.out.println("    " + key + " => " + md.get(key));
                        }
                    }
                    System.out.println();
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error getting object info");
                    e.printStackTrace();
                    return true;
                }
            }
            return true;
        }
        if ("put".equals(command)) {
            if (components.length == 2) {
                String newContainerName = components[1];
                if (newContainerName.indexOf(47) != -1) {
                    System.out.println("Container names may not contain slashes");
                    return true;
                }
                try {
                    this.client.createContainer(newContainerName);
                }
                catch (FilesContainerExistsException fcee) {
                    System.out.println(newContainerName + " already existed");
                }
                catch (Exception e) {
                    System.out.println("Error creating container");
                    e.printStackTrace();
                    return true;
                }
                return true;
            }
            if (components.length == 3) {
                String containerName = components[1];
                String filename = components[2];
                File file = new File(filename);
                if (!file.exists()) {
                    System.out.println("Could not find file " + file.getAbsolutePath());
                    return true;
                }
                String name = file.getName();
                String extention = "";
                int dotLocation = name.lastIndexOf(46);
                if (dotLocation > 0) {
                    extention = name.substring(dotLocation + 1);
                }
                String mimeType = FilesConstants.getMimetype(extention);
                try {
                    if (!this.client.containerExists(containerName)) {
                        System.out.println("Container " + containerName + " does not exist");
                        return true;
                    }
                    if (this.client.storeObject(containerName, file, mimeType)) {
                        System.out.println("Object " + file.getName() + " was created");
                    }
                    return true;
                }
                catch (Exception e) {
                    System.out.println("Problem uploading file");
                    e.printStackTrace();
                    return true;
                }
            }
            System.out.println("Usage:\n  put container\n  put container file");
            return true;
        }
        if ("delete".equals(command)) {
            for (int i = 1; i < components.length; ++i) {
                String name = components[i];
                int slashLocation = name.indexOf(47);
                if (slashLocation == -1) {
                    boolean returnCode = false;
                    try {
                        returnCode = this.client.deleteContainer(name);
                    }
                    catch (FilesInvalidNameException fine) {
                        System.out.println(name + " is not a valid container name");
                    }
                    catch (FilesNotFoundException fine) {
                        System.out.println(name + " could not be found");
                    }
                    catch (FilesContainerNotEmptyException fine) {
                        System.out.println(name + " was not empty.  Please delete the contents and try again");
                    }
                    catch (Exception e) {
                        System.out.println("Error deleting container");
                        e.printStackTrace();
                        return true;
                    }
                    if (returnCode) {
                        System.out.println("Container \"" + name + "\" deleted");
                        continue;
                    }
                    System.out.println("Unexpected result deleting container ");
                    continue;
                }
                String container = name.substring(0, slashLocation);
                String object = name.substring(slashLocation + 1);
                try {
                    this.client.deleteObject(container, object);
                    System.out.println("Object \"" + name + "\" deleted");
                    continue;
                }
                catch (FilesNotFoundException fnfe) {
                    System.out.println(name + " could not be found");
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Error deleting object");
                    e.printStackTrace();
                    return true;
                }
            }
            return true;
        }
        System.out.println("Unrecognized command " + cmd);
        System.out.println(HELP_STRING);
        return true;
    }

    public static void main(String[] args) {
        FilesCli commandLine = new FilesCli();
        if (commandLine.doLogin()) {
            System.out.println("Type 'help' for assistance");
            String cmd = "";
            do {
                String account;
                account = (account = commandLine.client.getAccount()) == null ? commandLine.client.getUserName() : account;
                System.out.print(account + ": ");
                try {
                    cmd = commandLine.console.readLine();
                }
                catch (IOException e) {
                    cmd = "";
                }
            } while (commandLine.evaluateCommand(cmd));
            System.exit(0);
        } else {
            System.err.println("Login failed");
            System.exit(-1);
        }
    }
}

