/*
 * Decompiled with CFR 0.152.
 */
package com.mosso.client.cloudfiles.sample;

import com.mosso.client.cloudfiles.FilesClient;
import com.mosso.client.cloudfiles.FilesContainer;
import com.mosso.client.cloudfiles.FilesContainerInfo;
import com.mosso.client.cloudfiles.FilesException;
import com.mosso.client.cloudfiles.FilesObject;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.lang.StringUtils;

public class FilesList {
    public static void main(String[] args) {
        Options options = FilesList.addCommandLineOptions();
        if (args.length <= 0) {
            FilesList.printHelp(options);
        }
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help")) {
                FilesList.printHelp(options);
            }
            if (line.hasOption("containersOnly")) {
                if (line.hasOption("H")) {
                    FilesList.printContainers(true);
                } else {
                    FilesList.printContainers(false);
                }
            } else if (line.hasOption("all")) {
                if (line.hasOption("H")) {
                    FilesList.printContainersAll(true);
                } else {
                    FilesList.printContainersAll(false);
                }
            } else if (line.hasOption("container")) {
                String containerName = line.getOptionValue("container");
                if (StringUtils.isNotBlank((String)containerName)) {
                    if (line.hasOption("H")) {
                        FilesList.printContainer(containerName, true);
                    } else {
                        FilesList.printContainer(containerName, false);
                    }
                }
            } else if (line.hasOption("H")) {
                System.out.println("This option needs to be used in conjunction with another option that lists objects or container.");
            }
        }
        catch (ParseException err) {
            System.err.println("Please see the logs for more details. Error Message: " + err.getMessage());
            err.printStackTrace(System.err);
        }
        catch (FilesException err) {
            System.err.println("Please see the logs for more details. Error Message: " + err.getMessage());
        }
        catch (IOException err) {
            System.err.println("Please see the logs for more details. Error Message: " + err.getMessage());
        }
    }

    private static void printContainer(String containerName, boolean humanReadable) throws IOException, HttpException, FilesException {
        boolean notFound = true;
        FilesClient client = new FilesClient();
        if (client.login()) {
            List<FilesContainer> containers = client.listContainers();
            System.out.println(client.getAccount() + " containers: ");
            for (FilesContainer value : containers) {
                if (value.getName().equalsIgnoreCase(containerName)) {
                    notFound = false;
                    FilesContainerInfo info = value.getInfo();
                    System.out.println("\t" + value.getName() + " - " + info.getObjectCount() + " objects:");
                    List<FilesObject> objects = value.getObjects();
                    for (FilesObject obj : objects) {
                        if (humanReadable) {
                            System.out.println("\t\t" + StringUtils.rightPad((String)obj.getName(), (int)35) + obj.getSizeString());
                            continue;
                        }
                        System.out.println("\t\t" + StringUtils.rightPad((String)obj.getName(), (int)35) + obj.getSize() + " Bytes");
                    }
                    if (humanReadable) {
                        System.out.println("\tTotal Size: " + info.getTotalSize() / 1024L + "KB\n");
                        continue;
                    }
                    System.out.println("\tTotal Size: " + info.getTotalSize() + "Bytes\n");
                    continue;
                }
                notFound = true;
            }
            if (notFound) {
                System.out.println("Container: " + containerName + " was not found !");
            }
        }
    }

    private static void printContainersAll(boolean humanReadable) throws IOException, HttpException, FilesException {
        FilesClient client = new FilesClient();
        if (client.login()) {
            List<FilesContainer> containers = client.listContainers();
            System.out.println(client.getAccount() + " containers: ");
            for (FilesContainer value : containers) {
                FilesContainerInfo info = value.getInfo();
                System.out.println("\t" + value.getName() + " - " + info.getObjectCount() + " objects:");
                List<FilesObject> objects = value.getObjects();
                for (FilesObject obj : objects) {
                    if (humanReadable) {
                        System.out.println("\t\t" + StringUtils.rightPad((String)obj.getName(), (int)35) + obj.getSizeString());
                        continue;
                    }
                    System.out.println("\t\t" + StringUtils.rightPad((String)obj.getName(), (int)35) + obj.getSize() + "Bytes");
                }
                if (humanReadable) {
                    System.out.println("\tTotal Size: " + info.getTotalSize() / 1024L + "KB\n");
                    continue;
                }
                System.out.println("\tTotal Size: " + info.getTotalSize() + "Bytes\n");
            }
        }
    }

    private static void printContainers(boolean humanReadable) throws IOException, HttpException, FilesException {
        FilesClient client = new FilesClient();
        if (client.login()) {
            List<FilesContainer> containers = client.listContainers();
            System.out.println(client.getAccount() + " containers: ");
            for (FilesContainer value : containers) {
                FilesContainerInfo info = value.getInfo();
                System.out.println("\t" + value.getName() + " - " + info.getObjectCount() + " objects:");
                if (humanReadable) {
                    System.out.println("\tTotal Size: " + FilesList.getSizeString(info.getTotalSize()) + "\n");
                    continue;
                }
                System.out.println("\tTotal Size: " + info.getTotalSize() + "Bytes\n");
            }
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("FilesList", options);
    }

    private static Options addCommandLineOptions() {
        Option help = new Option("help", "print this message");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Show ONLY Containers in account.  No Object information is provided.");
        Option containersOnly = OptionBuilder.create((String)"containersOnly");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Show Containers and their objects in this account");
        Option containers = OptionBuilder.create((String)"all");
        OptionBuilder.withArgName((String)"container");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"Show Containers and their objects in this account");
        Option container = OptionBuilder.create((String)"container");
        Option kb = new Option("H", "humanReadable", false, "Show size of objects in human readable form.  On its own this has no meaning and needs to be used in conjuction to a command that provides size of objects and containers");
        Options options = new Options();
        options.addOption(containersOnly);
        options.addOption(containers);
        options.addOption(container);
        options.addOption(kb);
        options.addOption(help);
        return options;
    }

    public static String getSizeString(long size) {
        long kb = 1024L;
        long mb = 0x100000L;
        long gb = 0x40000000L;
        if (size > gb) {
            return size / gb + "GB";
        }
        if (size > mb) {
            return size / mb + "MB";
        }
        if (size > kb) {
            return size / kb + "KB";
        }
        return size + "Bytes";
    }
}

